local assets_spirit=
{
	Asset("ANIM", "anim/wharang_spirit_fx.zip"),
}

local assets_spirit_evil=
{
	Asset("ANIM", "anim/wharang_spirit_evil_fx.zip"),
}

local assets_single_firework=
{
	Asset("ANIM", "anim/accomplishment_fireworks.zip"),
}

local assets_multi_firework=
{
	Asset("ANIM", "anim/accomplishment_fireworks.zip"),
}

local assets_fire=
{
	Asset("ANIM", "anim/wharang_fire_fx.zip"),
}

local assets_ground_fire=
{
	Asset("ANIM", "anim/wharang_ground_fire_fx.zip"),
	
}

local assets_firering=
{
	Asset("ANIM", "anim/wharang_ring_fx.zip"),
	
}

local function kill(inst)
	inst:Remove()
end

local function fn_spirit(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddSoundEmitter()
    inst.AnimState:SetBank("wharang_spirit")
    inst.AnimState:SetBuild("wharang_spirit")
    inst:AddTag("NOCLICK")
	inst:AddTag("FX")
	inst.persists = false

    inst.AnimState:PlayAnimation("wharang_spirit")
    inst:ListenForEvent("animover", function() inst:Remove() end)
    inst.SoundEmitter:PlaySound("dontstarve_DLC001/characters/wathgrithr/valhalla")
    return inst
end

local function fn_evil(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.AnimState:SetBank("wharang_spirit_evil")
    inst.AnimState:SetBuild("wharang_spirit_evil")
    inst:AddTag("NOCLICK")
	inst:AddTag("FX")
	inst.persists = false

    inst.AnimState:PlayAnimation("wharang_spirit_evil")
    inst:ListenForEvent("animover", function() inst:Remove() end)
    inst.SoundEmitter:PlaySound("dontstarve_DLC001/characters/wathgrithr/valhalla")
    return inst
end

local function fn_single(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddSoundEmitter()
    inst.AnimState:SetBank("firework")
    inst.AnimState:SetBuild("accomplishment_fireworks")
    inst:AddTag("NOCLICK")
	inst:AddTag("FX")
	inst.persists = false

    inst.AnimState:PlayAnimation("single_firework")
	inst.SoundEmitter:PlaySound("dontstarve/common/shrine/sadwork_fire")
    inst:ListenForEvent("animover", function() inst:Remove() end)
    return inst
end

local function fn_multi(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.AnimState:SetBank("firework")
    inst.AnimState:SetBuild("accomplishment_fireworks")
    inst:AddTag("NOCLICK")
	inst:AddTag("FX")
	inst.persists = false

    inst.AnimState:PlayAnimation("multi_firework")
	inst.SoundEmitter:PlaySound("dontstarve/common/shrine/sadwork_fire")
	inst:DoTaskInTime( 26/30, function() inst.SoundEmitter:PlaySound("dontstarve/common/shrine/firework_explo") end)
    inst:ListenForEvent("animover", function() inst:Remove() end)
    return inst
end

local function fn_fire(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.AnimState:SetBank("dragonfly_fx")
    inst.AnimState:SetBuild("wharang_fire_fx")
    inst:AddTag("NOCLICK")
	inst:AddTag("FX")
	inst.persists = false

    inst.AnimState:PlayAnimation("taunt")
    inst:ListenForEvent("animover", function() inst:Remove() end)
    return inst
end

local function fn_ground_fire(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.AnimState:SetBank("dragonfly_ground_fx")
    inst.AnimState:SetBuild("wharang_ground_fire_fx")
    inst:AddTag("NOCLICK")
	inst:AddTag("FX")
	inst.persists = false

    inst.AnimState:PlayAnimation("idle")
    inst:ListenForEvent("animover", function() inst:Remove() end)
    return inst
end

local function fn_firering(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.AnimState:SetBank("dragonfly_ring_fx")
    inst.AnimState:SetBuild("wharang_ring_fx")
    inst:AddTag("NOCLICK")
	inst:AddTag("FX")
	inst.persists = false

    inst.AnimState:PlayAnimation("idle")
    inst:ListenForEvent("animover", function() inst:Remove() end)
    return inst
end

return  Prefab( "fx/wharang_spiritfx", fn_spirit, assets_spirit),
		Prefab( "fx/wharang_spirit_evilfx", fn_evil, assets_spirit_evil),
		Prefab( "fx/wharang_fireworkfx", fn_single, assets_single_firework),
		Prefab( "fx/wharang_multifireworkfx", fn_multi, assets_multi_firework),
		Prefab( "fx/wharang_firefx", fn_fire, assets_fire),
		Prefab( "fx/wharang_ground_firefx", fn_ground_fire, assets_ground_fire),
		Prefab( "fx/wharang_ringfx", fn_firering, assets_firering)