-- Meet him in the beta version!
-- We're continuing to prepare for the beta.

local GuideScreen = require "screens/messagescreen"

local assets=
{
	Asset("ANIM", "anim/eventletter.zip"),
	Asset("ATLAS", "images/inventoryimages/why.xml")
}
local messages = {"dearmysister", "getsoulhearts", "newcharacter"}

local function FuelTaken(inst, taker)
	SpawnPrefab("statue_transition").Transform:SetPosition(taker.Transform:GetWorldPosition())
	SpawnPrefab("statue_transition_2").Transform:SetPosition(taker.Transform:GetWorldPosition())
    local cloud = SpawnPrefab("poopcloud")
    if cloud then
        cloud.Transform:SetPosition(taker.Transform:GetWorldPosition())
    end
end

local function Open(inst)
	if inst.components.inventoryitem.owner and inst.components.inventoryitem.owner.HUD then
		TheFrontEnd:PushScreen(GuideScreen(inst))
	end
	inst:Remove()
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("iwanttosay")
    inst.AnimState:SetBuild("eventletter")
    inst.AnimState:PlayAnimation("anim")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem:ChangeImageName("why")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/why.xml"
	
	inst:AddComponent("inspectable")
	
	inst:AddTag("irreplacable")
	
    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.LARGE_FUEL
	inst.components.fuel:SetOnTakenFn(FuelTaken)
	
    inst:AddComponent("characterspecific")
    inst.components.characterspecific:SetOwner("wharang")
	
	inst:AddComponent("useableitem")
	inst.mymessage = messages[math.random(#messages)]
	inst.components.useableitem.onusefn = Open
	inst.components.useableitem.caninteractfn = function() return true end
	
	inst.OnSave = function(inst, data)
        data.mymessage = inst.mymessage
    end  
    inst.OnLoad = function(inst, data)    
		if data then
			inst.mymessage = data.mymessage
		end
    end
	
    return inst
end

return Prefab("common/inventory/unknownlettertowharang",fn,assets)