modimport ("scripts/tuning_willette.lua")

PrefabFiles = {
	"willette",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/willette.tex" ),
	Asset( "ATLAS", "images/saveslot_portraits/willette.xml" ),
    Asset( "IMAGE", "images/selectscreen_portraits/willette.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/willette_silho.tex" ),
	Asset( "ATLAS", "images/selectscreen_portraits/willette_silho.xml" ),
	Asset( "ATLAS", "images/selectscreen_portraits/willette.xml" ),
	Asset( "IMAGE", "bigportraits/willette.tex" ),
	Asset( "ATLAS", "bigportraits/willette.xml" ),
}

local food_adjust_factors = {
	cookedmonstermeat = {
		health = -5/3,		--3 health
		sanity = -1/2,		--5 sanity
	},
	monsterlasagna = {
		health = -3/2,		--30 health
		sanity = -1,		--20 sanity
	},
	monstermeat = {
		health = -1/20,		--1 health
		sanity = -1/5,		--3 sanity
	},
	monstermeat_dried = {
		health = -5,		--15 health
		sanity = -2,		--10 sanity
	},
}

local food_adjust_factors_default = {
	health = 0.5,
	sanity = 0.5,
}

--I've created a monster!
local function FoodAdjust(inst)
	local factors = inst.prefab and food_adjust_factors[inst.prefab] or food_adjust_factors_default

	inst:DoTaskInTime(0, function(inst)
		if GLOBAL.GetPlayer().prefab == "willette" and inst.components.edible then
			for k, v in pairs(factors) do
				inst.components.edible[k .. "value"] = inst.components.edible[k .. "value"]*v
			end
		end
	end)
end

for k, fooditem in pairs(TUNING.WILLETTE_FOODS) do
    AddPrefabPostInit(fooditem, FoodAdjust)
end

GLOBAL.STRINGS.CHARACTER_NAMES.willette = "Willette"
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "willette")
AddModCharacter("willette")