﻿/**
 * menubutton - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights reserved. 
 * Licensed under the GPL or commercial licenses 
 */
(function($) {
	function create(target) {
		var definations = $.data(target, "menubutton").definations;
		var menubuttonObj = $(target);
		menubuttonObj.removeClass("m-btn-active m-btn-plain-active").addClass("m-btn");
		menubuttonObj.linkbutton($.extend({}, definations, { text : definations.text
		        + "<span class=\"m-btn-downarrow\">&nbsp;</span>" }));
		if (definations.menu) {
			$(definations.menu).menu({ onShow : function() {
				menubuttonObj.addClass((definations.plain == true) ? "m-btn-plain-active" : "m-btn-active");
			}, onHide : function() {
				menubuttonObj.removeClass((definations.plain == true) ? "m-btn-plain-active" : "m-btn-active");
			} });
		}
		menuButtonEvent(target, definations.disabled);
	}
	;
	function menuButtonEvent(target, disableFlag) {
		var definations = $.data(target, "menubutton").definations;
		definations.disabled = disableFlag;
		var menubuttonObj = $(target);
		if (disableFlag) {
			menubuttonObj.linkbutton("disable");
			menubuttonObj.unbind(".menubutton");
		} else {
			menubuttonObj.linkbutton("enable");
			menubuttonObj.unbind(".menubutton");
			menubuttonObj.bind("click.menubutton", function() {
				menuShowHide();
				return false;
			});
			var fun = null;
			menubuttonObj.bind("mouseenter.menubutton", function() {
				fun = setTimeout(function() {
					menuShowHide();
				}, definations.duration);
				return false;
			}).bind("mouseleave.menubutton", function() {
				if (fun) {
					clearTimeout(fun);
				}
			});
		}
		function menuShowHide() {
			if (!definations.menu) {
				return;
			}
			$("body>div.menu-top").menu("hide");
			$(definations.menu).menu("show", { alignTo : menubuttonObj });
			menubuttonObj.blur();
		}
		;
	}
	;
	$.fn.menubutton = function(definations, param) {
		if (typeof definations == "string") {
			return $.fn.menubutton.methods[definations](this, param);
		}
		definations = definations || {};
		return this.each(function() {
			var menubutton = $.data(this, "menubutton");
			if (menubutton) {
				$.extend(menubutton.definations, definations);
			} else {
				$.data(this, "menubutton", { definations : $.extend({}, $.fn.menubutton.defaults, $.fn.menubutton
				        .parseDefinations(this), definations) });
				$(this).removeAttr("disabled");
			}
			create(this);
		});
	};
	$.fn.menubutton.methods = { definations : function(jq) {
		return $.data(jq[0], "menubutton").definations;
	}, enable : function(jq) {
		return jq.each(function() {
			menuButtonEvent(this, false);
		});
	}, disable : function(jq) {
		return jq.each(function() {
			menuButtonEvent(this, true);
		});
	}, destroy : function(jq) {
		return jq.each(function() {
			var definations = $(this).menubutton("definations");
			if (definations.menu) {
				$(definations.menu).menu("destroy");
			}
			$(this).remove();
		});
	} };
	$.fn.menubutton.parseDefinations = function(param) {
		var t = $(param);
		return $.extend({}, $.fn.linkbutton.parseDefinations(param), $.parser.parseDefinations(param, [ "menu",
		        { plain : "boolean", duration : "number" } ]));
	};
	$.fn.menubutton.defaults = $.extend({}, $.fn.linkbutton.defaults, { plain : true, menu : null, duration : 100 });
})(jQuery);
