﻿/**
 * iconvalidation - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All
 * rights reserved. Licensed under the GPL or commercial licenses
 */
(function($) {
	function setSize(target, sizeValue) {
		var inputiconboxDefinations = $.data(target, "inputiconbox").definations;
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		if (sizeValue) {
			inputiconboxDefinations.width = sizeValue;
		} 
		var inputiconboxTextObj = inputiconboxObj.find("input.inputiconbox-text");
		var inputiconboxIconObj = inputiconboxObj.find(".inputiconbox-icon");
		var iconWidth = inputiconboxDefinations.hasIcon ? inputiconboxIconObj._outerWidth() : 0;
		// inputiconboxTextObj._outerWidth(inputiconboxObj.width() -
		// iconWidth);
		var oWidth = inputiconboxObj.width();
		var textWidth = (oWidth - iconWidth - 3) / oWidth;
		textWidth = textWidth.toFixed(2) * 100;
		textWidth = textWidth + "%";
		inputiconboxTextObj.css({
		    width : textWidth,
		    height : inputiconboxObj.height() + "px",
		    lineHeight : inputiconboxObj.height() + "px"
		});
		inputiconboxIconObj._outerHeight(inputiconboxObj.height());
	}
	;
	function setIconShowOrHide(target) {
		var inputiconboxDefinations = $.data(target, "inputiconbox").definations;
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		if (inputiconboxDefinations.hasIcon) {
			inputiconboxObj.find(".inputiconbox-icon").show();
		} else {
			inputiconboxObj.find(".inputiconbox-icon").hide();
		}
	}
	;
	function createIconinputboxObj(target, definations) {
		$(target).addClass("inputiconbox-f").hide();
		var inputiconboxObj = null;
		if (definations.cusCls) {
			inputiconboxObj = $("<span class=\"inputiconbox\"></span>").addClass(definations.cusCls)
			        .insertAfter(target);
		} else {
			inputiconboxObj = $("<span class=\"inputiconbox\"></span>").insertAfter(target);
		}
		var inputiconboxTextObj = $("<input type=\"text\" class=\"inputiconbox-text\">").appendTo(inputiconboxObj);
		if (definations.iconCls) {
			$("<span class=\"inputiconbox-icon\"></span>").addClass(definations.iconCls).appendTo(inputiconboxObj);
		} else {
			$("<span><span class=\"inputiconbox-icon\"></span></span>").appendTo(inputiconboxObj);
		}
		var inputiconboxPropertyName = $(target).attr("name");
		if (inputiconboxPropertyName) {
			inputiconboxObj.find("input.inputiconbox-text").attr("name", inputiconboxPropertyName);
			$(target).removeAttr("name").attr("inputiconboxName", inputiconboxPropertyName);
		}
		inputiconboxTextObj.attr("autocomplete", "off");
		return {
			inputiconbox : inputiconboxObj
		};
	}
	;
	function destroy(target) {
		var inputiconboxTextObj = $.data(target, "inputiconbox").inputiconbox.find("input.inputiconbox-text");
		inputiconboxTextObj.inputbox("destroy");
		$.data(target, "inputiconbox").inputiconbox.remove();
		$(target).remove();
	}
	;
	function bindEvents(target) {
		var inputiconboxObj = $.data(target, "inputiconbox");
		var inputiconboxDefinations = inputiconboxObj.definations;
		var inputiconboxObjInner = $.data(target, "inputiconbox").inputiconbox;
		var inputiconboxText = inputiconboxObjInner.find(".inputiconbox-text");
		var inputiconboxIcon = inputiconboxObjInner.find(".inputiconbox-icon");
		$(document).unbind(".inputiconbox").bind("mousedown.inputiconbox", function(e) {
			
		});
		inputiconboxObjInner.unbind(".inputiconbox");
		inputiconboxText.unbind(".inputiconbox");
		inputiconboxIcon.unbind(".inputiconbox");
		if (!inputiconboxDefinations.disabled) {
			inputiconboxText.bind("mousedown.inputiconbox", function(e) {
				e.stopPropagation();
			}).bind("keydown.inputiconbox", function(e) {
				switch (e.keyCode) {
				case 38:
					inputiconboxDefinations.keyHandler.up.call(target);
					break;
				case 40:
					inputiconboxDefinations.keyHandler.down.call(target);
					break;
				case 13:
					e.preventDefault();
					inputiconboxDefinations.keyHandler.enter.call(target);
					return false;
				case 9:
				case 27:
					break;
				default:
					if (inputiconboxDefinations.editable) {
						if (inputiconboxObj.timer) {
							clearTimeout(inputiconboxObj.timer);
						}
						inputiconboxObj.timer = setTimeout(function() {
							var q = inputiconboxText.val();
							if (inputiconboxObj.previousValue != q) {
								inputiconboxObj.previousValue = q;
								inputiconboxDefinations.keyHandler.query.call(target, inputiconboxText.val());
								validate(target, true);
							}
						}, inputiconboxDefinations.delay);
					}
				}
			});
			inputiconboxIcon.bind("click.inputiconbox", function() {
				if(inputiconboxDefinations.iconClick){
					inputiconboxDefinations.value = inputiconboxText.val();
					var name = inputiconboxText.attr("name");
					inputiconboxDefinations.iconClick.call(target, inputiconboxDefinations.value, name);
					inputiconboxText.focus();
				}
			}).bind("mouseenter.inputiconbox", function() {
				$(this).addClass("inputiconbox-icon-hover");
			}).bind("mouseleave.inputiconbox", function() {
				$(this).removeClass("inputiconbox-icon-hover");
			}).bind("mousedown.inputiconbox", function() {
			});
		}
	}
	;
	function validate(target, validateFlag) {
		var inputiconboxDefinations = $.data(target, "inputiconbox").definations;
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox.find("input.inputiconbox-text");
		inputiconboxObj.inputbox(inputiconboxDefinations);
		if (validateFlag) {
			inputiconboxObj.inputbox("validate");
		}
	}
	;
	function setDisabled(target, flag) {
		var inputiconboxDefinations = $.data(target, "inputiconbox").definations;
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		if (flag) {
			inputiconboxDefinations.disabled = true;
			$(target).attr("disabled", true);
			inputiconboxObj.find(".inputiconbox-text").attr("disabled", true);
		} else {
			inputiconboxDefinations.disabled = false;
			$(target).removeAttr("disabled");
			inputiconboxObj.find(".inputiconbox-text").removeAttr("disabled");
		}
	}
	;
	function clear(target) {
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		inputiconboxObj.find("input.inputiconbox-text").val("");
	}
	;
	function getIconinputboxValue(target) {
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		return inputiconboxObj.find("input.inputiconbox-text").val();
	}
	;
	function setIconinputboxValue(target, textValue) {
		var inputiconboxObj = $.data(target, "inputiconbox").inputiconbox;
		inputiconboxObj.find("input.inputiconbox-text").val(textValue);
		validate(target, true);
		$.data(target, "inputiconbox").previousValue = textValue;
	}
	;
	function inputiconboxOnChange(inputiconboxObj) {
		var inputiconboxDefinations = $.data(inputiconboxObj, "inputiconbox").definations;
		var fn = inputiconboxDefinations.onChange;
		inputiconboxDefinations.onChange = function() {
		};
		setIconinputboxValue(inputiconboxObj, inputiconboxDefinations.value);
		inputiconboxDefinations.originalValue = inputiconboxDefinations.value;
		inputiconboxDefinations.onChange = fn;
	}
	;
	$.fn.inputiconbox = function(definations, param) {
		if (typeof definations == "string") {
			return $.fn.inputiconbox.methods[definations](this, param);
		}
		definations = definations || {};
		return this.each(function() {
			var inputiconboxObj = $.data(this, "inputiconbox");
			if (inputiconboxObj) {
				$.extend(inputiconboxObj.definations, definations);
			} else {
				var newDefinations = $.extend({}, $.fn.inputiconbox.defaults, $.fn.inputiconbox.parseDefinations(this),
				        definations);
				var r = createIconinputboxObj(this, newDefinations);
				inputiconboxObj = $.data(this, "inputiconbox", {
				    definations : newDefinations,
				    inputiconbox : r.inputiconbox,
				    previousValue : null
				});
				$(this).removeAttr("disabled");
			}
			$("input.inputiconbox-text", inputiconboxObj.inputiconbox).attr("readonly",
			        !inputiconboxObj.definations.editable);
			setIconShowOrHide(this);
			setDisabled(this, inputiconboxObj.definations.disabled);
			setSize(this);
			bindEvents(this);
			validate(this);
			inputiconboxOnChange(this);
		});
	};
	$.fn.inputiconbox.methods = {
	    definations : function(jq) {
		    return $.data(jq[0], "inputiconbox").definations;
	    },
	    textbox : function(jq) {
		    return $.data(jq[0], "inputiconbox").inputiconbox.find("input.inputiconbox-text");
	    },
	    destroy : function(jq) {
		    return jq.each(function() {
			    destroy(this);
		    });
	    },
	    resize : function(jq, width) {
		    return jq.each(function() {
			    setSize(this, width);
		    });
	    },
	    disable : function(jq) {
		    return jq.each(function() {
			    setDisabled(this, true);
			    bindEvents(this);
		    });
	    },
	    enable : function(jq) {
		    return jq.each(function() {
			    setDisabled(this, false);
			    bindEvents(this);
		    });
	    },
	    validate : function(jq) {
		    return jq.each(function() {
			    validate(this, true);
		    });
	    },
	    isValid : function(jq) {
		    var inputiconboxTextObj = $.data(jq[0], "inputiconbox").inputiconbox.find("input.inputiconbox-text");
		    return inputiconboxTextObj.inputbox("isValid");
	    },
	    clear : function(jq) {
		    return jq.each(function() {
			    clear(this);
		    });
	    },
	    reset : function(jq) {
		    return jq.each(function() {
			    var inputiconboxDefinations = $.data(this, "inputiconbox").definations;
			    $(this).inputiconbox("setValue", inputiconboxDefinations.originalValue);
		    });
	    },
	    getValue : function(jq) {
		    return getIconinputboxValue(jq[0]);
	    },
	    setValue : function(jq, v) {
		    return jq.each(function() {
			    setIconinputboxValue(this, v);
		    });
	    }
	};
	$.fn.inputiconbox.parseDefinations = function(target) {
		var t = $(target);
		return $.extend({}, $.fn.inputbox.parseDefinations(target), $.parser.parseDefinations(target, [ "width",
		        "height", "separator", {
		            editable : "boolean",
		            hasIcon : "boolean",
		            delay : "number"
		        } ]), {
		    multiple : (t.attr("multiple") ? true : undefined),
		    disabled : (t.attr("disabled") ? true : undefined),
		    value : (t.val() || undefined),
		    iconClick : (t.attr("iconClick") ? $.parser.localEval(t.attr("iconClick")) : undefined)
		});
	};
	$.fn.inputiconbox.defaults = $.extend({}, $.fn.inputbox.defaults, {
	    cusCls : null,
	    iconCls : null,
	    width : "auto",
	    height : 22,
	    multiple : false,
	    separator : ",",
	    editable : true,
	    disabled : false,
	    hasIcon : true,
	    value : "",
	    delay : 200,
	    keyHandler : {
	        up : function() {
	        },
	        down : function() {
	        },
	        enter : function() {
	        },
	        query : function(q) {
	        }
	    },
	    onChange : function(target, v) {
	    }
	});
})(jQuery);
