/**
 * iconvalidation - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All
 * rights reserved. Licensed under the GPL or commercial licenses
 */
(function($) {
	function setSize(target, sizeValue) {
		var fileboxDefinations = $.data(target, "filebox").definations;
		var fileboxObj = $.data(target, "filebox").filebox;
		if (sizeValue) {
			fileboxDefinations.width = sizeValue;
		}
		var fileboxFileObj = fileboxObj.find("input.filebox-file");
		var fileboxTextObj = fileboxObj.find(".filebox-text");
		var fileboxIconObj = fileboxObj.find(".filebox-icon");
		var iconWidth = fileboxIconObj._outerWidth();
		var outerWidth = fileboxObj._outerWidth();
		var textWidth = outerWidth - iconWidth;
		fileboxTextObj._outerWidth(textWidth);
		var w = fileboxObj._outerWidth() - fileboxTextObj._outerWidth();
		fileboxFileObj._outerWidth(w);
	}
	;
	function setIconShowOrHide(target) {
		var fileboxDefinations = $.data(target, "filebox").definations;
		var fileboxObj = $.data(target, "filebox").filebox;
		if (fileboxDefinations.hasIcon) {
			fileboxObj.find(".filebox-icon").show();
		} else {
			fileboxObj.find(".filebox-icon").hide();
		}
	}
	;
	function createFileboxObj(target, definations) {
		$(target).addClass("filebox-f").hide();
		var fileboxObj = null;
		if (definations.cusCls) {
			fileboxObj = $("<span class=\"filebox\"></span>").addClass(definationsTemp.cusCls).insertAfter(target);
		} else {
			fileboxObj = $("<span class=\"filebox\"></span>").insertAfter(target);
		}
		var fileboxTextObj = $(
		        "<span><input type=\"text\" class=\"filebox-text\" readonly=\"readonly\"><input type=\"file\" class=\"filebox-file\"></span>")
		        .appendTo(fileboxObj);
		if (definations.iconCls) {
			$("<span class=\"filebox-icon\"></span>").addClass(definations.iconCls).appendTo(fileboxObj);
		} else {
			$("<span><span class=\"filebox-icon\"></span></span>").appendTo(fileboxObj);
		}
		var fileboxPropertyName = $(target).attr("name");
		if (fileboxPropertyName) {
			fileboxObj.find("input.filebox-file").attr("name", fileboxPropertyName);
			fileboxObj.find("input.filebox-text").attr("name", fileboxPropertyName+"_fileName");
			$(target).removeAttr("name").attr("name_ref",fileboxPropertyName).attr("name_ref_file",fileboxPropertyName+"_fileName");
		}
		fileboxTextObj.attr("autocomplete", "off");
		return {
			filebox : fileboxObj
		};
	}
	;
	function destroy(target) {
		var fileboxTextObj = $.data(target, "filebox").filebox.find("input.filebox-file");
		fileboxTextObj.inputbox("destroy");
		$.data(target, "filebox").filebox.remove();
		$(target).remove();
	}
	;
	function bindEvents(target) {
		var fileboxObj = $.data(target, "filebox");
		var fileboxDefinations = fileboxObj.definations;
		var fileboxObjInner = $.data(target, "filebox").filebox;
		var fileboxText = fileboxObjInner.find(".filebox-text");
		var fileboxFile = fileboxObjInner.find(".filebox-file");
		fileboxText.unbind(".filebox");
		fileboxFile.unbind(".filebox");
		if (!fileboxDefinations.disabled) {
			fileboxFile.bind("click.filebox", function(e) {
			}).bind("change.filebox-file", function(e) {
				fileboxDefinations.onChange.call(target, target, e, this.value);
			});
		}
	}
	;
	function validate(target, validateFlag) {
		var fileboxDefinations = $.data(target, "filebox").definations;
		var fileboxObj = $.data(target, "filebox").filebox.find("input.filebox-text");
		fileboxObj.inputbox(fileboxDefinations);
		if (validateFlag) {
			fileboxObj.inputbox("validate");
		}
	}
	;
	function setDisabled(target, flag) {
		var fileboxDefinations = $.data(target, "filebox").definations;
		var fileboxObj = $.data(target, "filebox").filebox;
		if (flag) {
			fileboxDefinations.disabled = true;
			$(target).attr("disabled", true);
			fileboxObj.find(".filebox-text").attr("disabled", true);
			fileboxObj.find(".filebox-file").attr("disabled", true);
		} else {
			fileboxDefinations.disabled = false;
			$(target).removeAttr("disabled");
			fileboxObj.find(".filebox-text").removeAttr("disabled");
			fileboxObj.find(".filebox-file").removeAttr("disabled");
		}
	}
	;
	function clear(target) {
		var fileboxObj = $.data(target, "filebox").filebox;
		fileboxObj.find("input.filebox-text").val("");
		fileboxObj.find("input.filebox-file").val("");
	}
	;
	function getFileName(target) {
		var fileboxObj = $.data(target, "filebox").filebox;
		return fileboxObj.find("input.filebox-text").val();
	}
	;
	$.fn.filebox = function(definations, param) {
		if (typeof definations == "string") {
			return $.fn.filebox.methods[definations](this, param);
		}
		definations = definations || {};
		return this.each(function() {
			var fileboxObj = $.data(this, "filebox");
			if (fileboxObj) {
				$.extend(fileboxObj.definations, definations);
			} else {
				var newDefinations = $.extend({}, $.fn.filebox.defaults, $.fn.filebox.parseDefinations(this),
				        definations);
				var r = createFileboxObj(this, newDefinations);
				fileboxObj = $.data(this, "filebox", {
				    definations : newDefinations,
				    filebox : r.filebox,
				    previousValue : null
				});
				$(this).removeAttr("disabled");
			}
			$("input.filebox-file", fileboxObj.filebox).attr("readonly", !fileboxObj.definations.editable);
			setIconShowOrHide(this);
			setDisabled(this, fileboxObj.definations.disabled);
			setSize(this);
			bindEvents(this);
			validate(this);
		});
	};
	$.fn.filebox.methods = {
	    definations : function(jq) {
		    return $.data(jq[0], "filebox").definations;
	    },
	    textbox : function(jq) {
		    return $.data(jq[0], "filebox").filebox.find("input.filebox-text");
	    },
	    destroy : function(jq) {
		    return jq.each(function() {
			    destroy(this);
		    });
	    },
	    resize : function(jq, width) {
		    return jq.each(function() {
			    setSize(this, width);
		    });
	    },
	    disable : function(jq) {
		    return jq.each(function() {
			    setDisabled(this, true);
			    bindEvents(this);
		    });
	    },
	    enable : function(jq) {
		    return jq.each(function() {
			    setDisabled(this, false);
			    bindEvents(this);
		    });
	    },
	    validate : function(jq) {
		    return jq.each(function() {
			    validate(this, true);
		    });
	    },
	    isValid : function(jq) {
		    var fileboxTextObj = $.data(jq[0], "filebox").filebox.find("input.filebox-text");
		    return fileboxTextObj.inputbox("isValid");
	    },
	    clear : function(jq) {
		    return jq.each(function() {
			    clear(this);
		    });
	    },
	    getValue : function(jq) {
		    return getFileName(jq[0]);
	    }
	};
	$.fn.filebox.parseDefinations = function(target) {
		var t = $(target);
		return $.extend({}, $.fn.inputbox.parseDefinations(target), $.parser.parseDefinations(target, [ "width",
		        "height", "separator", {
		            editable : "boolean",
		            hasIcon : "boolean",
		            delay : "number"
		        } ]), {
		    disabled : (t.attr("disabled") ? true : undefined),
		    value : (t.val() || undefined),
		    searcher : (t.attr("searcher") ? $.parser.localEval(t.attr("searcher")) : undefined)
		});
	};
	$.fn.filebox.defaults = $.extend({}, $.fn.inputbox.defaults, {
	    cusCls : null,
	    iconCls : null,
	    width : "auto",
	    height : 22,
	    editable : true,
	    disabled : false,
	    hasIcon : true,
	    value : "",
	    delay : 200,
	    keyHandler : {
	        up : function() {
	        },
	        down : function() {
	        },
	        enter : function() {
	        },
	        query : function(q) {
	        }
	    },
	    onChange : function(target, e, v) {
	    	$(target).parent().find(".filebox-text").val(v);
	    }
	});
})(jQuery);
