﻿/**
 * dialog - jQuery jwwUI Copyright (c) 2013-2015 www.jeeww.com. All rights reserved. 
 * Licensed under the GPL or commercial licenses 
 */
(function($) {
	function createContentPanel(target) {
		var cp = document.createElement("div");
		while (target.firstChild) {
			cp.appendChild(target.firstChild);
		}
		target.appendChild(cp);
		var contentPanel = $(cp);
		contentPanel.attr("style", $(target).attr("style"));
		$(target).removeAttr("style").css("overflow", "hidden");
		contentPanel.panel({ border : false, doSize : false, bodyCls : "dialog-content" });
		return contentPanel;
	}
	;
	function create(target) {
		var definations = $.data(target, "dialog").definations;
		var contentPanel = $.data(target, "dialog").contentPanel;
		if (definations.toolbar) {
			if (typeof definations.toolbar == "string") {
				$(definations.toolbar).addClass("dialog-toolbar").prependTo(target);
				$(definations.toolbar).show();
			} else {
				$(target).find("div.dialog-toolbar").remove();
				var newDialogHtmlObj = $(
				        "<div class=\"dialog-toolbar\"><table cellspacing=\"0\" cellpadding=\"0\"><tr></tr></table></div>")
				        .prependTo(target);
				var tr = newDialogHtmlObj.find("tr");
				for ( var i = 0; i < definations.toolbar.length; i++) {
					var toolbar = definations.toolbar[i];
					if (toolbar == "-") {
						$("<td><div class=\"dialog-tool-separator\"></div></td>").appendTo(tr);
					} else {
						var td = $("<td></td>").appendTo(tr);
						var toolbarTd = $("<a href=\"javascript:void(0)\"></a>").appendTo(td);
						toolbarTd[0].onclick = $.parser.localEval(toolbar.handler || function() {
						});
						toolbarTd.linkbutton($.extend({}, toolbar, { plain : true }));
					}
				}
			}
		} else {
			$(target).find("div.dialog-toolbar").remove();
		}
		if (definations.buttons) {
			if (typeof definations.buttons == "string") {
				$(definations.buttons).addClass("dialog-button").appendTo(target);
				$(definations.buttons).show();
			} else {
				$(target).find("div.dialog-button").remove();
				var newDialogAddedButton = $("<div class=\"dialog-button\"></div>").appendTo(target);
				for ( var i = 0; i < definations.buttons.length; i++) {
					var p = definations.buttons[i];
					var newDialogAddedButtonEvent = $("<a href=\"javascript:void(0)\"></a>").appendTo(
					        newDialogAddedButton);
					if (p.handler) {
						newDialogAddedButtonEvent[0].onclick = p.handler;
					}
					newDialogAddedButtonEvent.linkbutton(p);
				}
			}
		} else {
			$(target).find("div.dialog-button").remove();
		}
		var href = definations.href;
		var content = definations.content;
		definations.href = null;
		definations.content = null;
		contentPanel.panel({ closed : definations.closed, cache : definations.cache, href : href, content : content,
		    onLoad : function() {
			    if (definations.height == "auto") {
				    $(target).window("resize");
			    }
			    definations.onLoad.apply(target, arguments);
		    } });
		$(target).window(
		        $.extend({}, definations, {
		            onOpen : function() {
			            if (contentPanel.panel("definations").closed) {
				            contentPanel.panel("open");
			            }
			            if (definations.onOpen) {
				            definations.onOpen.call(target);
			            }
		            },
		            onResize : function(position, height) {
			            var targetObj = $(target);
			            contentPanel.panel("panel").show();
			            contentPanel.panel("resize", {
			                width : targetObj.width(),
			                height : (height == "auto") ? "auto" : targetObj.height()
			                        - targetObj.children("div.dialog-toolbar")._outerHeight()
			                        - targetObj.children("div.dialog-button")._outerHeight() });
			            if (definations.onResize) {
				            definations.onResize.call(target, position, height);
			            }
		            } }));
		definations.href = href;
		definations.content = content;
	}
	;
	function refresh(target, url) {
		var contentPanel = $.data(target, "dialog").contentPanel;
		contentPanel.panel("refresh", url);
	}
	;
	$.fn.dialog = function(definations, param) {
		if (typeof definations == "string") {
			var methodFun = $.fn.dialog.methods[definations];
			if (methodFun) {
				return methodFun(this, param);
			} else {
				return this.window(definations, param);
			}
		}
		definations = definations || {};
		return this.each(function() {
			var dialog = $.data(this, "dialog");
			if (dialog) {
				$.extend(dialog.definations, definations);
			} else {
				$.data(this, "dialog", {
				    definations : $.extend({}, $.fn.dialog.defaults, $.fn.dialog.parseDefinations(this), definations),
				    contentPanel : createContentPanel(this) });
			}
			create(this);
		});
	};
	$.fn.dialog.methods = {
	    definations : function(jq) {
		    var definations = $.data(jq[0], "dialog").definations;
		    var panelDefinations = jq.panel("definations");
		    $.extend(definations, { closed : panelDefinations.closed, collapsed : panelDefinations.collapsed,
		        minimized : panelDefinations.minimized, maximized : panelDefinations.maximized });
		    return definations;
	    }, dialog : function(jq) {
		    return jq.window("window");
	    }, refresh : function(jq, url) {
		    return jq.each(function() {
			    refresh(this, url);
		    });
	    } };
	$.fn.dialog.parseDefinations = function(target) {
		return $.extend({}, $.fn.window.parseDefinations(target), $.parser.parseDefinations(target, [ "toolbar", "buttons" ]));
	};
	$.fn.dialog.defaults = $.extend({}, $.fn.window.defaults, { title : "New Dialog", collapsible : false,
	    minimizable : false, maximizable : false, resizable : false, toolbar : null, buttons : null });
})(jQuery);
