package com.jeeww.web.admin.service.resourcemanage.impl;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.jeeww.core.service.impl.BaseServiceImpl;
import com.jeeww.core.syspojo.AgtbResourceInfo;
import com.jeeww.core.syspojo.AgtbResourceInfoDAO;
import com.jeeww.core.utils.BeanUtilsEx;
import com.jeeww.core.utils.AgileUtils;
import com.jeeww.core.vo.TreeConfig;
import com.jeeww.web.admin.dto.resourcemanage.ResourceManageDTO;
import com.jeeww.web.admin.searchmodel.resourcemanage.ResourceManageSearchModel;
import com.jeeww.web.admin.service.resourcemanage.ResourceManagerService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
@Service("ResourceManagerServiceImpl")
public class ResourceManagerServiceImpl extends BaseServiceImpl implements ResourceManagerService {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(ResourceManagerServiceImpl.class);

    /**
     * 对agtbResourceInfo对象进行增删改操作的DAO.
     */
    @Autowired
    private AgtbResourceInfoDAO agtbResourceInfoDAO;

    @Override
    public String getResource(final ResourceManageSearchModel searchModel) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("service-----获取资源信息树");
        }
        TreeConfig tree = new TreeConfig();
        tree.setTreeNamedQueryIdForTree("resourceManageQueryAllResource");
        tree.setTreeNamedQueryIdForCheck("resourceManageCheckIsHaveChildren");
        tree.setTreeIdProperty("resourceId");
        tree.setTreeNameProperty("resourceName");
        return JSON.toJSONString(getTreeBySQLNamedQuery(searchModel, tree));
    }

    @Override
    public String getResourceDetail(final ResourceManageSearchModel searchModel) throws Exception {
        return getFormBySQLNamedQuery("getResourceDetail", searchModel);
    }

    @Override
    public JSONObject saveResource(final ResourceManageDTO resourceManageDTO) throws Exception {
        String key = resourceManageDTO.getResourceId();
        String msgKey = null;
        if (StringUtils.isEmpty(key)) {
            AgtbResourceInfo agtbResourceInfo = new AgtbResourceInfo();
            BeanUtilsEx.copyProperties(agtbResourceInfo, resourceManageDTO);
            agtbResourceInfo.setResourceId(AgileUtils.getKey());
            agtbResourceInfoDAO.save(agtbResourceInfo);
            msgKey = "saveSuccess";
        } else {
            AgtbResourceInfo agtbResourceInfo = agtbResourceInfoDAO.get(key);
            BeanUtilsEx.copyProperties(agtbResourceInfo, resourceManageDTO, true);
            agtbResourceInfoDAO.update(agtbResourceInfo);
            msgKey = "updateSuccess";
        }
        JSONObject returnObj = successMsg(msgKey);
        returnObj.put("data", key);
        return returnObj;
    }

    @Override
    public JSONObject saveResourceParentNull(final ResourceManageDTO resourceManageDTO) throws Exception {
        String key = resourceManageDTO.getResourceId();
        String msgKey = null;
        AgtbResourceInfo agtbResourceInfo = agtbResourceInfoDAO.get(key);
        BeanUtilsEx.copyProperties(agtbResourceInfo, resourceManageDTO, true);
        agtbResourceInfo.setParentResourceId(null);
        agtbResourceInfoDAO.update(agtbResourceInfo);
        msgKey = "updateSuccess";
        JSONObject returnObj = successMsg(msgKey);
        returnObj.put("data", key);
        return returnObj;
    }

    @Override
    public JSONObject deleteResource(final ResourceManageDTO resourceManageDTO) throws Exception {
        String key = resourceManageDTO.getResourceId();
        String msgKey = null;
        // 校验资源信息是否跟角色关联
        boolean haveRoleRel = getBaseDAO().checkIsHave("checkResourceIsUsingByRole", resourceManageDTO);
        if (haveRoleRel) {
            msgKey = "resourceInUsingByRoleMsg";
            return errorMsg(msgKey);
        } else {
            // 校验资源信息是否跟菜单关联
            boolean haveMenuRel = getBaseDAO().checkIsHave("checkResourceIsUsingByMenu", resourceManageDTO);
            if (haveMenuRel) {
                msgKey = "resourceInUsingByMenuMsg";
                return errorMsg(msgKey);
            }
            // 可以删除，则执行删除操作
            agtbResourceInfoDAO.deleteByKey(key);
            msgKey = "deleteSuccess";
            return successMsg(msgKey);
        }
    }
}
