package com.jeeww.web.admin.service.resourcemanage;

import com.jeeww.web.admin.dto.resourcemanage.ResourceManageDTO;
import com.jeeww.web.admin.searchmodel.resourcemanage.ResourceManageSearchModel;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
public interface ResourceManagerService {
    /**
     * 功能描述：获得资源信息树.
     * @param searchModel 查询条件.
     * @return String.
     * @throws Exception e.
     */
    String getResource(ResourceManageSearchModel searchModel) throws Exception;

    /**
     * 功能描述 :获得资源详细信息.
     * @param searchModel 查询条件.
     * @return String 返回资源详细信息json字符串.
     * @throws Exception e.
     */
    String getResourceDetail(ResourceManageSearchModel searchModel) throws Exception;

    /**
     * 功能描述 :保存资源信息.
     * @param resourceManageDTO 资源DTO.
     * @return JSONObject 返回操作信息.
     * @throws Exception e.
     */
    JSONObject saveResource(ResourceManageDTO resourceManageDTO) throws Exception;

    /**
     * 功能描述 :保存资源的父节点为空.
     * @param resourceManageDTO 资源DTO.
     * @return JSONObject 返回操作信息.
     * @throws Exception e.
     */
    JSONObject saveResourceParentNull(ResourceManageDTO resourceManageDTO) throws Exception;

    /**
     * 功能描述 :删除选择的资源信息.
     * @param resourceManageDTO 资源DTO.
     * @return JSONObject 返回操作信息.
     * @throws Exception e.
     */
    JSONObject deleteResource(ResourceManageDTO resourceManageDTO) throws Exception;
}
