package com.jeeww.web.admin.service.orgmanage;

import com.jeeww.web.admin.dto.orgmanage.OrgManageDTO;
import com.jeeww.web.admin.searchmodel.orgmanage.OrgManageSearchModel;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
public interface OrgManagerService {
    /**
     * @param orgManageSearchModel orgManageSearchModel.
     * @return String.
     * @throws Exception e.
     */
    String queryOrgForTreeGrid(OrgManageSearchModel orgManageSearchModel) throws Exception;

    /**
     * 功能描述 :获得机构树.
     * @param searchModel 查询条件.
     * @return String 返回树形结构json字符串.
     * @throws Exception e.
     */
    String getOrgTree(OrgManageSearchModel searchModel) throws Exception;

    /**
     * 功能描述 :获得机构详细信息.
     * @param searchModel 查询条件.
     * @return String 返回机构详细信息json.
     * @throws Exception e.
     */
    String getOrgDetail(OrgManageSearchModel searchModel) throws Exception;

    /**
     * 功能描述 :删除机构信息.
     * @param orgId 要删除的机构信息.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    JSONObject deleteOrg(String orgId) throws Exception;

    /**
     * 功能描述 :保存机构信息.
     * @param orgManageDTO 机构DTO.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    JSONObject saveOrg(OrgManageDTO orgManageDTO) throws Exception;
}
