package com.jeeww.web.admin.service.authoritymanage.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.jeeww.core.service.impl.BaseServiceImpl;
import com.jeeww.core.syspojo.AgtbResourceInfo;
import com.jeeww.core.syspojo.AgtbResourceInfoDAO;
import com.jeeww.core.syspojo.AgtbRoleInfo;
import com.jeeww.core.syspojo.AgtbRoleInfoDAO;
import com.jeeww.core.syspojo.AgtbRoleResourceRel;
import com.jeeww.core.syspojo.AgtbRoleResourceRelDAO;
import com.jeeww.core.syspojo.AgtbRoleResourceRelId;
import com.jeeww.core.utils.BeanUtilsEx;
import com.jeeww.core.vo.Pager;
import com.jeeww.web.admin.searchmodel.authoritymanage.AuthorityManageSearchModel;
import com.jeeww.web.admin.service.authoritymanage.AuthorityManagerService;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口.
 * @author 蒋文武
 */
@Service("AuthorityManagerServiceImpl")
public class AuthorityManagerServiceImpl extends BaseServiceImpl implements AuthorityManagerService {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(AuthorityManagerServiceImpl.class);
    /**
     * 角色DAO.
     */
    @Autowired
    private AgtbRoleInfoDAO agtbRoleInfoDAO;

    /**
     * 资源DAO.
     */
    @Autowired
    private AgtbResourceInfoDAO agtbResourceInfoDAO;
    /**
     * 角色资源关系表DAO.
     */
    @Autowired
    private AgtbRoleResourceRelDAO agtbRoleResourceRelDAO;

    @Override
    public String queryRoleForAuthorityGrid(final Pager<?> pager) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("service---获得用户dataGrid数据");
        }
        return getGridByHQLNamedQuery("queryRoleForGrid", pager);
    }

    @Override
    public String getRoleResources(final String roleId) throws Exception {
        AuthorityManageSearchModel searchModel = new AuthorityManageSearchModel();
        searchModel.setRoleId(roleId);
        return getNormalDataBySQLNamedQuery("getRoleResources", searchModel);
    }

    @Override
    public JSONObject saveRoleResource(final String roleId, final String resourceTreeNodes) throws Exception {
        AuthorityManageSearchModel parametersModel = new AuthorityManageSearchModel();
        parametersModel.setRoleId(roleId);
        // 删除本菜单原有的关联关系值
        executeDynamicSql("deleteRoleResourceRel", parametersModel);
        String msgKey = null;
        if (!StringUtils.isEmpty(resourceTreeNodes)) {
            AgtbRoleInfo agtbRoleInfo = agtbRoleInfoDAO.get(roleId);
            JSONArray resourceTreeArr = JSONArray.parseArray(resourceTreeNodes);
            List<AgtbRoleResourceRel> entityList = new ArrayList<AgtbRoleResourceRel>();
            for (Object obj : resourceTreeArr) {
                AgtbRoleResourceRel agtbRoleResourceRel = new AgtbRoleResourceRel(); // 创建角色资源关系对象
                agtbRoleResourceRel.setAgtbRoleInfo(agtbRoleInfo); // 设置角色对象
                AgtbResourceInfo agtbResourceInfo = agtbResourceInfoDAO.get(BeanUtilsEx.getProperty(obj, "id"));
                agtbRoleResourceRel.setAgtbResourceInfo(agtbResourceInfo); // 设置资源对象
                AgtbRoleResourceRelId agtbRoleResourceRelId = new AgtbRoleResourceRelId();
                agtbRoleResourceRelId.setRoleId(agtbRoleInfo.getRoleId());
                agtbRoleResourceRelId.setResourceId(agtbResourceInfo.getResourceId());
                agtbRoleResourceRel.setId(agtbRoleResourceRelId); // 设置主键
                entityList.add(agtbRoleResourceRel);
            }
            agtbRoleResourceRelDAO.saveList(entityList); // 保存角色资源关系对象
            msgKey = "saveSuccess";
        } else {
            msgKey = "deleteRoleAuthoritySuccess";
        }
        return successMsg(msgKey);
    }
}
