package com.jeeww.web.admin.controller.rolemanage;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.jeeww.constant.WebConstants;
import com.jeeww.core.utils.AgileUiDataUtils;
import com.jeeww.core.vo.Pager;
import com.jeeww.web.BaseController;
import com.jeeww.web.admin.searchmodel.rolemanage.RoleManageSearchModel;
import com.jeeww.web.admin.service.rolemanage.RoleManagerService;
import com.alibaba.fastjson.JSONObject;

/**
 * 功能描述：测试类.
 */
@Controller
@RequestMapping("/admin")
public class RoleManagerController extends BaseController {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(RoleManagerController.class);
    /**
     * roleManagerService.
     */
    @Autowired
    private RoleManagerService roleManagerService;

    /**
     * 功能描述 :跳转至角色管理首页.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @return ModelAndView index.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/toRoleManagePage.do", method = RequestMethod.GET)
    public ModelAndView toRoleManagePage(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.debug("跳转至角色管理首页.");
        return new ModelAndView(WebConstants.WEBAPP_ADMIN + "rolemanage/rolemanage_main", model);
    }

    /**
     * 功能描述 :获得角色信息列表.
     * @param req req.
     * @return String 返回树形结构json字符串.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/queryRoleForGrid.do", method = RequestMethod.POST)
    @ResponseBody
    public String queryRoleForGrid(final HttpServletRequest req) throws Exception {
        logger.debug("获得角色信息列表.");
        RoleManageSearchModel roleManageSearchModel = new RoleManageSearchModel();
        Pager<?> pager = new Pager<Object>();
        AgileUiDataUtils.initPager(pager, roleManageSearchModel, req);
        return roleManagerService.queryRoleForGrid(pager);
    }

    /**
     * 功能描述 :保存角色信息.
     * @param req req.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/saveRole.do", method = RequestMethod.POST)
    @ResponseBody
    public String saveRole(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("保存角色信息.");
        }
        String roleRows = req.getParameter("roleRows");
        JSONObject returnObj = roleManagerService.saveRole(roleRows);
        return getLocalMsg(req, returnObj);
    }

    /**
     * 功能描述 :删除角色信息.
     * @param req req.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/deleteRoles.do", method = RequestMethod.POST)
    @ResponseBody
    public String deleteRoles(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("删除角色信息.");
        }
        String roleRows = req.getParameter("roleRows");
        JSONObject returnObj = roleManagerService.deleteRoles(roleRows);
        return getLocalMsg(req, returnObj);
    }
}
