package com.jeeww.web.admin.controller.resourcemanage;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.jeeww.constant.WebConstants;
import com.jeeww.core.utils.BeanUtilsEx;
import com.jeeww.web.BaseController;
import com.jeeww.web.admin.dto.resourcemanage.ResourceManageDTO;
import com.jeeww.web.admin.searchmodel.resourcemanage.ResourceManageSearchModel;
import com.jeeww.web.admin.service.resourcemanage.ResourceManagerService;
import com.alibaba.fastjson.JSONObject;

/**
 * 功能描述：测试类.
 */
@Controller
@RequestMapping("/admin")
public class ResourceManagerController extends BaseController {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(ResourceManagerController.class);
    /**
     * resourceManagerService.
     */
    @Autowired
    private ResourceManagerService resourceManagerService;

    /**
     * 功能描述 :页面跳转至用户管理首页.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @return ModelAndView index.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/toResourceManagePage.do", method = RequestMethod.GET)
    public ModelAndView toResourceManagePage(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("跳转至资源管理首页.");
        }
        return new ModelAndView(WebConstants.WEBAPP_ADMIN + "resourcemanage/resourcemanage_main", model);
    }

    /**
     * 功能描述 :获得菜单信息.
     * @param req req.
     * @return String 返回树形结构json字符串.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getResource.do", method = RequestMethod.POST)
    @ResponseBody
    public String getResource(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得资源信息.");
        }
        String onlyPageResource = req.getParameter("onlyPageResource");
        ResourceManageSearchModel searchModel = new ResourceManageSearchModel();
        if (!StringUtils.isEmpty(onlyPageResource)) {
            searchModel.setOnlyPageResource(onlyPageResource);
        }
        return resourceManagerService.getResource(searchModel);
    }

    /**
     * 功能描述 :获得资源详细信息.
     * @param req req.
     * @return String 返回资源详细信息json字符串.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getReourceDetail.do", method = RequestMethod.GET)
    @ResponseBody
    public String getReourceDetail(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得资源详细信息.");
        }
        String resourceId = req.getParameter("resourceId");
        ResourceManageSearchModel searchModel = new ResourceManageSearchModel();
        if (!StringUtils.isEmpty(resourceId)) {
            searchModel.setResourceId(resourceId);
        }
        return resourceManagerService.getResourceDetail(searchModel);
    }

    /**
     * 功能描述 :保存资源信息.
     * @param req req.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/saveReource.do", method = RequestMethod.POST)
    @ResponseBody
    public String saveReource(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("保存资源信息.");
        }
        ResourceManageDTO resourceManageDTO = new ResourceManageDTO();
        BeanUtilsEx.copyProperties(resourceManageDTO, req.getParameterMap());
        JSONObject returnObj = resourceManagerService.saveResource(resourceManageDTO);
        return getLocalMsg(req, returnObj);
    }

    /**
     * 功能描述 :保存资源的父节点为空.
     * @param req req.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/saveReourceParentNull.do", method = RequestMethod.POST)
    @ResponseBody
    public String saveReourceParentNull(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("保存资源的父节点为空.");
        }
        ResourceManageDTO resourceManageDTO = new ResourceManageDTO();
        BeanUtilsEx.copyProperties(resourceManageDTO, req.getParameterMap());
        JSONObject returnObj = resourceManagerService.saveResourceParentNull(resourceManageDTO);
        return getLocalMsg(req, returnObj);
    }
    /**
     * 功能描述 :删除选择的资源信息.
     * @param req req.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/deleteReource.do", method = RequestMethod.POST)
    @ResponseBody
    public String deleteReource(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("删除选择的资源信息.");
        }
        ResourceManageDTO resourceManageDTO = new ResourceManageDTO();
        BeanUtilsEx.copyProperties(resourceManageDTO, req.getParameterMap());
        JSONObject returnObj = resourceManagerService.deleteResource(resourceManageDTO);
        return getLocalMsg(req, returnObj);
    }
}
