package com.jeeww.web.admin.controller.orgmanage;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.jeeww.constant.WebConstants;
import com.jeeww.core.utils.AgileUiDataUtils;
import com.jeeww.core.utils.BeanUtilsEx;
import com.jeeww.web.BaseController;
import com.jeeww.web.admin.dto.orgmanage.OrgManageDTO;
import com.jeeww.web.admin.searchmodel.orgmanage.OrgManageSearchModel;
import com.jeeww.web.admin.service.orgmanage.OrgManagerService;
import com.alibaba.fastjson.JSONObject;

/**
 * 功能描述：测试类.
 */
@Controller
@RequestMapping("/admin")
public class OrgManagerController extends BaseController {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(OrgManagerController.class);
    /**
     * orgManagerService.
     */
    @Autowired
    private OrgManagerService orgManagerService;

    /**
     * 功能描述 :页面跳转至用户管理首页.
     * @param locale locale.
     * @param model model.
     * @param req req.
     * @return ModelAndView index.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/toOrgManagePage.do", method = RequestMethod.GET)
    public ModelAndView toOrgManagePage(final Locale locale, final ModelMap model, final HttpServletRequest req)
            throws Exception {
        logger.debug("跳转至机构管理首页.");
        return new ModelAndView(WebConstants.WEBAPP_ADMIN + "orgmanage/orgmanage_main", model);
    }

    /**
     * 功能描述 :查询机构信息.
     * @param req req.
     * @return ModelAndView 返回页面index.html.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/queryOrgForTreeGrid.do", method = RequestMethod.POST)
    @ResponseBody
    public String queryOrgForTreeGrid(final HttpServletRequest req) throws Exception {
        logger.debug("查询机构信息.");
        OrgManageSearchModel orgManageSearchModel = new OrgManageSearchModel();
        AgileUiDataUtils.initSearchModel(orgManageSearchModel, req);
        String treeGridData = orgManagerService.queryOrgForTreeGrid(orgManageSearchModel);
        return treeGridData;
    }

    /**
     * 功能描述 :获得机构树.
     * @param req req.
     * @return String 返回树形结构json字符串.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getOrgTree.do", method = RequestMethod.POST)
    @ResponseBody
    public String getOrgTree(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得机构树.");
        }
        OrgManageSearchModel searchModel = new OrgManageSearchModel();
        return orgManagerService.getOrgTree(searchModel);
    }

    /**
     * 功能描述 :获得资源详细信息.
     * @param req req.
     * @return String 返回资源详细信息json字符串.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/getOrgDetail.do", method = RequestMethod.GET)
    @ResponseBody
    public String getOrgDetail(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("获得机构详细信息.");
        }
        String orgId = req.getParameter("orgId");
        OrgManageSearchModel searchModel = new OrgManageSearchModel();
        if (!StringUtils.isEmpty(orgId)) {
            searchModel.setOrgId(orgId);
        }
        return orgManagerService.getOrgDetail(searchModel);
    }

    /**
     * 功能描述 :删除机构信息.
     * @param req req.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/deleteOrg.do", method = RequestMethod.POST)
    @ResponseBody
    public String deleteOrg(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("删除机构信息.");
        }
        String orgId = req.getParameter("orgId");
        JSONObject returnObj = orgManagerService.deleteOrg(orgId);
        return getLocalMsg(req, returnObj);
    }
    /**
     * 功能描述 :保存机构信息.
     * @param req req.
     * @return String 返回操作信息.
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/saveOrg.do", method = RequestMethod.POST)
    @ResponseBody
    public String saveOrg(final HttpServletRequest req) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("保存机构信息.");
        }
        OrgManageDTO orgManageDTO = new OrgManageDTO();
        BeanUtilsEx.copyProperties(orgManageDTO, req.getParameterMap());
        JSONObject returnObj = orgManagerService.saveOrg(orgManageDTO);
        return getLocalMsg(req, returnObj);
    }
}
