package com.jeeww.web.admin.controller.initsys;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.jeeww.web.BaseController;
import com.jeeww.web.admin.service.init.impl.InitSysServiceImpl;

/**
 * 功能描述：初始化系统数据库相关信息，包括初始系统管理菜单角色等.
 */
@Controller
@RequestMapping("/admin")
public class InitSysController extends BaseController {
    /**
     * logger.
     */
    private Logger logger = Logger.getLogger(InitSysController.class);
    /**
     * InitSysService.
     */
    @Autowired
    private InitSysServiceImpl initSysService;

    /**
     * 功能描述 :初始化系统数据库相关信息，包括初始系统管理菜单角色等..
     * @param req req.
     * @return String "".
     * @throws Exception e.
     */
    @RequestMapping(
            value = "/insertInitSysData.do", method = RequestMethod.GET)
    @ResponseBody
    public String initSysData(final HttpServletRequest req) throws Exception {
        logger.debug("初始化系统信息......");
        initSysService.insertInitSysData();
        return "系统初始化成功！";
    }
}
