//package com.jeeww.web.activiti.controller.processdefinationmanage;
//
//import java.awt.image.BufferedImage;
//import java.io.InputStream;
//import java.util.Locale;
//
//import javax.imageio.ImageIO;
//import javax.servlet.http.HttpServletRequest;
//import javax.servlet.http.HttpServletResponse;
//
//import org.activiti.engine.repository.ProcessDefinition;
//import org.apache.commons.lang.StringUtils;
//import org.apache.log4j.Logger;
//import org.springframework.beans.factory.annotation.Autowired;
//import org.springframework.stereotype.Controller;
//import org.springframework.ui.ModelMap;
//import org.springframework.web.bind.annotation.RequestMapping;
//import org.springframework.web.bind.annotation.RequestMethod;
//import org.springframework.web.bind.annotation.ResponseBody;
//import org.springframework.web.servlet.ModelAndView;
//
//import com.jeeww.activiti.ActivitiConstants;
//import com.jeeww.activiti.ActivitiUtils;
//import com.jeeww.activiti.service.ActivitiCoreService;
//import com.jeeww.core.utils.AgileUiDataUtils;
//import com.jeeww.core.vo.Pager;
//import com.jeeww.web.BaseController;
//import com.jeeww.web.activiti.dto.ActivitiSearchModel;
//
///**
// * 功能描述：流程定义相关操作.
// */
//@Controller
//@RequestMapping("/activiti")
//public class ProcessDefinationManageController extends BaseController {
//    /**
//     * logger.
//     */
//    private Logger logger = Logger.getLogger(ProcessDefinationManageController.class);
//    /**
//     * 图片大小.
//     */
//    public static final int C_M_SIZE = 1024;
//    /**
//     * activitiCoreService.
//     */
//    @Autowired
//    private ActivitiCoreService activitiCoreService;
//
//    /**
//     * 功能描述 :跳转到流程定义管理页面.
//     * @param locale locale
//     * @param model model
//     * @param req req
//     * @return ModelAndView
//     * @throws Exception e
//     */
//    @RequestMapping(
//            value = "/toProcessDefinationPage.do", method = RequestMethod.GET)
//    public ModelAndView toActivieDiagramPage(final Locale locale, final ModelMap model, final HttpServletRequest req)
//            throws Exception {
//        if (logger.isDebugEnabled()) {
//            logger.info("跳转到流程定义管理页面.");
//        }
//        return new ModelAndView(ActivitiConstants.WEBAPP_ACTIVITI + "processdefinitionmanage/processDefinition_main",
//                model);
//    }
//
//    /**
//     * 功能描述 :获取流程信息.
//     * @param req req.
//     * @return String 返回节点坐标信息.
//     * @throws Exception e.
//     */
//    @RequestMapping(
//            value = "/getProcessDefinations.do", method = RequestMethod.POST)
//    @ResponseBody
//    public String getProcessDefinations(final HttpServletRequest req) throws Exception {
//        if (logger.isDebugEnabled()) {
//            logger.debug("获取流程信息.");
//        }
//        ActivitiSearchModel activitiSearchModel = new ActivitiSearchModel();
//        Pager<ProcessDefinition> pager = new Pager<ProcessDefinition>();
//        AgileUiDataUtils.initPager(pager, activitiSearchModel, req);
//        activitiCoreService.getProcessDefinations(pager);
//        return ActivitiUtils.getProcessDefinitionGrid(pager);
//    }
//
//    /**
//     * 功能描述 :跳转到activiti工作流任务流程图查看页面.
//     * @param locale locale.
//     * @param model model.
//     * @param req req.
//     * @param r.
//     * @return ModelAndView index.
//     * @throws Exception e.
//     */
//    @RequestMapping(
//            value = "/toProcessDiagramView.do", method = RequestMethod.GET)
//    public ModelAndView toProcessDiagramView(final Locale locale, final ModelMap model, final HttpServletRequest req)
//            throws Exception {
//        if (logger.isDebugEnabled()) {
//            logger.info("跳转到activiti工作流任务流程图查看页面");
//        }
//        String pdid = req.getParameter("pdid");
//        if (StringUtils.isEmpty(pdid)) {
//            pdid = "NULL";
//        } else {
//            InputStream imageStream = activitiCoreService.getProcessDiagramByPdid(pdid);
//            BufferedImage bufferedImage = ImageIO.read(imageStream);
//            int width = bufferedImage.getWidth();
//            int height = bufferedImage.getHeight();
//            model.addAttribute("width", width);
//            model.addAttribute("height", height);
//        }
//        model.addAttribute("pdid", pdid);
//        String piid = req.getParameter("piid");
//        if (StringUtils.isEmpty(piid)) {
//            piid = "NULL";
//        } else {
//            InputStream imageStream = activitiCoreService.getActivieDiagramByPiid(piid);
//            BufferedImage bufferedImage = ImageIO.read(imageStream);
//            int width = bufferedImage.getWidth();
//            int height = bufferedImage.getHeight();
//            model.addAttribute("width", width);
//            model.addAttribute("height", height);
//        }
//        model.addAttribute("piid", piid);
//        return new ModelAndView(ActivitiConstants.WEBAPP_ACTIVITI
//                + "processdefinitionmanage/processDefinitionDiagramIframe", model);
//    }
//    /**
//     * 功能描述 :跳转到activiti工作流任务流程图查看页面.
//     * @param locale locale.
//     * @param model model.
//     * @param req req.
//     * @param r.
//     * @return ModelAndView index.
//     * @throws Exception e.
//     */
//    @RequestMapping(
//            value = "/toActiveProcessDiagramView.do", method = RequestMethod.GET)
//    public ModelAndView toActiveProcessDiagramView(final Locale locale, final ModelMap model, final HttpServletRequest req)
//            throws Exception {
//        if (logger.isDebugEnabled()) {
//            logger.info("跳转到activiti工作流任务流程图查看页面");
//        }
//        String pdid = req.getParameter("pdid");
//        if (StringUtils.isEmpty(pdid)) {
//            pdid = "NULL";
//        } else {
//            InputStream imageStream = activitiCoreService.getProcessDiagramByPdid(pdid);
//            BufferedImage bufferedImage = ImageIO.read(imageStream);
//            int width = bufferedImage.getWidth();
//            int height = bufferedImage.getHeight();
//            model.addAttribute("width", width);
//            model.addAttribute("height", height);
//        }
//        model.addAttribute("pdid", pdid);
//        String piid = req.getParameter("piid");
//        if (StringUtils.isEmpty(piid)) {
//            piid = "NULL";
//        } else {
//            InputStream imageStream = activitiCoreService.getActivieDiagramByPiid(piid);
//            BufferedImage bufferedImage = ImageIO.read(imageStream);
//            int width = bufferedImage.getWidth();
//            int height = bufferedImage.getHeight();
//            model.addAttribute("width", width);
//            model.addAttribute("height", height);
//        }
//        model.addAttribute("piid", piid);
//        return new ModelAndView(ActivitiConstants.WEBAPP_ACTIVITI
//                + "processinstancemanage/processinstancemanageDiagramIframe", model);
//    }
//    
//    /**
//     * 功能描述：通过流程实例ID获得流程图.
//     * @param locale locale.
//     * @param req req.
//     * @param res res.
//     * @throws Exception e.
//     */
//    @RequestMapping(
//            value = "/getProcessDiagramBypdid.do", method = RequestMethod.GET)
//    public void getDiagramBypdid(final Locale locale, final HttpServletRequest req, final HttpServletResponse res)
//            throws Exception {
//        if (logger.isDebugEnabled()) {
//            logger.info("通过流程实例ID获得流程图.");
//        }
//        String pdid = req.getParameter("pdid");
//        // 输出资源内容到相应对象
//        InputStream imageStream = activitiCoreService.getProcessDiagramByPdid(pdid);
//        if (imageStream != null) {
//            byte[] b = new byte[C_M_SIZE];
//            int len;
//            while ((len = imageStream.read(b, 0, C_M_SIZE)) != -1) {
//                res.getOutputStream().write(b, 0, len);
//            }
//        }
//    }
//    /**
//     * 功能描述：通过流程实例ID获得流程图.
//     * @param locale locale.
//     * @param req req.
//     * @param res res.
//     * @throws Exception e.
//     */
//    @RequestMapping(
//            value = "/getProcessDiagramBypiid.do", method = RequestMethod.GET)
//    public void getDiagramBypiid(final Locale locale, final HttpServletRequest req, final HttpServletResponse res)
//            throws Exception {
//        if (logger.isDebugEnabled()) {
//            logger.info("通过流程实例ID获得流程图.");
//        }
//        String piid = req.getParameter("piid");
//        // 输出资源内容到相应对象
//        InputStream imageStream = activitiCoreService.getActivieDiagramByPiid(piid);
//        if (imageStream != null) {
//            byte[] b = new byte[C_M_SIZE];
//            int len;
//            while ((len = imageStream.read(b, 0, C_M_SIZE)) != -1) {
//                res.getOutputStream().write(b, 0, len);
//            }
//        }
//    }
//    /**
//     * 功能描述 :根据流程实例ID获得正在进行的节点的坐标信息等.
//     * @param req req.
//     * @return String 返回节点坐标信息.
//     * @throws Exception e.
//     */
//    @RequestMapping(
//            value = "/getTaskPointInfoByPiid.do", method = RequestMethod.POST)
//    @ResponseBody
//    public String getTaskPointInfoByPiid(final HttpServletRequest req) throws Exception {
//        if (logger.isDebugEnabled()) {
//            logger.debug("根据流程实例ID获得正在进行的节点的坐标信息等.");
//        }
//        String processInstanceId = req.getParameter("piid");
//        return activitiCoreService.getActiviePoint(processInstanceId);
//    }
//
//    /**
//     * 功能描述 :根据流程定义ID获得节点的坐标信息等.
//     * @param req req.
//     * @return String 返回节点坐标信息.
//     * @throws Exception e.
//     */
//    @RequestMapping(
//            value = "/getTaskPointInfoByPdid.do", method = RequestMethod.POST)
//    @ResponseBody
//    public String getTaskPointInfoByPdid(final HttpServletRequest req) throws Exception {
//        if (logger.isDebugEnabled()) {
//            logger.debug("根据流程定义ID获得节点的坐标信息等.");
//        }
//        String pdid = req.getParameter("pdid");
//        return activitiCoreService.getTaskPointInfoByPdid(pdid);
//    }
//}
