package com.jeeww.utils;

import java.util.HashMap;
import java.util.Map;

/**
 * 存储已查询的基础下拉列表.
 * @author jiangww
 */
public class CommonComboUtils {
    /**
     * 存储下拉列表的map.
     */
    private static Map<String, String> combos = new HashMap<String, String>();

    /**
     * 获取已存在的下拉列表信息.
     * @param codeId 下拉列表编号.
     * @return 返回指定的下拉列表.
     */
    public static final String getCommonCombo(final String codeId) {
        if (combos.containsKey(codeId)) {
            return combos.get(codeId);
        }
        return null;
    }

    /**
     * 设置下拉列表值.
     * @param codeId 下拉列表编号.
     * @param value 下拉列表值.
     */
    public static final void setCommonCombo(final String codeId, final String value) {
        combos.put(codeId, value);
    }
}
