package com.jeeww.security;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

import com.jeeww.core.syspojo.AgtbRoleInfo;
import com.jeeww.core.syspojo.AgtbUserInfo;
import com.jeeww.dto.MenuInfoDTO;
import com.alibaba.fastjson.JSONArray;


public class CustomerUserDetails implements UserDetails {
    private static final long serialVersionUID = 1L;
    private int id;
    private String password;
    private Set<AgtbRoleInfo> roles;
    private AgtbUserInfo userInfo;
    private String userName;
    private boolean isAccountNonExpired;
    private boolean isAccountNonLocked;
    private boolean isCredentialsNonExpired;
    private boolean isEnabled;
    private List<MenuInfoDTO> menuList;
    private Collection<? extends GrantedAuthority> authorities;
    private Map<String, JSONArray> normalRequestUrls;

    /**
     * @return the userInfo
     */
    public final AgtbUserInfo getUserInfo() {
        return userInfo;
    }

    /**
     * @param userInfo the userInfo to set
     */
    public final void setUserInfo(AgtbUserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<AgtbRoleInfo> getRoles() {
        return roles;
    }

    public void setRoles(Set<AgtbRoleInfo> roles) {
        this.roles = roles;
    }

    @Override
    public String getUsername() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isAccountNonExpired() {
        return isAccountNonExpired;
    }

    public void setAccountNonExpired(boolean isAccountNonExpired) {
        this.isAccountNonExpired = isAccountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return isAccountNonLocked;
    }

    public void setAccountNonLocked(boolean isAccountNonLocked) {
        this.isAccountNonLocked = isAccountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return isCredentialsNonExpired;
    }

    public void setCredentialsNonExpired(boolean isCredentialsNonExpired) {
        this.isCredentialsNonExpired = isCredentialsNonExpired;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return authorities;
    }

    public void setAuthorities(Collection<? extends GrantedAuthority> authorities) {
        this.authorities = authorities;
    }

    public boolean isEnabled() {
        return isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    /**
     * @return the normalRequestUrls
     */
    public final Map<String, JSONArray> getNormalRequestUrls() {
        return normalRequestUrls;
    }

    /**
     * @param normalRequestUrls the normalRequestUrls to set
     */
    public final void setNormalRequestUrls(Map<String, JSONArray> normalRequestUrls) {
        this.normalRequestUrls = normalRequestUrls;
    }

    /**
     * @return the menuList
     */
    public List<MenuInfoDTO> getMenuList() {
        return menuList;
    }

    /**
     * @param menuList the menuList to set
     */
    public void setMenuList(List<MenuInfoDTO> menuList) {
        this.menuList = menuList;
    }
}
