package com.jeeww.core.utils;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;

import com.jeeww.core.vo.Pager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jeeww.core.CommonConstants;

/**
 * 类描述：UI结果处理类.
 * @author 蒋文武
 */
public final class AgileUiDataUtils {
    /**
     * 默认构造函数.
     */
    private AgileUiDataUtils() {
    }

    /**
     * 功能说明:初始化查询对象.
     * @param searchModel searchModel.
     * @param req HttpServletRequest.
     * @throws Exception e.
     */
    public static void initSearchModel(final Object searchModel, final HttpServletRequest req) throws Exception {
        String queryCondition = req.getParameter(CommonConstants.WHERE);
        if (!StringUtils.isEmpty(queryCondition)) {
            JSONObject queryObject = JSONObject.parseObject(queryCondition);
            BeanUtilsEx.copyProperties(searchModel, queryObject);
        }
    }

    /**
     * 功能说明:初始化分页查询对象.
     * @param searchModel searchModel.
     * @param <T> <T>.
     * @param pager pager.
     * @param req HttpServletRequest.
     * @return Pager 返回分页对象
     * @throws Exception e.
     */
    public static <T> Pager<T> initPager(final Pager<T> pager, final Object searchModel, final HttpServletRequest req)
            throws Exception {
        String page = req.getParameter(CommonConstants.CURRENT_PAGE);
        String pageSize = req.getParameter(CommonConstants.PAGE_SIZE);
        String queryCondition = req.getParameter(CommonConstants.WHERE);
        if (!StringUtils.isEmpty(page)) {
            pager.setPage(Integer.parseInt(page));
        }
        if (!StringUtils.isEmpty(pageSize)) {
            pager.setPageSize(Integer.parseInt(pageSize));
        }
        if (!StringUtils.isEmpty(queryCondition)) {
            JSONObject queryObject = JSONObject.parseObject(queryCondition);
            BeanUtilsEx.copyProperties(searchModel, queryObject);
        }
        pager.setSearchModel(searchModel);
        return pager;
    }

    /**
     * 功能说明:初始化分页查询对象.
     * @param pager 分页对象.
     * @param <T> <T>.
     * @return String 返回分页对象
     * @throws Exception e.
     */
    public static <T> String getDataForAgileGrid(final Pager<T> pager) throws Exception {
        JSONArray rows = JsonUtils.list2SimpleJSONArray(pager.getResult());
        JSONObject result = new JSONObject();
        result.put(CommonConstants.TOTAL, pager.getResultCount());
        result.put(CommonConstants.ROWS, rows);
        return JSON.toJSONString(result);
    }

    /**
     * 功能说明:返回普通json格式,只将结果集转换为json,不做特殊处理.
     * @param resMap 原始数据.
     * @return String 处理后的结果
     * @throws Exception e.
     */
    public static String getNormalData(final Object resMap) throws Exception {
        return JSON.toJSONString(resMap);
    }

    /**
     * 功能说明:获取agileUI表单对象需要的结果集格式.
     * @param resMap 原始数据.
     * @return String 处理后的结果
     * @throws Exception e.
     */
    public static String getDataForAgileForm(final Object resMap) throws Exception {
        return JSON.toJSONString(resMap);
    }
}
