package com.jeeww.core.service;

import com.jeeww.core.vo.ComboConfig;
import com.jeeww.core.vo.Pager;
import com.jeeww.core.vo.TreeConfig;
import com.jeeww.core.vo.TreeGridConfig;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * 类描述：接口. SerializeConfig ser = new SerializeConfig(); ser.put(java.util.Date.class, new
 * SimpleDateFormatSerializer("yyyy-MM-dd")); ser.put(java.sql.Date.class, new
 * SimpleDateFormatSerializer("yyyy-MM-dd")); JSON.toJSONString(treeGridObj, ser,
 * SerializerFeature.WriteNullListAsEmpty)
 * @author 蒋文武
 */
public interface BaseService {
    /**
     * 功能描述：通过HQL命名查询获得分页查询结果集对象.
     * @param namedQuery 命名id.
     * @param searchModel 参数条件类.
     * @return Pager 分页查询结果集对象.
     * @throws Exception 异常.
     */
    String getGridByHQLNamedQuery(String namedQuery, Pager searchModel) throws Exception;

    /**
     * 功能描述：通过SQL命名查询获得分页查询结果集对象.
     * @param namedQuery 命名id.
     * @param searchModel 参数条件类.
     * @return Pager 分页查询结果集对象.
     * @throws Exception 异常.
     */
    String getGridBySQLNamedQuery(String namedQuery, Pager searchModel) throws Exception;

    /**
     * 功能描述：直接通过hql查询获得分页查询结果集对象.
     * @param hql hql查询语句.
     * @param searchModel 参数条件类.
     * @return Pager 分页查询结果集对象.
     * @throws Exception 异常.
     */
    String getGridByHQL(String hql, Pager searchModel) throws Exception;

    /**
     * 功能描述：直接通过sql查询获得分页查询结果集对象.
     * @param sql sql查询语句.
     * @param searchModel 参数条件类.
     * @return Pager 分页查询结果集对象.
     * @throws Exception 异常.
     */
    String getGridBySQL(String sql, Pager searchModel) throws Exception;

    /**
     * 功能描述：获取树.
     * @param searchModel 参数条件类.
     * @param treeConfig treeConfig
     * @return JSONArray 返回树节点JSONArray.
     * @throws Exception 异常.
     */
    JSONArray getTreeBySQLNamedQuery(Object searchModel, TreeConfig treeConfig) throws Exception;

    /**
     * 功能描述：通过sql名称查询获取下拉框.
     * @param searchModel 参数条件类.
     * @param comboConfig 下拉列表设置.
     * @return JSONArray 返回树节点JSONArray.
     * @throws Exception 异常.
     */
    String getComboBySQLNamedQuery(Object searchModel, ComboConfig comboConfig) throws Exception;

    /**
     * 功能描述：通过HQL命名查询获得树形列表结果集对象.
     * @param treeGridConfig 配置.
     * @param searchModel 参数条件类.
     * @return String treeGrid字符串结果集.
     * @throws Exception 异常.
     */
    String getTreeGridByHQLNamedQuery(final Object searchModel, final TreeGridConfig treeGridConfig) throws Exception;

    /**
     * 功能描述：通过SQL命名查询获得树形列表结果集对象.
     * @param treeGridConfig 配置.
     * @param searchModel 参数条件类.
     * @return String treeGrid字符串结果集.
     * @throws Exception 异常.
     */
    String getTreeGridBySQLNamedQuery(final Object searchModel, final TreeGridConfig treeGridConfig) throws Exception;

    /**
     * 功能描述：通过SQL命名查询获得agileUI表单结果集对象.
     * @param namedQuery 命名id.
     * @param searchModel 参数条件类.
     * @return agileUI表单结果集对象.
     * @throws Exception 异常.
     */
    String getFormBySQLNamedQuery(final String namedQuery, final Object searchModel) throws Exception;

    /**
     * 功能描述：通过SQL命名查询获得agileUI表单结果集对象.
     * @param namedQuery 命名id.
     * @param searchModel 参数条件类.
     * @param customerDTO 返回结果集自定义DTO.
     * @return agileUI表单结果集对象.
     * @throws Exception 异常.
     */
    String getFormBySQLNamedQuery(final String namedQuery, final Object searchModel, Class<?> customerDTO)
            throws Exception;

    /**
     * 功能描述：通过HQL命名查询获得agileUI表单结果集对象.
     * @param namedQuery 命名id.
     * @param searchModel 参数条件类.
     * @return agileUI表单结果集对象.
     * @throws Exception 异常.
     */
    String getFormByHQLNamedQuery(final String namedQuery, final Object searchModel) throws Exception;

    /**
     * 功能描述：通过SQL命名查询获得json返回值,直接将对象转换为json字符串,不多其他处理.
     * @param namedQuery 命名id.
     * @param searchModel 参数条件类.
     * @return 未做特殊处理的json字符串.
     * @throws Exception 异常.
     */
    String getNormalDataBySQLNamedQuery(final String namedQuery, final Object searchModel) throws Exception;

    /**
     * 功能描述：通过SQL命名查询获得json返回值,直接将对象转换为json字符串,不多其他处理.
     * @param namedQuery 命名id.
     * @param searchModel 参数条件类.
     * @param customerDTO 返回结果集自定义DTO.
     * @return 未做特殊处理的json字符串.
     * @throws Exception 异常.
     */
    String getNormalDataBySQLNamedQuery(final String namedQuery, final Object searchModel, Class<?> customerDTO)
            throws Exception;

    /**
     * 功能描述：执行动态sql语句对数据库进行增删改操作,此方法不支持查询.
     * @param namedQuery 命名id.
     * @param parametersModel 参数条件类.
     * @throws Exception 异常.
     */
    void executeDynamicSql(final String namedQuery, final Object parametersModel) throws Exception;

    /**
     * 功能描述：返回国际化操作成功的返回消息信息.
     * @param msgKey 消息标志.
     * @return 国际化消息信息.
     * @throws Exception 异常.
     */
    JSONObject successMsg(String msgKey) throws Exception;

    /**
     * 功能描述：返回国际化操作成功的返回消息信息.
     * @param msgKey 消息标志.
     * @param msgParams 消息参数.
     * @return 国际化消息信息.
     * @throws Exception 异常.
     */
    JSONObject successMsg(String msgKey, Object msgParams) throws Exception;

    /**
     * 功能描述：返回国际化操作失败的返回消息信息.
     * @param msgKey 消息标志.
     * @return 国际化消息信息.
     * @throws Exception 异常.
     */
    JSONObject errorMsg(String msgKey) throws Exception;

    /**
     * 功能描述：返回国际化操作失败的返回消息信息.
     * @param bsKey 消息标志,用于业务逻辑标志.
     * @param msgKey 消息国际化标志.
     * @return 国际化消息信息.
     * @throws Exception 异常.
     */
    JSONObject normalMsg(String bsKey, String msgKey) throws Exception;

}
