package com;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;

import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

public class POITest {
    public static String[] files = { "彩电.xlsx", "厨电.xlsx", "电热.xlsx", "空调.xlsx", "生活家电.xlsx", "手机电脑数码.xlsx",
            "洗衣机.xlsx", "制冷.xlsx" };
    public static String[] sheets = { "常见问题", "日常保养", "操作指南", "故障排除" };

    /**
     * @param args
     */
    public static void main(String[] args) {
        try {
            create2("serviceObjCjwt.js", 0, "常见问题");
            create2("serviceObjRcby.js", 1, "日常保养");
            create2("serviceObjCzzn.js", 2, "操作指南");
            create2("serviceObjGzpc.js", 3, "故障排除");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void create(String fileName, int index, String name) throws FileNotFoundException, IOException {
        JSONObject obj = new JSONObject();// 我的服务大对象
        JSONObject objQuestions = new JSONObject();// 常见问题对象 内部存储格式 类别+问题对象
        for (int i = 0; i < files.length; i++) {
            String key = files[i].split("\\.")[0];// 常见问题类别 如彩电，空调
            JSONArray objQuestionArr = new JSONArray();
            String filePath = "D:\\tt\\" + files[i];
            // 创建对Excel工作簿文件的引用
            XSSFWorkbook workbook = new XSSFWorkbook(new FileInputStream(filePath));

            // 常见问题sheet页操作
            XSSFSheet sheet = workbook.getSheet(sheets[index]);
            XSSFRow row = null;
            int k = 1;
            do {
                row = sheet.getRow(k);
                if (row != null) {
                    // /////////////////////////
                    // XSSFCell cell1 = row.getCell((short) 0); // 栏目
                    XSSFCell cell2 = row.getCell((short) 1); // 产品
                    // XSSFCell cell3 = row.getCell((short) 2); // 分类
                    XSSFCell cell4 = row.getCell((short) 3); // 问题
                    XSSFCell cell5 = row.getCell((short) 4); // 答案
                    String chanpin = cell2.getRichStringCellValue().toString();
                    // 给常见问题对象赋值
                    JSONObject objQuestionsAns = new JSONObject();// 常见问题类别对应的问题对象，存放结果集为问题，和问题答案。
                    objQuestionsAns.put(cell4.getRichStringCellValue().toString(), cell5.getRichStringCellValue()
                            .toString());
                    objQuestionArr.add(objQuestionsAns);

                    // ////////////////////////
                }
                k++;
            } while (row != null);
            objQuestions.put(key, objQuestionArr);// 常见问题按类别赋值,比如所有电视的常见问题
            // 常见问题sheet页操作
        }
        obj.put(name, objQuestions);// 给我的服务增加常见问题对象 接着加3
        String a = JSONObject.toJSONString(obj);
        File file = new File("d:\\tt\\" + fileName);
        if (file.exists()) {
            file.delete();
        } else {
            file.createNewFile();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(file, true));
        out.write(a);
        out.close();
        out = null;
        file = null;
    }

    public static void create2(String fileName, int index, String name) throws FileNotFoundException, IOException {
        JSONObject obj = new JSONObject();// 我的服务大对象
        JSONObject objQuestions = new JSONObject();// 常见问题对象 内部存储格式 类别+问题对象
        for (int i = 0; i < files.length; i++) {
            String key = files[i].split("\\.")[0];// 常见问题类别 如彩电，空调

            String filePath = "D:\\tt\\" + files[i];
            // 创建对Excel工作簿文件的引用
            XSSFWorkbook workbook = new XSSFWorkbook(new FileInputStream(filePath));
            // 常见问题sheet页操作
            XSSFSheet sheet = workbook.getSheet(sheets[index]);
            JSONObject xx = new JSONObject();// 产品小分类
            XSSFRow row = null;
            int k = 1;
            do {
                row = sheet.getRow(k);
                if (row != null) {
                    // /////////////////////////
                    // XSSFCell cell1 = row.getCell((short) 0); // 栏目
                    XSSFCell cell2 = row.getCell((short) 1); // 产品
                    // XSSFCell cell3 = row.getCell((short) 2); // 分类
                    XSSFCell cell4 = row.getCell((short) 3); // 问题
                    XSSFCell cell5 = row.getCell((short) 4); // 答案
                    String chanpin = cell2.getRichStringCellValue().toString();
                    JSONArray list = xx.getJSONArray(chanpin);
                    if (list == null || list.isEmpty()) {
                        JSONArray objQuestionArr = new JSONArray();
                        // 给常见问题对象赋值
                        JSONObject objQuestionsAns = new JSONObject();// 常见问题类别对应的问题对象，存放结果集为问题，和问题答案。
                        objQuestionsAns.put(cell4.getRichStringCellValue().toString(), cell5.getRichStringCellValue()
                                .toString());
                        objQuestionArr.add(objQuestionsAns);
                        // ////////////////////////
                        xx.put(chanpin, objQuestionArr);
                    } else {
                        // 给常见问题对象赋值
                        JSONObject objQuestionsAns = new JSONObject();// 常见问题类别对应的问题对象，存放结果集为问题，和问题答案。
                        objQuestionsAns.put(cell4.getRichStringCellValue().toString(), cell5.getRichStringCellValue()
                                .toString());
                        list.add(objQuestionsAns);
                        // ////////////////////////
                        xx.put(chanpin, list);
                    }
                }
                k++;
            } while (row != null);
            objQuestions.put(key, xx);// 常见问题按类别赋值,比如所有电视的常见问题
            // 常见问题sheet页操作
        }
        obj.put(name, objQuestions);// 给我的服务增加常见问题对象 接着加3
        String a = JSONObject.toJSONString(obj);
        File file = new File("d:\\tt\\" + fileName);
        if (file.exists()) {
            file.delete();
        } else {
            file.createNewFile();
        }
        BufferedWriter out = new BufferedWriter(new FileWriter(file, true));
        out.write(a);
        out.close();
        out = null;
        file = null;
    }
}
