/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jivesoftware.smack.util.collections.EmptyIterator;
import org.jivesoftware.smack.util.collections.EmptyMapIterator;
import org.jivesoftware.smack.util.collections.IterableMap;
import org.jivesoftware.smack.util.collections.KeyValue;
import org.jivesoftware.smack.util.collections.MapIterator;

public class AbstractHashedMap<K, V>
extends AbstractMap<K, V>
implements IterableMap<K, V> {
    protected static final int DEFAULT_CAPACITY = 16;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int DEFAULT_THRESHOLD = 12;
    protected static final String GETKEY_INVALID = "getKey() can only be called after next() and before remove()";
    protected static final String GETVALUE_INVALID = "getValue() can only be called after next() and before remove()";
    protected static final int MAXIMUM_CAPACITY = 0x40000000;
    protected static final String NO_NEXT_ENTRY = "No next() entry in the iteration";
    protected static final String NO_PREVIOUS_ENTRY = "No previous() entry in the iteration";
    protected static final Object NULL = new Object();
    protected static final String REMOVE_INVALID = "remove() can only be called once after next()";
    protected static final String SETVALUE_INVALID = "setValue() can only be called after next() and before remove()";
    protected transient HashEntry<K, V>[] data;
    protected transient EntrySet<K, V> entrySet;
    protected transient KeySet<K, V> keySet;
    protected transient float loadFactor;
    protected transient int modCount;
    protected transient int size;
    protected transient int threshold;
    protected transient Values<K, V> values;

    protected AbstractHashedMap() {
    }

    protected AbstractHashedMap(int n2) {
        this(n2, 0.75f);
    }

    protected AbstractHashedMap(int n2, float f2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Load factor must be greater than 0");
        }
        this.loadFactor = f2;
        this.threshold = this.calculateThreshold(n2, f2);
        this.data = new HashEntry[this.calculateNewCapacity(n2)];
        this.init();
    }

    protected AbstractHashedMap(int n2, float f2, int n3) {
        this.loadFactor = f2;
        this.data = new HashEntry[n2];
        this.threshold = n3;
        this.init();
    }

    protected AbstractHashedMap(Map<? extends K, ? extends V> map) {
        this(Math.max(map.size() * 2, 16), 0.75f);
        this.putAll(map);
    }

    protected void addEntry(HashEntry<K, V> hashEntry, int n2) {
        this.data[n2] = hashEntry;
    }

    protected void addMapping(int n2, int n3, K k2, V v2) {
        ++this.modCount;
        this.addEntry(this.createEntry(this.data[n2], n3, k2, v2), n2);
        ++this.size;
        this.checkCapacity();
    }

    /*
     * Unable to fully structure code
     */
    protected int calculateNewCapacity(int var1_1) {
        var2_2 = 1;
        if (var1_1 <= 0x40000000) ** GOTO lbl7
        var1_1 = 0x40000000;
lbl4:
        // 2 sources

        return var1_1;
lbl-1000:
        // 1 sources

        {
            var2_2 <<= 1;
lbl7:
            // 2 sources

            ** while (var2_2 < var1_1)
        }
lbl8:
        // 1 sources

        var1_1 = var2_2;
        ** while (var2_2 <= 0x40000000)
lbl10:
        // 1 sources

        return 0x40000000;
    }

    protected int calculateThreshold(int n2, float f2) {
        return (int)((float)n2 * f2);
    }

    protected void checkCapacity() {
        int n2;
        if (this.size >= this.threshold && (n2 = this.data.length * 2) <= 0x40000000) {
            this.ensureCapacity(n2);
        }
    }

    @Override
    public void clear() {
        ++this.modCount;
        HashEntry<K, V>[] hashEntryArray = this.data;
        int n2 = hashEntryArray.length - 1;
        while (true) {
            if (n2 < 0) {
                this.size = 0;
                return;
            }
            hashEntryArray[n2] = null;
            --n2;
        }
    }

    @Override
    protected Object clone() {
        try {
            AbstractHashedMap abstractHashedMap = (AbstractHashedMap)super.clone();
            abstractHashedMap.data = new HashEntry[this.data.length];
            abstractHashedMap.entrySet = null;
            abstractHashedMap.keySet = null;
            abstractHashedMap.values = null;
            abstractHashedMap.modCount = 0;
            abstractHashedMap.size = 0;
            abstractHashedMap.init();
            abstractHashedMap.putAll(this);
            return abstractHashedMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean containsKey(Object object) {
        Object object2 = object == null ? NULL : object;
        int n2 = this.hash(object2);
        object2 = this.data[this.hashIndex(n2, this.data.length)];
        while (object2 != null) {
            if (((HashEntry)object2).hashCode == n2 && this.isEqualKey(object, ((HashEntry)object2).getKey())) {
                return true;
            }
            object2 = ((HashEntry)object2).next;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean containsValue(Object hashEntry) {
        boolean bl;
        boolean bl2 = true;
        if (hashEntry == null) {
            int n2 = 0;
            int n3 = this.data.length;
            block0: while (true) {
                if (n2 >= n3) {
                    return false;
                }
                hashEntry = this.data[n2];
                while (true) {
                    if (hashEntry == null) {
                        ++n2;
                        continue block0;
                    }
                    bl = bl2;
                    if (hashEntry.getValue() == null) return bl;
                    hashEntry = hashEntry.next;
                }
                break;
            }
        }
        int n4 = 0;
        int n5 = this.data.length;
        block2: while (n4 < n5) {
            HashEntry<K, V> hashEntry2 = this.data[n4];
            while (true) {
                if (hashEntry2 == null) {
                    ++n4;
                    continue block2;
                }
                bl = bl2;
                if (this.isEqualValue(hashEntry, hashEntry2.getValue())) return bl;
                hashEntry2 = hashEntry2.next;
            }
            break;
        }
        return false;
    }

    protected HashEntry<K, V> createEntry(HashEntry<K, V> hashEntry, int n2, K k2, V v2) {
        return new HashEntry<K, V>(hashEntry, n2, k2, v2);
    }

    protected Iterator<Map.Entry<K, V>> createEntrySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new EntrySetIterator(this);
    }

    protected Iterator<K> createKeySetIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new KeySetIterator(this);
    }

    protected Iterator<V> createValuesIterator() {
        if (this.size() == 0) {
            return EmptyIterator.INSTANCE;
        }
        return new ValuesIterator(this);
    }

    protected void destroyEntry(HashEntry<K, V> hashEntry) {
        hashEntry.next = null;
        ((HashEntry)hashEntry).key = null;
        ((HashEntry)hashEntry).value = null;
    }

    protected void doReadObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.loadFactor = objectInputStream.readFloat();
        int n2 = objectInputStream.readInt();
        int n3 = objectInputStream.readInt();
        this.init();
        this.data = new HashEntry[n2];
        n2 = 0;
        while (true) {
            if (n2 >= n3) {
                this.threshold = this.calculateThreshold(this.data.length, this.loadFactor);
                return;
            }
            this.put(objectInputStream.readObject(), objectInputStream.readObject());
            ++n2;
        }
    }

    protected void doWriteObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeFloat(this.loadFactor);
        objectOutputStream.writeInt(this.data.length);
        objectOutputStream.writeInt(this.size);
        MapIterator<K, V> mapIterator = this.mapIterator();
        while (mapIterator.hasNext()) {
            objectOutputStream.writeObject(mapIterator.next());
            objectOutputStream.writeObject(mapIterator.getValue());
        }
        return;
    }

    protected void ensureCapacity(int n2) {
        int n3 = this.data.length;
        if (n2 <= n3) {
            return;
        }
        if (this.size == 0) {
            this.threshold = this.calculateThreshold(n2, this.loadFactor);
            this.data = new HashEntry[n2];
            return;
        }
        HashEntry<K, V>[] hashEntryArray = this.data;
        HashEntry[] hashEntryArray2 = new HashEntry[n2];
        ++this.modCount;
        --n3;
        while (true) {
            if (n3 < 0) {
                this.threshold = this.calculateThreshold(n2, this.loadFactor);
                this.data = hashEntryArray2;
                return;
            }
            HashEntry<K, V> hashEntry = hashEntryArray[n3];
            if (hashEntry != null) {
                HashEntry hashEntry2;
                hashEntryArray[n3] = null;
                do {
                    hashEntry2 = hashEntry.next;
                    int n4 = this.hashIndex(hashEntry.hashCode, n2);
                    hashEntry.next = hashEntryArray2[n4];
                    hashEntryArray2[n4] = hashEntry;
                    hashEntry = hashEntry2;
                } while (hashEntry2 != null);
            }
            --n3;
        }
    }

    protected int entryHashCode(HashEntry<K, V> hashEntry) {
        return hashEntry.hashCode;
    }

    protected K entryKey(HashEntry<K, V> hashEntry) {
        return (K)((HashEntry)hashEntry).key;
    }

    protected HashEntry<K, V> entryNext(HashEntry<K, V> hashEntry) {
        return hashEntry.next;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet(this);
        }
        return this.entrySet;
    }

    protected V entryValue(HashEntry<K, V> hashEntry) {
        return (V)((HashEntry)hashEntry).value;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        if ((object = (Map)object).size() != this.size()) {
            return false;
        }
        MapIterator<K, V> mapIterator = this.mapIterator();
        try {
            while (mapIterator.hasNext()) {
                K k2 = mapIterator.next();
                V v2 = mapIterator.getValue();
                if (v2 == null) {
                    if (object.get(k2) != null) return false;
                    if (object.containsKey(k2)) continue;
                    return false;
                }
                boolean bl = v2.equals(object.get(k2));
                if (!bl) return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public V get(Object object) {
        Object object2 = object == null ? NULL : object;
        int n2 = this.hash(object2);
        object2 = this.data[this.hashIndex(n2, this.data.length)];
        while (object2 != null) {
            if (((HashEntry)object2).hashCode == n2 && this.isEqualKey(object, ((HashEntry)object2).key)) {
                return ((HashEntry)object2).getValue();
            }
            object2 = ((HashEntry)object2).next;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected HashEntry<K, V> getEntry(Object object) {
        Object object2 = object == null ? NULL : object;
        int n2 = this.hash(object2);
        object2 = this.data[this.hashIndex(n2, this.data.length)];
        while (object2 != null) {
            if (((HashEntry)object2).hashCode == n2) {
                HashEntry<K, V> hashEntry = object2;
                if (this.isEqualKey(object, ((HashEntry)object2).getKey())) return hashEntry;
            }
            object2 = ((HashEntry)object2).next;
        }
        return null;
    }

    protected int hash(Object object) {
        int n2 = object.hashCode();
        n2 += ~(n2 << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        return n2 ^ n2 >>> 10;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        Iterator<Map.Entry<K, V>> iterator = this.createEntrySetIterator();
        while (iterator.hasNext()) {
            n2 += ((Object)iterator.next()).hashCode();
        }
        return n2;
    }

    protected int hashIndex(int n2, int n3) {
        return n3 - 1 & n2;
    }

    protected void init() {
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    protected boolean isEqualKey(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    protected boolean isEqualValue(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet(this);
        }
        return this.keySet;
    }

    @Override
    public MapIterator<K, V> mapIterator() {
        if (this.size == 0) {
            return EmptyMapIterator.INSTANCE;
        }
        return new HashMapIterator(this);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public V put(K object, V v2) {
        Object object2 = object == null ? NULL : object;
        int n2 = this.hash(object2);
        int n3 = this.hashIndex(n2, this.data.length);
        object2 = this.data[n3];
        while (true) {
            void var2_3;
            if (object2 == null) {
                this.addMapping(n3, n2, object, var2_3);
                return null;
            }
            if (((HashEntry)object2).hashCode == n2 && this.isEqualKey(object, ((HashEntry)object2).getKey())) {
                V v3 = ((HashEntry)object2).getValue();
                this.updateEntry((HashEntry<K, V>)object2, var2_3);
                return v3;
            }
            object2 = ((HashEntry)object2).next;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> iterator) {
        int n2 = iterator.size();
        if (n2 != 0) {
            this.ensureCapacity(this.calculateNewCapacity((int)((float)(this.size + n2) / this.loadFactor + 1.0f)));
            for (Map.Entry entry : iterator.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public V remove(Object object) {
        Object object2 = object == null ? NULL : object;
        int n2 = this.hash(object2);
        int n3 = this.hashIndex(n2, this.data.length);
        object2 = this.data[n3];
        HashEntry<K, V> hashEntry = null;
        while (object2 != null) {
            if (((HashEntry)object2).hashCode == n2 && this.isEqualKey(object, ((HashEntry)object2).getKey())) {
                object = ((HashEntry)object2).getValue();
                this.removeMapping((HashEntry<K, V>)object2, n3, hashEntry);
                return (V)object;
            }
            hashEntry = object2;
            object2 = ((HashEntry)object2).next;
        }
        return null;
    }

    protected void removeEntry(HashEntry<K, V> hashEntry, int n2, HashEntry<K, V> hashEntry2) {
        if (hashEntry2 == null) {
            this.data[n2] = hashEntry.next;
            return;
        }
        hashEntry2.next = hashEntry.next;
    }

    protected void removeMapping(HashEntry<K, V> hashEntry, int n2, HashEntry<K, V> hashEntry2) {
        ++this.modCount;
        this.removeEntry(hashEntry, n2, hashEntry2);
        --this.size;
        this.destroyEntry(hashEntry);
    }

    protected void reuseEntry(HashEntry<K, V> hashEntry, int n2, int n3, K k2, V v2) {
        hashEntry.next = this.data[n2];
        hashEntry.hashCode = n3;
        ((HashEntry)hashEntry).key = k2;
        ((HashEntry)hashEntry).value = v2;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public String toString() {
        if (this.size() == 0) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(this.size() * 32);
        stringBuilder.append('{');
        MapIterator<K, V> mapIterator = this.mapIterator();
        boolean bl = mapIterator.hasNext();
        while (true) {
            boolean bl2;
            if (!bl) {
                stringBuilder.append('}');
                return stringBuilder.toString();
            }
            Object object = mapIterator.next();
            V v2 = mapIterator.getValue();
            Object object2 = object;
            if (object == this) {
                object2 = "(this Map)";
            }
            object = stringBuilder.append(object2).append('=');
            object2 = v2;
            if (v2 == this) {
                object2 = "(this Map)";
            }
            ((StringBuilder)object).append(object2);
            bl = bl2 = mapIterator.hasNext();
            if (!bl2) continue;
            stringBuilder.append(',').append(' ');
            bl = bl2;
        }
    }

    protected void updateEntry(HashEntry<K, V> hashEntry, V v2) {
        hashEntry.setValue(v2);
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values(this);
        }
        return this.values;
    }

    protected static class EntrySet<K, V>
    extends AbstractSet<Map.Entry<K, V>> {
        protected final AbstractHashedMap<K, V> parent;

        protected EntrySet(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        public boolean contains(Map.Entry<K, V> entry) {
            HashEntry<K, V> hashEntry = this.parent.getEntry(entry.getKey());
            return hashEntry != null && hashEntry.equals(entry);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this.parent.createEntrySetIterator();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry) || !this.contains(object)) {
                return false;
            }
            object = ((Map.Entry)object).getKey();
            this.parent.remove(object);
            return true;
        }

        @Override
        public int size() {
            return this.parent.size();
        }
    }

    protected static class EntrySetIterator<K, V>
    extends HashIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        protected EntrySetIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public HashEntry<K, V> next() {
            return super.nextEntry();
        }
    }

    protected static class HashEntry<K, V>
    implements Map.Entry<K, V>,
    KeyValue<K, V> {
        protected int hashCode;
        private K key;
        protected HashEntry<K, V> next;
        private V value;

        protected HashEntry(HashEntry<K, V> hashEntry, int n2, K k2, V v2) {
            this.next = hashEntry;
            this.hashCode = n2;
            this.key = k2;
            this.value = v2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean equals(Object object) {
            if (object == this) return true;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            object = (Map.Entry)object;
            if (!(this.getKey() == null ? object.getKey() == null : this.getKey().equals(object.getKey()))) return false;
            if (this.getValue() == null) {
                if (object.getValue() != null) return false;
                return true;
            }
            if (this.getValue().equals(object.getValue())) return true;
            return false;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public int hashCode() {
            int n2 = 0;
            int n3 = this.getKey() == null ? 0 : this.getKey().hashCode();
            if (this.getValue() == null) {
                return n3 ^ n2;
            }
            n2 = this.getValue().hashCode();
            return n3 ^ n2;
        }

        public void setKey(K k2) {
            this.key = k2;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        public String toString() {
            return "" + this.getKey() + '=' + this.getValue();
        }
    }

    protected static abstract class HashIterator<K, V> {
        protected int expectedModCount;
        protected int hashIndex;
        protected HashEntry<K, V> last;
        protected HashEntry<K, V> next;
        protected final AbstractHashedMap parent;

        protected HashIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
            HashEntry<K, V>[] hashEntryArray = abstractHashedMap.data;
            int n2 = hashEntryArray.length;
            HashEntry hashEntry = null;
            while (true) {
                if (n2 <= 0 || hashEntry != null) {
                    this.next = hashEntry;
                    this.hashIndex = n2;
                    this.expectedModCount = abstractHashedMap.modCount;
                    return;
                }
                hashEntry = hashEntryArray[--n2];
            }
        }

        protected HashEntry<K, V> currentEntry() {
            return this.last;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        protected HashEntry<K, V> nextEntry() {
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            HashEntry<K, V> hashEntry = this.next;
            if (hashEntry == null) {
                throw new NoSuchElementException(AbstractHashedMap.NO_NEXT_ENTRY);
            }
            HashEntry<K, V>[] hashEntryArray = this.parent.data;
            int n2 = this.hashIndex;
            HashEntry hashEntry2 = hashEntry.next;
            while (true) {
                if (hashEntry2 != null || n2 <= 0) {
                    this.next = hashEntry2;
                    this.hashIndex = n2;
                    this.last = hashEntry;
                    return hashEntry;
                }
                hashEntry2 = hashEntryArray[--n2];
            }
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException(AbstractHashedMap.REMOVE_INVALID);
            }
            if (this.parent.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.parent.remove(this.last.getKey());
            this.last = null;
            this.expectedModCount = this.parent.modCount;
        }

        public String toString() {
            if (this.last != null) {
                return "Iterator[" + this.last.getKey() + "=" + this.last.getValue() + "]";
            }
            return "Iterator[]";
        }
    }

    protected static class HashMapIterator<K, V>
    extends HashIterator<K, V>
    implements MapIterator<K, V> {
        protected HashMapIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public K getKey() {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.GETKEY_INVALID);
            }
            return hashEntry.getKey();
        }

        @Override
        public V getValue() {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.GETVALUE_INVALID);
            }
            return hashEntry.getValue();
        }

        @Override
        public K next() {
            return super.nextEntry().getKey();
        }

        @Override
        public V setValue(V v2) {
            HashEntry hashEntry = this.currentEntry();
            if (hashEntry == null) {
                throw new IllegalStateException(AbstractHashedMap.SETVALUE_INVALID);
            }
            return hashEntry.setValue(v2);
        }
    }

    protected static class KeySet<K, V>
    extends AbstractSet<K> {
        protected final AbstractHashedMap<K, V> parent;

        protected KeySet(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.parent.containsKey(object);
        }

        @Override
        public Iterator<K> iterator() {
            return this.parent.createKeySetIterator();
        }

        @Override
        public boolean remove(Object object) {
            boolean bl = this.parent.containsKey(object);
            this.parent.remove(object);
            return bl;
        }

        @Override
        public int size() {
            return this.parent.size();
        }
    }

    protected static class KeySetIterator<K, V>
    extends HashIterator<K, V>
    implements Iterator<K> {
        protected KeySetIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public K next() {
            return super.nextEntry().getKey();
        }
    }

    protected static class Values<K, V>
    extends AbstractCollection<V> {
        protected final AbstractHashedMap<K, V> parent;

        protected Values(AbstractHashedMap<K, V> abstractHashedMap) {
            this.parent = abstractHashedMap;
        }

        @Override
        public void clear() {
            this.parent.clear();
        }

        @Override
        public boolean contains(Object object) {
            return this.parent.containsValue(object);
        }

        @Override
        public Iterator<V> iterator() {
            return this.parent.createValuesIterator();
        }

        @Override
        public int size() {
            return this.parent.size();
        }
    }

    protected static class ValuesIterator<K, V>
    extends HashIterator<K, V>
    implements Iterator<V> {
        protected ValuesIterator(AbstractHashedMap<K, V> abstractHashedMap) {
            super(abstractHashedMap);
        }

        @Override
        public V next() {
            return super.nextEntry().getValue();
        }
    }
}

