/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import org.jivesoftware.smack.util.Base64;

public class StringUtils {
    private static final char[] AMP_ENCODE;
    private static final char[] APOS_ENCODE;
    private static final char[] GT_ENCODE;
    private static final char[] LT_ENCODE;
    private static final char[] QUOTE_ENCODE;
    private static MessageDigest digest;
    private static char[] numbersAndLetters;
    private static Random randGen;

    static {
        QUOTE_ENCODE = "&quot;".toCharArray();
        APOS_ENCODE = "&apos;".toCharArray();
        AMP_ENCODE = "&amp;".toCharArray();
        LT_ENCODE = "&lt;".toCharArray();
        GT_ENCODE = "&gt;".toCharArray();
        digest = null;
        randGen = new Random();
        numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    }

    private StringUtils() {
    }

    public static byte[] decodeBase64(String string2) {
        return Base64.decode(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String encodeBase64(String object) {
        byte[] byArray = null;
        try {
            object = ((String)object).getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            object = byArray;
            return StringUtils.encodeBase64((byte[])object);
        }
        return StringUtils.encodeBase64((byte[])object);
    }

    public static String encodeBase64(byte[] byArray) {
        return StringUtils.encodeBase64(byArray, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String encodeBase64(byte[] byArray, int n2, int n3, boolean bl) {
        int n4;
        if (bl) {
            n4 = 0;
            return Base64.encodeBytes(byArray, n2, n3, n4);
        }
        n4 = 8;
        return Base64.encodeBytes(byArray, n2, n3, n4);
    }

    public static String encodeBase64(byte[] byArray, boolean bl) {
        return StringUtils.encodeBase64(byArray, 0, byArray.length, bl);
    }

    public static String encodeHex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray[n3];
            if ((by & 0xFF) < 16) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toString(by & 0xFF, 16));
            ++n3;
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String escapeForXML(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = 0;
        int n3 = 0;
        char[] cArray = string2.toCharArray();
        int n4 = cArray.length;
        StringBuilder stringBuilder = new StringBuilder((int)((double)n4 * 1.3));
        while (true) {
            int n5;
            block13: {
                char c2;
                block16: {
                    block17: {
                        block15: {
                            block14: {
                                if (n2 >= n4) {
                                    if (n3 == 0) return string2;
                                    if (n2 <= n3) return stringBuilder.toString();
                                    stringBuilder.append(cArray, n3, n2 - n3);
                                    return stringBuilder.toString();
                                }
                                c2 = cArray[n2];
                                n5 = n3;
                                if (c2 > '>') break block13;
                                if (c2 != '<') break block14;
                                if (n2 > n3) {
                                    stringBuilder.append(cArray, n3, n2 - n3);
                                }
                                n5 = n2 + 1;
                                stringBuilder.append(LT_ENCODE);
                                break block13;
                            }
                            if (c2 != '>') break block15;
                            if (n2 > n3) {
                                stringBuilder.append(cArray, n3, n2 - n3);
                            }
                            n5 = n2 + 1;
                            stringBuilder.append(GT_ENCODE);
                            break block13;
                        }
                        if (c2 != '&') break block16;
                        if (n2 > n3) {
                            stringBuilder.append(cArray, n3, n2 - n3);
                        }
                        if (n4 <= n2 + 5 || cArray[n2 + 1] != '#' || !Character.isDigit(cArray[n2 + 2]) || !Character.isDigit(cArray[n2 + 3]) || !Character.isDigit(cArray[n2 + 4])) break block17;
                        n5 = n3;
                        if (cArray[n2 + 5] == ';') break block13;
                    }
                    n5 = n2 + 1;
                    stringBuilder.append(AMP_ENCODE);
                    break block13;
                }
                if (c2 == '\"') {
                    if (n2 > n3) {
                        stringBuilder.append(cArray, n3, n2 - n3);
                    }
                    n5 = n2 + 1;
                    stringBuilder.append(QUOTE_ENCODE);
                } else {
                    n5 = n3;
                    if (c2 == '\'') {
                        if (n2 > n3) {
                            stringBuilder.append(cArray, n3, n2 - n3);
                        }
                        n5 = n2 + 1;
                        stringBuilder.append(APOS_ENCODE);
                    }
                }
            }
            ++n2;
            n3 = n5;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String escapeNode(String string2) {
        if (string2 == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string2.length() + 8);
        int n2 = 0;
        int n3 = string2.length();
        while (true) {
            block14: {
                if (n2 >= n3) {
                    return stringBuilder.toString();
                }
                char c2 = string2.charAt(n2);
                switch (c2) {
                    default: {
                        if (!Character.isWhitespace(c2)) break;
                        stringBuilder.append("\\20");
                        break block14;
                    }
                    case '\"': {
                        stringBuilder.append("\\22");
                        break block14;
                    }
                    case '&': {
                        stringBuilder.append("\\26");
                        break block14;
                    }
                    case '\'': {
                        stringBuilder.append("\\27");
                        break block14;
                    }
                    case '/': {
                        stringBuilder.append("\\2f");
                        break block14;
                    }
                    case ':': {
                        stringBuilder.append("\\3a");
                        break block14;
                    }
                    case '<': {
                        stringBuilder.append("\\3c");
                        break block14;
                    }
                    case '>': {
                        stringBuilder.append("\\3e");
                        break block14;
                    }
                    case '@': {
                        stringBuilder.append("\\40");
                        break block14;
                    }
                    case '\\': {
                        stringBuilder.append("\\5c");
                        break block14;
                    }
                }
                stringBuilder.append(c2);
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String hash(String string2) {
        synchronized (StringUtils.class) {
            MessageDigest messageDigest = digest;
            if (messageDigest == null) {
                try {
                    digest = MessageDigest.getInstance("SHA-1");
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    System.err.println("Failed to load the SHA-1 MessageDigest. Jive will be unable to function normally.");
                }
            }
            try {
                digest.update(string2.getBytes("UTF-8"));
                return StringUtils.encodeHex(digest.digest());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println(unsupportedEncodingException);
            }
            return StringUtils.encodeHex(digest.digest());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String parseBareAddress(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = string2.indexOf("/");
        String string3 = string2;
        if (n2 < 0) return string3;
        if (n2 != 0) return string2.substring(0, n2);
        return "";
    }

    public static String parseName(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = string2.lastIndexOf("@");
        if (n2 <= 0) {
            return "";
        }
        return string2.substring(0, n2);
    }

    public static String parseResource(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = string2.indexOf("/");
        if (n2 + 1 > string2.length() || n2 < 0) {
            return "";
        }
        return string2.substring(n2 + 1);
    }

    public static String parseServer(String string2) {
        if (string2 == null) {
            return null;
        }
        int n2 = string2.lastIndexOf("@");
        if (n2 + 1 > string2.length()) {
            return "";
        }
        int n3 = string2.indexOf("/");
        if (n3 > 0 && n3 > n2) {
            return string2.substring(n2 + 1, n3);
        }
        return string2.substring(n2 + 1);
    }

    public static String randomString(int n2) {
        if (n2 < 1) {
            return null;
        }
        char[] cArray = new char[n2];
        n2 = 0;
        while (n2 < cArray.length) {
            cArray[n2] = numbersAndLetters[randGen.nextInt(71)];
            ++n2;
        }
        return new String(cArray);
    }

    /*
     * Unable to fully structure code
     */
    public static String unescapeNode(String var0) {
        block19: {
            block18: {
                block17: {
                    if (var0 == null) {
                        return null;
                    }
                    var6_1 = var0.toCharArray();
                    var7_2 = new StringBuilder(var6_1.length);
                    var2_3 = 0;
                    var3_4 = var6_1.length;
                    block12: while (true) {
                        if (var2_3 >= var3_4) {
                            return var7_2.toString();
                        }
                        var1_5 = var0.charAt(var2_3);
                        if (var1_5 != '\\' || var2_3 + 2 >= var3_4) ** GOTO lbl-1000
                        var4_6 = var6_1[var2_3 + 1];
                        var5_7 = var6_1[var2_3 + 2];
                        if (var4_6 != '2') break block17;
                        switch (var5_7) {
                            default: lbl-1000:
                            // 5 sources

                            {
                                while (true) {
                                    var7_2.append(var1_5);
lbl20:
                                    // 11 sources

                                    while (true) {
                                        ++var2_3;
                                        continue block12;
                                        break;
                                    }
                                    break;
                                }
                            }
                            case '0': {
                                var7_2.append(' ');
                                var2_3 += 2;
                                ** GOTO lbl20
                            }
                            case '2': {
                                var7_2.append('\"');
                                var2_3 += 2;
                                ** GOTO lbl20
                            }
                            case '6': {
                                var7_2.append('&');
                                var2_3 += 2;
                                ** GOTO lbl20
                            }
                            case '7': {
                                var7_2.append('\'');
                                var2_3 += 2;
                                ** GOTO lbl20
                            }
                            case 'f': 
                        }
                        break;
                    }
                    var7_2.append('/');
                    var2_3 += 2;
                    ** GOTO lbl20
                }
                if (var4_6 != '3') break block18;
                switch (var5_7) {
                    default: {
                        ** GOTO lbl-1000
                    }
                    case 'a': {
                        var7_2.append(':');
                        var2_3 += 2;
                        ** GOTO lbl20
                    }
                    case 'c': {
                        var7_2.append('<');
                        var2_3 += 2;
                        ** GOTO lbl20
                    }
                    case 'e': 
                }
                var7_2.append('>');
                var2_3 += 2;
                ** GOTO lbl20
            }
            if (var4_6 != '4') break block19;
            if (var5_7 != '0') ** GOTO lbl-1000
            var7_2.append("@");
            var2_3 += 2;
            ** GOTO lbl20
        }
        if (var4_6 == '5' && var5_7 == 'c') ** break;
        ** while (true)
        var7_2.append("\\");
        var2_3 += 2;
        ** while (true)
    }
}

