/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.packet.Authentication;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.DefaultPacketExtension;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Registration;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.packet.StreamError;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class PacketParserUtils {
    private static final String PROPERTIES_NAMESPACE = "http://www.jivesoftware.com/xmlns/xmpp/properties";

    private static Object decode(Class clazz, String string2) throws Exception {
        if (clazz.getName().equals("java.lang.String")) {
            return string2;
        }
        if (clazz.getName().equals("boolean")) {
            return Boolean.valueOf(string2);
        }
        if (clazz.getName().equals("int")) {
            return Integer.valueOf(string2);
        }
        if (clazz.getName().equals("long")) {
            return Long.valueOf(string2);
        }
        if (clazz.getName().equals("float")) {
            return Float.valueOf(string2);
        }
        if (clazz.getName().equals("double")) {
            return Double.valueOf(string2);
        }
        if (clazz.getName().equals("java.lang.Class")) {
            return Class.forName(string2);
        }
        return null;
    }

    private static String getLanguageAttribute(XmlPullParser xmlPullParser) {
        int n2 = 0;
        while (n2 < xmlPullParser.getAttributeCount()) {
            String string2 = xmlPullParser.getAttributeName(n2);
            if ("xml:lang".equals(string2) || "lang".equals(string2) && "xml".equals(xmlPullParser.getAttributePrefix(n2))) {
                return xmlPullParser.getAttributeValue(n2);
            }
            ++n2;
        }
        return null;
    }

    private static Authentication parseAuthentication(XmlPullParser xmlPullParser) throws Exception {
        Authentication authentication = new Authentication();
        boolean bl = false;
        while (!bl) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                if (xmlPullParser.getName().equals("username")) {
                    authentication.setUsername(xmlPullParser.nextText());
                    continue;
                }
                if (xmlPullParser.getName().equals("password")) {
                    authentication.setPassword(xmlPullParser.nextText());
                    continue;
                }
                if (xmlPullParser.getName().equals("digest")) {
                    authentication.setDigest(xmlPullParser.nextText());
                    continue;
                }
                if (!xmlPullParser.getName().equals("resource")) continue;
                authentication.setResource(xmlPullParser.nextText());
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        return authentication;
    }

    public static Collection<String> parseCompressionMethods(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (!bl) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                if (!xmlPullParser.getName().equals("method")) continue;
                arrayList.add(xmlPullParser.nextText());
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("compression")) continue;
            bl = true;
        }
        return arrayList;
    }

    private static String parseContent(XmlPullParser xmlPullParser) throws XmlPullParserException, IOException {
        String string2 = "";
        int n2 = xmlPullParser.getDepth();
        while (xmlPullParser.next() != 3 || xmlPullParser.getDepth() != n2) {
            string2 = String.valueOf(string2) + xmlPullParser.getText();
        }
        return string2;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XMPPError parseError(XmlPullParser object) throws Exception {
        void var6_10;
        void var0_3;
        XMPPError.Type type;
        String string2 = "-1";
        String string3 = null;
        String string4 = null;
        Object var6_9 = null;
        ArrayList<PacketExtension> arrayList = new ArrayList<PacketExtension>();
        int n2 = 0;
        while (true) {
            if (n2 >= object.getAttributeCount()) break;
            if (object.getAttributeName(n2).equals("code")) {
                string2 = object.getAttributeValue("", "code");
            }
            if (object.getAttributeName(n2).equals("type")) {
                string3 = object.getAttributeValue("", "type");
            }
            ++n2;
        }
        n2 = 0;
        while (true) {
            if (n2 != 0) {
                XMPPError.Type type2 = type = XMPPError.Type.CANCEL;
                if (string3 == null) return new XMPPError(Integer.parseInt(string2), (XMPPError.Type)var0_3, (String)var6_10, string4, arrayList);
                XMPPError.Type type3 = XMPPError.Type.valueOf(string3.toUpperCase());
                return new XMPPError(Integer.parseInt(string2), (XMPPError.Type)var0_3, (String)var6_10, string4, arrayList);
            }
            int n3 = object.next();
            if (n3 == 2) {
                if (object.getName().equals("text")) {
                    string4 = object.nextText();
                    continue;
                }
                String string5 = object.getName();
                String string6 = object.getNamespace();
                if ("urn:ietf:params:xml:ns:xmpp-stanzas".equals(string6)) {
                    String string7 = string5;
                    continue;
                }
                arrayList.add(PacketParserUtils.parsePacketExtension(string5, string6, object));
                continue;
            }
            if (n3 != 3 || !object.getName().equals("error")) continue;
            n2 = 1;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            XMPPError.Type type4 = type;
            return new XMPPError(Integer.parseInt(string2), (XMPPError.Type)var0_3, (String)var6_10, string4, arrayList);
        }
    }

    public static IQ parseIQ(XmlPullParser object, Connection connection) throws Exception {
        XMPPError xMPPError;
        IQ.Type type;
        String string2;
        String string3;
        String string4;
        block10: {
            IQ iQ = null;
            string4 = object.getAttributeValue("", "id");
            string3 = object.getAttributeValue("", "to");
            string2 = object.getAttributeValue("", "from");
            type = IQ.Type.fromString(object.getAttributeValue("", "type"));
            xMPPError = null;
            boolean bl = false;
            while (true) {
                if (bl) {
                    object = iQ;
                    if (iQ == null) {
                        if (IQ.Type.GET != type && IQ.Type.SET != type) break;
                        object = new IQ(){

                            @Override
                            public String getChildElementXML() {
                                return null;
                            }
                        };
                        ((Packet)object).setPacketID(string4);
                        ((Packet)object).setTo(string2);
                        ((Packet)object).setFrom(string3);
                        ((IQ)object).setType(IQ.Type.ERROR);
                        ((Packet)object).setError(new XMPPError(XMPPError.Condition.feature_not_implemented));
                        connection.sendPacket((Packet)object);
                        return null;
                    }
                    break block10;
                }
                int n2 = object.next();
                if (n2 == 2) {
                    String string5 = object.getName();
                    Object object2 = object.getNamespace();
                    if (string5.equals("error")) {
                        xMPPError = PacketParserUtils.parseError((XmlPullParser)object);
                        continue;
                    }
                    if (string5.equals("query") && ((String)object2).equals("jabber:iq:auth")) {
                        iQ = PacketParserUtils.parseAuthentication((XmlPullParser)object);
                        continue;
                    }
                    if (string5.equals("query") && ((String)object2).equals("jabber:iq:roster")) {
                        iQ = PacketParserUtils.parseRoster((XmlPullParser)object);
                        continue;
                    }
                    if (string5.equals("query") && ((String)object2).equals("jabber:iq:register")) {
                        iQ = PacketParserUtils.parseRegistration((XmlPullParser)object);
                        continue;
                    }
                    if (string5.equals("bind") && ((String)object2).equals("urn:ietf:params:xml:ns:xmpp-bind")) {
                        iQ = PacketParserUtils.parseResourceBinding((XmlPullParser)object);
                        continue;
                    }
                    object2 = ProviderManager.getInstance().getIQProvider(string5, (String)object2);
                    if (object2 == null) continue;
                    if (object2 instanceof IQProvider) {
                        iQ = ((IQProvider)object2).parseIQ((XmlPullParser)object);
                        continue;
                    }
                    if (!(object2 instanceof Class)) continue;
                    iQ = (IQ)PacketParserUtils.parseWithIntrospection(string5, (Class)object2, (XmlPullParser)object);
                    continue;
                }
                if (n2 != 3 || !object.getName().equals("iq")) continue;
                bl = true;
            }
            object = new IQ(){

                @Override
                public String getChildElementXML() {
                    return null;
                }
            };
        }
        ((Packet)object).setPacketID(string4);
        ((Packet)object).setTo(string3);
        ((Packet)object).setFrom(string2);
        ((IQ)object).setType(type);
        ((Packet)object).setError(xMPPError);
        return object;
    }

    public static Collection<String> parseMechanisms(XmlPullParser xmlPullParser) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        while (!bl) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                if (!xmlPullParser.getName().equals("mechanism")) continue;
                arrayList.add(xmlPullParser.nextText());
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("mechanisms")) continue;
            bl = true;
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Packet parseMessage(XmlPullParser object) throws Exception {
        Message message = new Message();
        Object object2 = object.getAttributeValue("", "id");
        String string2 = object2;
        if (object2 == null) {
            string2 = "ID_NOT_AVAILABLE";
        }
        message.setPacketID(string2);
        message.setTo(object.getAttributeValue("", "to"));
        message.setFrom(object.getAttributeValue("", "from"));
        message.setType(Message.Type.fromString(object.getAttributeValue("", "type")));
        string2 = PacketParserUtils.getLanguageAttribute((XmlPullParser)object);
        if (string2 != null && !"".equals(string2.trim())) {
            message.setLanguage(string2);
        } else {
            string2 = Packet.getDefaultLanguage();
        }
        boolean bl = false;
        String string3 = null;
        object2 = null;
        while (true) {
            if (bl) {
                message.setThread(string3);
                if (object2 == null) return message;
                break;
            }
            int n2 = object.next();
            if (n2 == 2) {
                String string4 = object.getName();
                String string5 = object.getNamespace();
                if (string4.equals("subject")) {
                    string4 = string5 = PacketParserUtils.getLanguageAttribute((XmlPullParser)object);
                    if (string5 == null) {
                        string4 = string2;
                    }
                    string5 = PacketParserUtils.parseContent((XmlPullParser)object);
                    if (message.getSubject(string4) != null) continue;
                    message.addSubject(string4, string5);
                    continue;
                }
                if (string4.equals("body")) {
                    string4 = string5 = PacketParserUtils.getLanguageAttribute((XmlPullParser)object);
                    if (string5 == null) {
                        string4 = string2;
                    }
                    string5 = PacketParserUtils.parseContent((XmlPullParser)object);
                    if (message.getBody(string4) != null) continue;
                    message.addBody(string4, string5);
                    continue;
                }
                if (string4.equals("thread")) {
                    if (string3 != null) continue;
                    string3 = object.nextText();
                    continue;
                }
                if (string4.equals("error")) {
                    message.setError(PacketParserUtils.parseError((XmlPullParser)object));
                    continue;
                }
                if (string4.equals("properties") && string5.equals(PROPERTIES_NAMESPACE)) {
                    object2 = PacketParserUtils.parseProperties((XmlPullParser)object);
                    continue;
                }
                message.addExtension(PacketParserUtils.parsePacketExtension(string4, string5, (XmlPullParser)object));
                continue;
            }
            if (n2 != 3 || !object.getName().equals("message")) continue;
            bl = true;
        }
        object = object2.keySet().iterator();
        while (object.hasNext()) {
            string2 = (String)object.next();
            message.setProperty(string2, object2.get(string2));
        }
        return message;
    }

    public static PacketExtension parsePacketExtension(String string2, String object, XmlPullParser xmlPullParser) throws Exception {
        Object object2 = ProviderManager.getInstance().getExtensionProvider(string2, (String)object);
        if (object2 != null) {
            if (object2 instanceof PacketExtensionProvider) {
                return ((PacketExtensionProvider)object2).parseExtension(xmlPullParser);
            }
            if (object2 instanceof Class) {
                return (PacketExtension)PacketParserUtils.parseWithIntrospection(string2, (Class)object2, xmlPullParser);
            }
        }
        object = new DefaultPacketExtension(string2, (String)object);
        boolean bl = false;
        while (!bl) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                object2 = xmlPullParser.getName();
                if (xmlPullParser.isEmptyElementTag()) {
                    ((DefaultPacketExtension)object).setValue((String)object2, "");
                    continue;
                }
                if (xmlPullParser.next() != 4) continue;
                ((DefaultPacketExtension)object).setValue((String)object2, xmlPullParser.getText());
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals(string2)) continue;
            bl = true;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Presence parsePresence(XmlPullParser xmlPullParser) throws Exception {
        Object object = Presence.Type.available;
        Object object2 = xmlPullParser.getAttributeValue("", "type");
        Object object3 = object;
        if (object2 != null) {
            object3 = object;
            if (!((String)object2).equals("")) {
                try {
                    object3 = Presence.Type.valueOf((String)object2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Found invalid presence type " + (String)object2);
                    object3 = object;
                }
            }
        }
        object2 = new Presence((Presence.Type)((Object)object3));
        ((Packet)object2).setTo(xmlPullParser.getAttributeValue("", "to"));
        ((Packet)object2).setFrom(xmlPullParser.getAttributeValue("", "from"));
        object3 = xmlPullParser.getAttributeValue("", "id");
        object = object3 == null ? "ID_NOT_AVAILABLE" : object3;
        ((Packet)object2).setPacketID((String)object);
        object = PacketParserUtils.getLanguageAttribute(xmlPullParser);
        if (object != null && !"".equals(((String)object).trim())) {
            ((Presence)object2).setLanguage((String)object);
        }
        object = object3;
        if (object3 == null) {
            object = "ID_NOT_AVAILABLE";
        }
        ((Packet)object2).setPacketID((String)object);
        boolean bl = false;
        block7: while (!bl) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                object3 = xmlPullParser.getName();
                object = xmlPullParser.getNamespace();
                if (((String)object3).equals("status")) {
                    ((Presence)object2).setStatus(xmlPullParser.nextText());
                    continue;
                }
                if (((String)object3).equals("priority")) {
                    try {
                        ((Presence)object2).setPriority(Integer.parseInt(xmlPullParser.nextText()));
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        ((Presence)object2).setPriority(0);
                    }
                    continue;
                }
                if (((String)object3).equals("show")) {
                    object3 = xmlPullParser.nextText();
                    try {
                        ((Presence)object2).setMode(Presence.Mode.valueOf((String)object3));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        System.err.println("Found invalid presence mode " + (String)object3);
                    }
                    continue;
                }
                if (((String)object3).equals("error")) {
                    ((Packet)object2).setError(PacketParserUtils.parseError(xmlPullParser));
                    continue;
                }
                if (((String)object3).equals("properties") && ((String)object).equals(PROPERTIES_NAMESPACE)) {
                    object3 = PacketParserUtils.parseProperties(xmlPullParser);
                    object = object3.keySet().iterator();
                    while (true) {
                        if (!object.hasNext()) continue block7;
                        String string2 = (String)object.next();
                        ((Packet)object2).setProperty(string2, object3.get(string2));
                    }
                }
                ((Packet)object2).addExtension(PacketParserUtils.parsePacketExtension((String)object3, (String)object, xmlPullParser));
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("presence")) continue;
            bl = true;
        }
        return object2;
    }

    /*
     * Unable to fully structure code
     */
    public static Map<String, Object> parseProperties(XmlPullParser var0) throws Exception {
        var8_1 = new HashMap<String, Object>();
        block2: while (true) {
            block8: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    if ((var1_2 = var0.next()) != 2 || !var0.getName().equals("property")) break block8;
                                    var1_2 = 0;
                                    var6_8 = null;
                                    var5_7 = null;
                                    var4_6 = null;
                                    var7_9 = null;
                                    block3: while (true) {
                                        if (var1_2 != 0) continue block2;
                                        var2_3 = var0.next();
                                        if (var2_3 == 2) {
                                            var3_4 = var0.getName();
                                            if (var3_4.equals("name")) {
                                                var6_8 = var0.nextText();
                                                continue;
                                            }
                                            if (!var3_4.equals("value")) continue;
                                            var5_7 = var0.getAttributeValue("", "type");
                                            var4_6 = var0.nextText();
                                            continue;
                                        }
                                        if (var2_3 != 3 || !var0.getName().equals("property")) continue;
                                        if (!"integer".equals(var5_7)) break;
                                        var3_4 = Integer.valueOf(var4_6);
lbl24:
                                        // 8 sources

                                        while (true) {
                                            if (var6_8 != null && var3_4 != null) {
                                                var8_1.put(var6_8, var3_4);
                                            }
                                            var1_2 = 1;
                                            var7_9 = var3_4;
                                            continue block3;
                                            break;
                                        }
                                        break;
                                    }
                                    if (!"long".equals(var5_7)) break block9;
                                    var3_4 = Long.valueOf(var4_6);
                                    ** GOTO lbl24
                                }
                                if (!"float".equals(var5_7)) break block10;
                                var3_4 = Float.valueOf(var4_6);
                                ** GOTO lbl24
                            }
                            if (!"double".equals(var5_7)) break block11;
                            var3_4 = Double.valueOf(var4_6);
                            ** GOTO lbl24
                        }
                        if (!"boolean".equals(var5_7)) break block12;
                        var3_4 = Boolean.valueOf(var4_6);
                        ** GOTO lbl24
                    }
                    if (!"string".equals(var5_7)) break block13;
                    var3_4 = var4_6;
                    ** GOTO lbl24
                }
                var3_4 = var7_9;
                if (!"java-object".equals(var5_7)) ** GOTO lbl24
                try {
                    var3_4 = new ObjectInputStream(new ByteArrayInputStream(StringUtils.decodeBase64(var4_6))).readObject();
                }
                catch (Exception var3_5) {
                    var3_5.printStackTrace();
                    var3_4 = var7_9;
                }
                ** continue;
            }
            if (var1_2 == 3 && var0.getName().equals("properties")) break;
        }
        return var8_1;
    }

    private static Registration parseRegistration(XmlPullParser xmlPullParser) throws Exception {
        Registration registration = new Registration();
        boolean bl = false;
        while (!bl) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                if (xmlPullParser.getNamespace().equals("jabber:iq:register")) {
                    String string2 = xmlPullParser.getName();
                    if (xmlPullParser.next() == 4) {
                        String string3 = xmlPullParser.getText();
                        if (string2.equals("instructions")) {
                            registration.setInstructions(string3);
                            continue;
                        }
                        registration.addAttribute(string2, string3);
                        continue;
                    }
                    if (string2.equals("registered")) {
                        registration.setRegistered(true);
                        continue;
                    }
                    registration.addRequiredField(string2);
                    continue;
                }
                registration.addExtension(PacketParserUtils.parsePacketExtension(xmlPullParser.getName(), xmlPullParser.getNamespace(), xmlPullParser));
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        return registration;
    }

    private static Bind parseResourceBinding(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        Bind bind = new Bind();
        boolean bl = false;
        while (!bl) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                if (xmlPullParser.getName().equals("resource")) {
                    bind.setResource(xmlPullParser.nextText());
                    continue;
                }
                if (!xmlPullParser.getName().equals("jid")) continue;
                bind.setJid(xmlPullParser.nextText());
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("bind")) continue;
            bl = true;
        }
        return bind;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static RosterPacket parseRoster(XmlPullParser xmlPullParser) throws Exception {
        RosterPacket rosterPacket = new RosterPacket();
        boolean bl = false;
        Object object = null;
        while (!bl) {
            int n2;
            if (xmlPullParser.getEventType() == 2 && xmlPullParser.getName().equals("query")) {
                rosterPacket.setVersion(xmlPullParser.getAttributeValue(null, "ver"));
            }
            if ((n2 = xmlPullParser.next()) == 2) {
                RosterPacket.Item item = object;
                if (xmlPullParser.getName().equals("item")) {
                    item = new RosterPacket.Item(xmlPullParser.getAttributeValue("", "jid"), xmlPullParser.getAttributeValue("", "name"));
                    item.setItemStatus(RosterPacket.ItemStatus.fromString(xmlPullParser.getAttributeValue("", "ask")));
                    object = xmlPullParser.getAttributeValue("", "subscription");
                    if (object == null) {
                        object = "none";
                    }
                    item.setItemType(RosterPacket.ItemType.valueOf((String)object));
                }
                object = item;
                if (!xmlPullParser.getName().equals("group")) continue;
                object = item;
                if (item == null) continue;
                String string2 = xmlPullParser.nextText();
                object = item;
                if (string2 == null) continue;
                object = item;
                if (string2.trim().length() <= 0) continue;
                item.addGroupName(string2);
                object = item;
                continue;
            }
            if (n2 != 3) continue;
            if (xmlPullParser.getName().equals("item")) {
                rosterPacket.addRosterItem((RosterPacket.Item)object);
            }
            if (!xmlPullParser.getName().equals("query")) continue;
            bl = true;
        }
        return rosterPacket;
    }

    public static SASLMechanism.Failure parseSASLFailure(XmlPullParser xmlPullParser) throws Exception {
        String string2 = null;
        boolean bl = false;
        while (!bl) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                if (xmlPullParser.getName().equals("failure")) continue;
                string2 = xmlPullParser.getName();
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("failure")) continue;
            bl = true;
        }
        return new SASLMechanism.Failure(string2);
    }

    public static StreamError parseStreamError(XmlPullParser xmlPullParser) throws IOException, XmlPullParserException {
        StreamError streamError = null;
        boolean bl = false;
        while (!bl) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                streamError = new StreamError(xmlPullParser.getName());
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals("error")) continue;
            bl = true;
        }
        return streamError;
    }

    public static Object parseWithIntrospection(String string2, Class clazz, XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        clazz = clazz.newInstance();
        while (!bl) {
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                String string3 = xmlPullParser.getName();
                Object object = xmlPullParser.nextText();
                Class<?> clazz2 = clazz.getClass().getMethod("get" + Character.toUpperCase(string3.charAt(0)) + string3.substring(1), new Class[0]).getReturnType();
                object = PacketParserUtils.decode(clazz2, (String)object);
                clazz.getClass().getMethod("set" + Character.toUpperCase(string3.charAt(0)) + string3.substring(1), clazz2).invoke(clazz, object);
                continue;
            }
            if (n2 != 3 || !xmlPullParser.getName().equals(string2)) continue;
            bl = true;
        }
        return clazz;
    }
}

