/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.util.WriterListener;

public class ObservableWriter
extends Writer {
    List listeners = new ArrayList();
    Writer wrappedWriter = null;

    public ObservableWriter(Writer writer) {
        this.wrappedWriter = writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifyListeners(String string2) {
        WriterListener[] writerListenerArray;
        Object object = null;
        object = this.listeners;
        synchronized (object) {
            writerListenerArray = new WriterListener[this.listeners.size()];
            this.listeners.toArray(writerListenerArray);
        }
        int n2 = 0;
        while (n2 < writerListenerArray.length) {
            writerListenerArray[n2].write(string2);
            ++n2;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addWriterListener(WriterListener writerListener) {
        if (writerListener == null) {
            return;
        }
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(writerListener)) {
                this.listeners.add(writerListener);
            }
            return;
        }
    }

    @Override
    public void close() throws IOException {
        this.wrappedWriter.close();
    }

    @Override
    public void flush() throws IOException {
        this.wrappedWriter.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeWriterListener(WriterListener writerListener) {
        List list = this.listeners;
        synchronized (list) {
            this.listeners.remove(writerListener);
            return;
        }
    }

    @Override
    public void write(int n2) throws IOException {
        this.wrappedWriter.write(n2);
    }

    @Override
    public void write(String string2) throws IOException {
        this.wrappedWriter.write(string2);
        this.notifyListeners(string2);
    }

    @Override
    public void write(String string2, int n2, int n3) throws IOException {
        this.wrappedWriter.write(string2, n2, n3);
        this.notifyListeners(string2.substring(n2, n2 + n3));
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.wrappedWriter.write(cArray);
        this.notifyListeners(new String(cArray));
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.wrappedWriter.write(cArray, n2, n3);
        this.notifyListeners(new String(cArray, n2, n3));
    }
}

