/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jivesoftware.smack.util.collections.AbstractMapEntry;

public class Cache<K, V>
implements Map<K, V> {
    protected LinkedList ageList;
    protected long cacheHits;
    protected long cacheMisses = 0L;
    protected LinkedList lastAccessedList;
    protected Map<K, CacheObject<V>> map;
    protected int maxCacheSize;
    protected long maxLifetime;

    public Cache(int n2, long l2) {
        if (n2 == 0) {
            throw new IllegalArgumentException("Max cache size cannot be 0.");
        }
        this.maxCacheSize = n2;
        this.maxLifetime = l2;
        this.map = new HashMap<K, CacheObject<V>>(103);
        this.lastAccessedList = new LinkedList();
        this.ageList = new LinkedList();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void clear() {
        synchronized (this) {
            Object[] objectArray = this.map.keySet().toArray();
            int n2 = objectArray.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    this.map.clear();
                    this.lastAccessedList.clear();
                    this.ageList.clear();
                    this.cacheHits = 0L;
                    this.cacheMisses = 0L;
                    return;
                }
                this.remove(objectArray[n3]);
                ++n3;
            }
        }
    }

    @Override
    public boolean containsKey(Object object) {
        synchronized (this) {
            this.deleteExpiredEntries();
            boolean bl = this.map.containsKey(object);
            return bl;
        }
    }

    @Override
    public boolean containsValue(Object cacheObject) {
        synchronized (this) {
            this.deleteExpiredEntries();
            cacheObject = new CacheObject<Object>(cacheObject);
            boolean bl = this.map.containsValue(cacheObject);
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void cullCache() {
        synchronized (this) {
            int n2 = this.maxCacheSize;
            if (n2 >= 0 && this.map.size() > this.maxCacheSize) {
                this.deleteExpiredEntries();
                int n3 = (int)((double)this.maxCacheSize * 0.9);
                for (n2 = this.map.size(); n2 > n3; --n2) {
                    if (this.remove(this.lastAccessedList.getLast().object, true) != null) continue;
                    System.err.println("Error attempting to cullCache with remove(" + this.lastAccessedList.getLast().object.toString() + ") - " + "cacheObject not found in cache!");
                    this.lastAccessedList.getLast().remove();
                }
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void deleteExpiredEntries() {
        synchronized (this) {
            LinkedListNode linkedListNode;
            long l2 = this.maxLifetime;
            if (l2 > 0L && (linkedListNode = this.ageList.getLast()) != null) {
                l2 = System.currentTimeMillis();
                long l3 = this.maxLifetime;
                while (l2 - l3 > linkedListNode.timestamp) {
                    LinkedListNode linkedListNode2;
                    if (this.remove(linkedListNode.object, true) == null) {
                        System.err.println("Error attempting to remove(" + linkedListNode.object.toString() + ") - cacheObject not found in cache!");
                        linkedListNode.remove();
                    }
                    linkedListNode = linkedListNode2 = this.ageList.getLast();
                    if (linkedListNode2 != null) continue;
                }
            }
            return;
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        synchronized (this) {
            this.deleteExpiredEntries();
            AbstractSet abstractSet = new AbstractSet<Map.Entry<K, V>>(){
                private final Set<Map.Entry<K, CacheObject<V>>> set;
                {
                    this.set = Cache.this.map.entrySet();
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new Iterator<Map.Entry<K, V>>(){
                        private final Iterator<Map.Entry<K, CacheObject<V>>> it;
                        {
                            this.it = set.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public Map.Entry<K, V> next() {
                            Map.Entry entry = this.it.next();
                            return new AbstractMapEntry<K, V>(entry.getKey(), entry.getValue().object){

                                @Override
                                public V setValue(V v2) {
                                    throw new UnsupportedOperationException("Cannot set");
                                }
                            };
                        }

                        @Override
                        public void remove() {
                            this.it.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return this.set.size();
                }
            };
            return abstractSet;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public V get(Object cacheObject) {
        synchronized (this) {
            void var1_4;
            CacheObject<V> cacheObject2;
            block7: {
                this.deleteExpiredEntries();
                cacheObject2 = this.map.get(cacheObject);
                if (cacheObject2 != null) break block7;
                ++this.cacheMisses;
                return var1_4;
            }
            cacheObject2.lastAccessedListNode.remove();
            this.lastAccessedList.addFirst(cacheObject2.lastAccessedListNode);
            ++this.cacheHits;
            ++cacheObject2.readCount;
            Object v2 = cacheObject2.object;
            return var1_4;
        }
    }

    public long getCacheHits() {
        return this.cacheHits;
    }

    public long getCacheMisses() {
        return this.cacheMisses;
    }

    public int getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public long getMaxLifetime() {
        return this.maxLifetime;
    }

    @Override
    public boolean isEmpty() {
        synchronized (this) {
            this.deleteExpiredEntries();
            boolean bl = this.map.isEmpty();
            return bl;
        }
    }

    @Override
    public Set<K> keySet() {
        synchronized (this) {
            this.deleteExpiredEntries();
            Set<K> set = Collections.unmodifiableSet(this.map.keySet());
            return set;
        }
    }

    @Override
    public V put(K object, V object2) {
        synchronized (this) {
            V v2 = null;
            if (this.map.containsKey(object)) {
                v2 = this.remove(object, true);
            }
            object2 = new CacheObject<V>(object2);
            this.map.put(object, (CacheObject<V>)object2);
            ((CacheObject)object2).lastAccessedListNode = this.lastAccessedList.addFirst(object);
            object = this.ageList.addFirst(object);
            ((LinkedListNode)object).timestamp = System.currentTimeMillis();
            ((CacheObject)object2).ageListNode = object;
            this.cullCache();
            return v2;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            V v2 = entry.getValue();
            map = v2;
            if (v2 instanceof CacheObject) {
                map = ((CacheObject)v2).object;
            }
            this.put(entry.getKey(), map);
        }
        return;
    }

    @Override
    public V remove(Object object) {
        synchronized (this) {
            object = this.remove(object, false);
            return (V)object;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public V remove(Object cacheObject, boolean bl) {
        Object var3_9 = null;
        synchronized (this) {
            void var1_4;
            CacheObject<V> cacheObject2;
            block6: {
                cacheObject2 = this.map.remove(cacheObject);
                if (cacheObject2 != null) break block6;
                Object var1_3 = var3_9;
                return var1_4;
            }
            cacheObject2.lastAccessedListNode.remove();
            cacheObject2.ageListNode.remove();
            cacheObject2.ageListNode = null;
            cacheObject2.lastAccessedListNode = null;
            Object v2 = cacheObject2.object;
            return var1_4;
        }
    }

    public void setMaxCacheSize(int n2) {
        synchronized (this) {
            this.maxCacheSize = n2;
            this.cullCache();
            return;
        }
    }

    public void setMaxLifetime(long l2) {
        this.maxLifetime = l2;
    }

    @Override
    public int size() {
        synchronized (this) {
            this.deleteExpiredEntries();
            int n2 = this.map.size();
            return n2;
        }
    }

    @Override
    public Collection<V> values() {
        synchronized (this) {
            this.deleteExpiredEntries();
            Collection collection = Collections.unmodifiableCollection(new AbstractCollection<V>(){
                Collection<CacheObject<V>> values;
                {
                    this.values = Cache.this.map.values();
                }

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        Iterator<CacheObject<V>> it;
                        {
                            this.it = values.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.it.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.it.next().object;
                        }

                        @Override
                        public void remove() {
                            this.it.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return this.values.size();
                }
            });
            return collection;
        }
    }

    private static class CacheObject<V> {
        public LinkedListNode ageListNode;
        public LinkedListNode lastAccessedListNode;
        public V object;
        public int readCount = 0;

        public CacheObject(V v2) {
            this.object = v2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CacheObject)) {
                return false;
            }
            object = (CacheObject)object;
            return this.object.equals(((CacheObject)object).object);
        }

        public int hashCode() {
            return this.object.hashCode();
        }
    }

    private static class LinkedList {
        private LinkedListNode head;

        public LinkedList() {
            LinkedListNode linkedListNode;
            LinkedListNode linkedListNode2 = this.head = new LinkedListNode("head", null, null);
            LinkedListNode linkedListNode3 = this.head;
            linkedListNode3.previous = linkedListNode = this.head;
            linkedListNode2.next = linkedListNode;
        }

        public LinkedListNode addFirst(Object object) {
            ((LinkedListNode)object).previous.next = object = new LinkedListNode(object, this.head.next, this.head);
            ((LinkedListNode)object).next.previous = object;
            return object;
        }

        public LinkedListNode addFirst(LinkedListNode linkedListNode) {
            linkedListNode.next = this.head.next;
            linkedListNode.previous = this.head;
            linkedListNode.previous.next = linkedListNode;
            linkedListNode.next.previous = linkedListNode;
            return linkedListNode;
        }

        public LinkedListNode addLast(Object object) {
            ((LinkedListNode)object).previous.next = object = new LinkedListNode(object, this.head, this.head.previous);
            ((LinkedListNode)object).next.previous = object;
            return object;
        }

        public void clear() {
            LinkedListNode linkedListNode = this.getLast();
            while (true) {
                if (linkedListNode == null) {
                    LinkedListNode linkedListNode2;
                    linkedListNode = this.head;
                    LinkedListNode linkedListNode3 = this.head;
                    linkedListNode3.previous = linkedListNode2 = this.head;
                    linkedListNode.next = linkedListNode2;
                    return;
                }
                linkedListNode.remove();
                linkedListNode = this.getLast();
            }
        }

        public LinkedListNode getFirst() {
            LinkedListNode linkedListNode;
            LinkedListNode linkedListNode2 = linkedListNode = this.head.next;
            if (linkedListNode == this.head) {
                linkedListNode2 = null;
            }
            return linkedListNode2;
        }

        public LinkedListNode getLast() {
            LinkedListNode linkedListNode;
            LinkedListNode linkedListNode2 = linkedListNode = this.head.previous;
            if (linkedListNode == this.head) {
                linkedListNode2 = null;
            }
            return linkedListNode2;
        }

        public String toString() {
            LinkedListNode linkedListNode = this.head.next;
            StringBuilder stringBuilder = new StringBuilder();
            while (linkedListNode != this.head) {
                stringBuilder.append(linkedListNode.toString()).append(", ");
                linkedListNode = linkedListNode.next;
            }
            return stringBuilder.toString();
        }
    }

    private static class LinkedListNode {
        public LinkedListNode next;
        public Object object;
        public LinkedListNode previous;
        public long timestamp;

        public LinkedListNode(Object object, LinkedListNode linkedListNode, LinkedListNode linkedListNode2) {
            this.object = object;
            this.next = linkedListNode;
            this.previous = linkedListNode2;
        }

        public void remove() {
            this.previous.next = this.next;
            this.next.previous = this.previous;
        }

        public String toString() {
            return this.object.toString();
        }
    }
}

