/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.sasl;

import de.measite.smack.Sasl;
import java.io.IOException;
import java.util.HashMap;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.NameCallback;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.apache.harmony.javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.harmony.javax.security.sasl.RealmCallback;
import org.apache.harmony.javax.security.sasl.RealmChoiceCallback;
import org.apache.harmony.javax.security.sasl.SaslClient;
import org.apache.harmony.javax.security.sasl.SaslException;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.Base64;

public abstract class SASLMechanism
implements CallbackHandler {
    protected String authenticationId;
    protected String hostname;
    protected String password;
    private SASLAuthentication saslAuthentication;
    protected SaslClient sc;

    public SASLMechanism(SASLAuthentication sASLAuthentication) {
        this.saslAuthentication = sASLAuthentication;
    }

    protected void authenticate() throws IOException, XMPPException {
        String string2 = null;
        try {
            if (this.sc.hasInitialResponse()) {
                string2 = Base64.encodeBytes(this.sc.evaluateChallenge(new byte[0]), 8);
            }
            this.getSASLAuthentication().send(new AuthMechanism(this.getName(), string2));
            return;
        }
        catch (SaslException saslException) {
            throw new XMPPException("SASL authentication failed", saslException);
        }
    }

    public void authenticate(String string2, String string3, String string4) throws IOException, XMPPException {
        this.authenticationId = string2;
        this.password = string4;
        this.hostname = string3;
        string4 = this.getName();
        HashMap hashMap = new HashMap();
        this.sc = Sasl.createSaslClient(new String[]{string4}, string2, "xmpp", string3, hashMap, this);
        this.authenticate();
    }

    public void authenticate(String string2, String string3, CallbackHandler callbackHandler) throws IOException, XMPPException {
        String string4 = this.getName();
        HashMap hashMap = new HashMap();
        this.sc = Sasl.createSaslClient(new String[]{string4}, string2, "xmpp", string3, hashMap, callbackHandler);
        this.authenticate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void challengeReceived(String object) throws IOException {
        object = object != null ? (Object)this.sc.evaluateChallenge(Base64.decode((String)object)) : (Object)this.sc.evaluateChallenge(new byte[0]);
        object = object == null ? new Response() : new Response(Base64.encodeBytes((byte[])object, 8));
        this.getSASLAuthentication().send((Packet)object);
    }

    protected abstract String getName();

    protected SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        int n2 = 0;
        while (n2 < callbackArray.length) {
            if (callbackArray[n2] instanceof NameCallback) {
                ((NameCallback)callbackArray[n2]).setName(this.authenticationId);
            } else if (callbackArray[n2] instanceof PasswordCallback) {
                ((PasswordCallback)callbackArray[n2]).setPassword(this.password.toCharArray());
            } else if (callbackArray[n2] instanceof RealmCallback) {
                ((RealmCallback)callbackArray[n2]).setText(this.hostname);
            } else if (!(callbackArray[n2] instanceof RealmChoiceCallback)) {
                throw new UnsupportedCallbackException(callbackArray[n2]);
            }
            ++n2;
        }
        return;
    }

    public class AuthMechanism
    extends Packet {
        private final String authenticationText;
        private final String name;

        public AuthMechanism(String string2, String string3) {
            if (string2 == null) {
                throw new NullPointerException("SASL mechanism name shouldn't be null.");
            }
            this.name = string2;
            this.authenticationText = string3;
        }

        @Override
        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<auth mechanism=\"").append(this.name);
            stringBuilder.append("\" xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.authenticationText != null && this.authenticationText.trim().length() > 0) {
                stringBuilder.append(this.authenticationText);
            }
            stringBuilder.append("</auth>");
            return stringBuilder.toString();
        }
    }

    public static class Challenge
    extends Packet {
        private final String data;

        public Challenge(String string2) {
            this.data = string2;
        }

        @Override
        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<challenge xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.data != null && this.data.trim().length() > 0) {
                stringBuilder.append(this.data);
            }
            stringBuilder.append("</challenge>");
            return stringBuilder.toString();
        }
    }

    public static class Failure
    extends Packet {
        private final String condition;

        public Failure(String string2) {
            this.condition = string2;
        }

        public String getCondition() {
            return this.condition;
        }

        @Override
        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<failure xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.condition != null && this.condition.trim().length() > 0) {
                stringBuilder.append("<").append(this.condition).append("/>");
            }
            stringBuilder.append("</failure>");
            return stringBuilder.toString();
        }
    }

    public class Response
    extends Packet {
        private final String authenticationText;

        public Response() {
            this.authenticationText = null;
        }

        public Response(String string2) {
            if (string2 == null || string2.trim().length() == 0) {
                this.authenticationText = null;
                return;
            }
            this.authenticationText = string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<response xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.authenticationText != null) {
                stringBuilder.append(this.authenticationText);
            } else {
                stringBuilder.append("=");
            }
            stringBuilder.append("</response>");
            return stringBuilder.toString();
        }
    }

    public static class Success
    extends Packet {
        private final String data;

        public Success(String string2) {
            this.data = string2;
        }

        @Override
        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<success xmlns=\"urn:ietf:params:xml:ns:xmpp-sasl\">");
            if (this.data != null && this.data.trim().length() > 0) {
                stringBuilder.append(this.data);
            }
            stringBuilder.append("</success>");
            return stringBuilder.toString();
        }
    }
}

