/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import javax.net.SocketFactory;
import org.jivesoftware.smack.proxy.DirectSocketFactory;
import org.jivesoftware.smack.proxy.HTTPProxySocketFactory;
import org.jivesoftware.smack.proxy.Socks4ProxySocketFactory;
import org.jivesoftware.smack.proxy.Socks5ProxySocketFactory;

public class ProxyInfo {
    private String proxyAddress;
    private String proxyPassword;
    private int proxyPort;
    private ProxyType proxyType;
    private String proxyUsername;

    public ProxyInfo(ProxyType proxyType, String string2, int n2, String string3, String string4) {
        this.proxyType = proxyType;
        this.proxyAddress = string2;
        this.proxyPort = n2;
        this.proxyUsername = string3;
        this.proxyPassword = string4;
    }

    public static ProxyInfo forDefaultProxy() {
        return new ProxyInfo(ProxyType.NONE, null, 0, null, null);
    }

    public static ProxyInfo forHttpProxy(String string2, int n2, String string3, String string4) {
        return new ProxyInfo(ProxyType.HTTP, string2, n2, string3, string4);
    }

    public static ProxyInfo forNoProxy() {
        return new ProxyInfo(ProxyType.NONE, null, 0, null, null);
    }

    public static ProxyInfo forSocks4Proxy(String string2, int n2, String string3, String string4) {
        return new ProxyInfo(ProxyType.SOCKS4, string2, n2, string3, string4);
    }

    public static ProxyInfo forSocks5Proxy(String string2, int n2, String string3, String string4) {
        return new ProxyInfo(ProxyType.SOCKS5, string2, n2, string3, string4);
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public SocketFactory getSocketFactory() {
        if (this.proxyType == ProxyType.NONE) {
            return new DirectSocketFactory();
        }
        if (this.proxyType == ProxyType.HTTP) {
            return new HTTPProxySocketFactory(this);
        }
        if (this.proxyType == ProxyType.SOCKS4) {
            return new Socks4ProxySocketFactory(this);
        }
        if (this.proxyType == ProxyType.SOCKS5) {
            return new Socks5ProxySocketFactory(this);
        }
        return null;
    }

    public static enum ProxyType {
        NONE,
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

