/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.SocketFactory;
import org.jivesoftware.smack.proxy.ProxyException;
import org.jivesoftware.smack.proxy.ProxyInfo;
import org.jivesoftware.smack.util.Base64;

class HTTPProxySocketFactory
extends SocketFactory {
    private static final Pattern RESPONSE_PATTERN = Pattern.compile("HTTP/\\S+\\s(\\d+)\\s(.*)\\s*");
    private ProxyInfo proxy;

    public HTTPProxySocketFactory(ProxyInfo proxyInfo) {
        this.proxy = proxyInfo;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Socket httpProxifiedSocket(String object, int n2) throws IOException {
        String string2 = this.proxy.getProxyAddress();
        Socket socket = new Socket(string2, this.proxy.getProxyPort());
        Object object2 = "CONNECT " + (String)object + ":" + n2;
        object = this.proxy.getProxyUsername();
        if (object == null) {
            object = "";
        } else {
            String string3 = this.proxy.getProxyPassword();
            object = "\r\nProxy-Authorization: Basic " + new String(Base64.encodeBytes((String.valueOf(object) + ":" + string3).getBytes("UTF-8")));
        }
        socket.getOutputStream().write((String.valueOf(object2) + " HTTP/1.1\r\nHost: " + (String)object2 + (String)object + "\r\n\r\n").getBytes("UTF-8"));
        object = socket.getInputStream();
        object2 = new StringBuilder(100);
        int n3 = 0;
        do {
            char c2 = (char)((InputStream)object).read();
            ((StringBuilder)object2).append(c2);
            if (((StringBuilder)object2).length() > 1024) {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Recieved header of >1024 characters from " + string2 + ", cancelling connection");
            }
            if (c2 == '\uffffffff') {
                throw new ProxyException(ProxyInfo.ProxyType.HTTP);
            }
            n2 = (n3 == 0 || n3 == 2) && c2 == '\r' ? n3 + 1 : ((n3 == 1 || n3 == 3) && c2 == '\n' ? n3 + 1 : 0);
            n3 = n2;
        } while (n2 != 4);
        if (n2 != 4) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Never received blank line from " + string2 + ", cancelling connection");
        }
        object = new BufferedReader(new StringReader(((StringBuilder)object2).toString())).readLine();
        if (object == null) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Empty proxy response from " + string2 + ", cancelling");
        }
        object2 = RESPONSE_PATTERN.matcher((CharSequence)object);
        if (!((Matcher)object2).matches()) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP, "Unexpected proxy response from " + string2 + ": " + (String)object);
        }
        if (Integer.parseInt(((Matcher)object2).group(1)) != 200) {
            throw new ProxyException(ProxyInfo.ProxyType.HTTP);
        }
        return socket;
    }

    @Override
    public Socket createSocket(String string2, int n2) throws IOException, UnknownHostException {
        return this.httpProxifiedSocket(string2, n2);
    }

    @Override
    public Socket createSocket(String string2, int n2, InetAddress inetAddress, int n3) throws IOException, UnknownHostException {
        return this.httpProxifiedSocket(string2, n2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2) throws IOException {
        return this.httpProxifiedSocket(inetAddress.getHostAddress(), n2);
    }

    @Override
    public Socket createSocket(InetAddress inetAddress, int n2, InetAddress inetAddress2, int n3) throws IOException {
        return this.httpProxifiedSocket(inetAddress.getHostAddress(), n2);
    }
}

