/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.PacketExtensionProvider;

public class ProviderManager {
    private static ProviderManager instance;
    private Map<String, Object> extensionProviders = new ConcurrentHashMap<String, Object>();
    private Map<String, Object> iqProviders = new ConcurrentHashMap<String, Object>();

    private ProviderManager() {
        this.initialize();
    }

    private ClassLoader[] getClassLoaders() {
        int n2 = 0;
        ClassLoader[] classLoaderArray = new ClassLoader[]{ProviderManager.class.getClassLoader(), Thread.currentThread().getContextClassLoader()};
        ArrayList<ClassLoader> arrayList = new ArrayList<ClassLoader>();
        int n3 = classLoaderArray.length;
        while (n2 < n3) {
            ClassLoader classLoader = classLoaderArray[n2];
            if (classLoader != null) {
                arrayList.add(classLoader);
            }
            ++n2;
        }
        return arrayList.toArray(new ClassLoader[arrayList.size()]);
    }

    public static ProviderManager getInstance() {
        synchronized (ProviderManager.class) {
            if (instance == null) {
                instance = new ProviderManager();
            }
            ProviderManager providerManager = instance;
            return providerManager;
        }
    }

    private String getProviderKey(String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<").append(string2).append("/><").append(string3).append("/>");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setInstance(ProviderManager providerManager) {
        synchronized (ProviderManager.class) {
            if (instance != null) {
                throw new IllegalStateException("ProviderManager singleton already set");
            }
            instance = providerManager;
            return;
        }
    }

    public void addExtensionProvider(String string2, String string3, Object object) {
        if (!(object instanceof PacketExtensionProvider) && !(object instanceof Class)) {
            throw new IllegalArgumentException("Provider must be a PacketExtensionProvider or a Class instance.");
        }
        string2 = this.getProviderKey(string2, string3);
        this.extensionProviders.put(string2, object);
    }

    public void addIQProvider(String string2, String string3, Object object) {
        if (!(object instanceof IQProvider || object instanceof Class && IQ.class.isAssignableFrom((Class)object))) {
            throw new IllegalArgumentException("Provider must be an IQProvider or a Class instance.");
        }
        string2 = this.getProviderKey(string2, string3);
        this.iqProviders.put(string2, object);
    }

    public Object getExtensionProvider(String string2, String string3) {
        string2 = this.getProviderKey(string2, string3);
        return this.extensionProviders.get(string2);
    }

    public Collection<Object> getExtensionProviders() {
        return Collections.unmodifiableCollection(this.extensionProviders.values());
    }

    public Object getIQProvider(String string2, String string3) {
        string2 = this.getProviderKey(string2, string3);
        return this.iqProviders.get(string2);
    }

    public Collection<Object> getIQProviders() {
        return Collections.unmodifiableCollection(this.iqProviders.values());
    }

    /*
     * Exception decompiling
     */
    protected void initialize() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 30[TRYBLOCK] [36 : 439->454)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void removeExtensionProvider(String string2, String string3) {
        string2 = this.getProviderKey(string2, string3);
        this.extensionProviders.remove(string2);
    }

    public void removeIQProvider(String string2, String string3) {
        string2 = this.getProviderKey(string2, string3);
        this.iqProviders.remove(string2);
    }
}

