/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.PacketExtension;

public class XMPPError {
    private List<PacketExtension> applicationExtensions = null;
    private int code;
    private String condition;
    private String message;
    private Type type;

    public XMPPError(int n2) {
        this.code = n2;
        this.message = null;
    }

    public XMPPError(int n2, String string2) {
        this.code = n2;
        this.message = string2;
    }

    public XMPPError(int n2, Type type, String string2, String string3, List<PacketExtension> list) {
        this.code = n2;
        this.type = type;
        this.condition = string2;
        this.message = string3;
        this.applicationExtensions = list;
    }

    public XMPPError(Condition condition) {
        this.init(condition);
        this.message = null;
    }

    public XMPPError(Condition condition, String string2) {
        this.init(condition);
        this.message = string2;
    }

    private void init(Condition condition) {
        ErrorSpecification errorSpecification = ErrorSpecification.specFor(condition);
        this.condition = condition.value;
        if (errorSpecification != null) {
            this.type = errorSpecification.getType();
            this.code = errorSpecification.getCode();
        }
    }

    public void addExtension(PacketExtension packetExtension) {
        synchronized (this) {
            if (this.applicationExtensions == null) {
                this.applicationExtensions = new ArrayList<PacketExtension>();
            }
            this.applicationExtensions.add(packetExtension);
            return;
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getCondition() {
        return this.condition;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PacketExtension getExtension(String object, String string2) {
        synchronized (this) {
            boolean bl;
            void var2_2;
            Object object2 = this.applicationExtensions;
            if (object2 == null) return null;
            if (object == null) return null;
            if (var2_2 == null) {
                return null;
            }
            Iterator<PacketExtension> iterator = this.applicationExtensions.iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!((String)object).equals((object2 = iterator.next()).getElementName()) || !(bl = var2_2.equals(object2.getNamespace())));
            return object2;
        }
    }

    public List<PacketExtension> getExtensions() {
        synchronized (this) {
            List<PacketExtension> list;
            if (this.applicationExtensions == null) {
                list = Collections.emptyList();
                return list;
            }
            list = Collections.unmodifiableList(this.applicationExtensions);
        }
    }

    public String getMessage() {
        return this.message;
    }

    public Type getType() {
        return this.type;
    }

    public void setExtension(List<PacketExtension> list) {
        synchronized (this) {
            this.applicationExtensions = list;
            return;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.condition != null) {
            stringBuilder.append(this.condition);
        }
        stringBuilder.append("(").append(this.code).append(")");
        if (this.message != null) {
            stringBuilder.append(" ").append(this.message);
        }
        return stringBuilder.toString();
    }

    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<error code=\"").append(this.code).append("\"");
        if (this.type != null) {
            stringBuilder.append(" type=\"");
            stringBuilder.append(this.type.name());
            stringBuilder.append("\"");
        }
        stringBuilder.append(">");
        if (this.condition != null) {
            stringBuilder.append("<").append(this.condition);
            stringBuilder.append(" xmlns=\"urn:ietf:params:xml:ns:xmpp-stanzas\"/>");
        }
        if (this.message != null) {
            stringBuilder.append("<text xml:lang=\"en\" xmlns=\"urn:ietf:params:xml:ns:xmpp-stanzas\">");
            stringBuilder.append(this.message);
            stringBuilder.append("</text>");
        }
        Iterator<PacketExtension> iterator = this.getExtensions().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                stringBuilder.append("</error>");
                return stringBuilder.toString();
            }
            stringBuilder.append(iterator.next().toXML());
        }
    }

    public static class Condition {
        public static final Condition bad_request;
        public static final Condition conflict;
        public static final Condition feature_not_implemented;
        public static final Condition forbidden;
        public static final Condition gone;
        public static final Condition interna_server_error;
        public static final Condition item_not_found;
        public static final Condition jid_malformed;
        public static final Condition no_acceptable;
        public static final Condition not_allowed;
        public static final Condition not_authorized;
        public static final Condition payment_required;
        public static final Condition recipient_unavailable;
        public static final Condition redirect;
        public static final Condition registration_required;
        public static final Condition remote_server_error;
        public static final Condition remote_server_not_found;
        public static final Condition remote_server_timeout;
        public static final Condition request_timeout;
        public static final Condition resource_constraint;
        public static final Condition service_unavailable;
        public static final Condition subscription_required;
        public static final Condition undefined_condition;
        public static final Condition unexpected_request;
        private String value;

        static {
            interna_server_error = new Condition("internal-server-error");
            forbidden = new Condition("forbidden");
            bad_request = new Condition("bad-request");
            conflict = new Condition("conflict");
            feature_not_implemented = new Condition("feature-not-implemented");
            gone = new Condition("gone");
            item_not_found = new Condition("item-not-found");
            jid_malformed = new Condition("jid-malformed");
            no_acceptable = new Condition("not-acceptable");
            not_allowed = new Condition("not-allowed");
            not_authorized = new Condition("not-authorized");
            payment_required = new Condition("payment-required");
            recipient_unavailable = new Condition("recipient-unavailable");
            redirect = new Condition("redirect");
            registration_required = new Condition("registration-required");
            remote_server_error = new Condition("remote-server-error");
            remote_server_not_found = new Condition("remote-server-not-found");
            remote_server_timeout = new Condition("remote-server-timeout");
            resource_constraint = new Condition("resource-constraint");
            service_unavailable = new Condition("service-unavailable");
            subscription_required = new Condition("subscription-required");
            undefined_condition = new Condition("undefined-condition");
            unexpected_request = new Condition("unexpected-request");
            request_timeout = new Condition("request-timeout");
        }

        public Condition(String string2) {
            this.value = string2;
        }

        public String toString() {
            return this.value;
        }
    }

    private static class ErrorSpecification {
        private static Map<Condition, ErrorSpecification> instances = ErrorSpecification.errorSpecifications();
        private int code;
        private Condition condition;
        private Type type;

        private ErrorSpecification(Condition condition, Type type, int n2) {
            this.code = n2;
            this.type = type;
            this.condition = condition;
        }

        private static Map<Condition, ErrorSpecification> errorSpecifications() {
            HashMap<Condition, ErrorSpecification> hashMap = new HashMap<Condition, ErrorSpecification>(22);
            hashMap.put(Condition.interna_server_error, new ErrorSpecification(Condition.interna_server_error, Type.WAIT, 500));
            hashMap.put(Condition.forbidden, new ErrorSpecification(Condition.forbidden, Type.AUTH, 403));
            hashMap.put(Condition.bad_request, new ErrorSpecification(Condition.bad_request, Type.MODIFY, 400));
            hashMap.put(Condition.item_not_found, new ErrorSpecification(Condition.item_not_found, Type.CANCEL, 404));
            hashMap.put(Condition.conflict, new ErrorSpecification(Condition.conflict, Type.CANCEL, 409));
            hashMap.put(Condition.feature_not_implemented, new ErrorSpecification(Condition.feature_not_implemented, Type.CANCEL, 501));
            hashMap.put(Condition.gone, new ErrorSpecification(Condition.gone, Type.MODIFY, 302));
            hashMap.put(Condition.jid_malformed, new ErrorSpecification(Condition.jid_malformed, Type.MODIFY, 400));
            hashMap.put(Condition.no_acceptable, new ErrorSpecification(Condition.no_acceptable, Type.MODIFY, 406));
            hashMap.put(Condition.not_allowed, new ErrorSpecification(Condition.not_allowed, Type.CANCEL, 405));
            hashMap.put(Condition.not_authorized, new ErrorSpecification(Condition.not_authorized, Type.AUTH, 401));
            hashMap.put(Condition.payment_required, new ErrorSpecification(Condition.payment_required, Type.AUTH, 402));
            hashMap.put(Condition.recipient_unavailable, new ErrorSpecification(Condition.recipient_unavailable, Type.WAIT, 404));
            hashMap.put(Condition.redirect, new ErrorSpecification(Condition.redirect, Type.MODIFY, 302));
            hashMap.put(Condition.registration_required, new ErrorSpecification(Condition.registration_required, Type.AUTH, 407));
            hashMap.put(Condition.remote_server_not_found, new ErrorSpecification(Condition.remote_server_not_found, Type.CANCEL, 404));
            hashMap.put(Condition.remote_server_timeout, new ErrorSpecification(Condition.remote_server_timeout, Type.WAIT, 504));
            hashMap.put(Condition.remote_server_error, new ErrorSpecification(Condition.remote_server_error, Type.CANCEL, 502));
            hashMap.put(Condition.resource_constraint, new ErrorSpecification(Condition.resource_constraint, Type.WAIT, 500));
            hashMap.put(Condition.service_unavailable, new ErrorSpecification(Condition.service_unavailable, Type.CANCEL, 503));
            hashMap.put(Condition.subscription_required, new ErrorSpecification(Condition.subscription_required, Type.AUTH, 407));
            hashMap.put(Condition.undefined_condition, new ErrorSpecification(Condition.undefined_condition, Type.WAIT, 500));
            hashMap.put(Condition.unexpected_request, new ErrorSpecification(Condition.unexpected_request, Type.WAIT, 400));
            hashMap.put(Condition.request_timeout, new ErrorSpecification(Condition.request_timeout, Type.CANCEL, 408));
            return hashMap;
        }

        protected static ErrorSpecification specFor(Condition condition) {
            return instances.get(condition);
        }

        protected int getCode() {
            return this.code;
        }

        protected Condition getCondition() {
            return this.condition;
        }

        protected Type getType() {
            return this.type;
        }
    }

    public static enum Type {
        WAIT,
        CANCEL,
        MODIFY,
        AUTH,
        CONTINUE;

    }
}

