/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.util.StringUtils;

public class RosterPacket
extends IQ {
    private final List<Item> rosterItems = new ArrayList<Item>();
    private String version;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addRosterItem(Item item) {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            this.rosterItems.add(item);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getChildElementXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<query xmlns=\"jabber:iq:roster\" ");
        if (this.version != null) {
            stringBuilder.append(" ver=\"" + this.version + "\" ");
        }
        stringBuilder.append(">");
        List<Item> list = this.rosterItems;
        synchronized (list) {
            Iterator<Item> iterator = this.rosterItems.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    // MONITOREXIT @DISABLED, blocks:[2, 3, 4] lbl14 : MonitorExitStatement: MONITOREXIT : var1_2
                    stringBuilder.append("</query>");
                    return stringBuilder.toString();
                }
                stringBuilder.append(iterator.next().toXML());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getRosterItemCount() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return this.rosterItems.size();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<Item> getRosterItems() {
        List<Item> list = this.rosterItems;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<Item>(this.rosterItems));
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string2) {
        this.version = string2;
    }

    public static class Item {
        private final Set<String> groupNames;
        private ItemStatus itemStatus;
        private ItemType itemType;
        private String name;
        private String user;

        public Item(String string2, String string3) {
            this.user = string2.toLowerCase();
            this.name = string3;
            this.itemType = null;
            this.itemStatus = null;
            this.groupNames = new CopyOnWriteArraySet<String>();
        }

        public void addGroupName(String string2) {
            this.groupNames.add(string2);
        }

        public Set<String> getGroupNames() {
            return Collections.unmodifiableSet(this.groupNames);
        }

        public ItemStatus getItemStatus() {
            return this.itemStatus;
        }

        public ItemType getItemType() {
            return this.itemType;
        }

        public String getName() {
            return this.name;
        }

        public String getUser() {
            return this.user;
        }

        public void removeGroupName(String string2) {
            this.groupNames.remove(string2);
        }

        public void setItemStatus(ItemStatus itemStatus) {
            this.itemStatus = itemStatus;
        }

        public void setItemType(ItemType itemType) {
            this.itemType = itemType;
        }

        public void setName(String string2) {
            this.name = string2;
        }

        public String toXML() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<item jid=\"").append(this.user).append("\"");
            if (this.name != null) {
                stringBuilder.append(" name=\"").append(StringUtils.escapeForXML(this.name)).append("\"");
            }
            if (this.itemType != null) {
                stringBuilder.append(" subscription=\"").append((Object)this.itemType).append("\"");
            }
            if (this.itemStatus != null) {
                stringBuilder.append(" ask=\"").append(this.itemStatus).append("\"");
            }
            stringBuilder.append(">");
            Iterator<String> iterator = this.groupNames.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    stringBuilder.append("</item>");
                    return stringBuilder.toString();
                }
                String string2 = iterator.next();
                stringBuilder.append("<group>").append(StringUtils.escapeForXML(string2)).append("</group>");
            }
        }
    }

    public static class ItemStatus {
        public static final ItemStatus SUBSCRIPTION_PENDING = new ItemStatus("subscribe");
        public static final ItemStatus UNSUBSCRIPTION_PENDING = new ItemStatus("unsubscribe");
        private String value;

        private ItemStatus(String string2) {
            this.value = string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public static ItemStatus fromString(String string2) {
            block5: {
                block4: {
                    if (string2 == null) break block4;
                    if ("unsubscribe".equals(string2 = string2.toLowerCase())) {
                        return UNSUBSCRIPTION_PENDING;
                    }
                    if ("subscribe".equals(string2)) break block5;
                }
                return null;
            }
            return SUBSCRIPTION_PENDING;
        }

        public String toString() {
            return this.value;
        }
    }

    public static enum ItemType {
        none,
        to,
        from,
        both,
        remove;

    }
}

