/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

public class PrivacyItem {
    private boolean allow;
    private boolean filterIQ = false;
    private boolean filterMessage = false;
    private boolean filterPresence_in = false;
    private boolean filterPresence_out = false;
    private int order;
    private PrivacyRule rule;

    public PrivacyItem(String string2, boolean bl, int n2) {
        this.setRule(PrivacyRule.fromString(string2));
        this.setAllow(bl);
        this.setOrder(n2);
    }

    private PrivacyRule getRule() {
        return this.rule;
    }

    private void setAllow(boolean bl) {
        this.allow = bl;
    }

    private void setOrder(int n2) {
        this.order = n2;
    }

    private void setRule(PrivacyRule privacyRule) {
        this.rule = privacyRule;
    }

    public int getOrder() {
        return this.order;
    }

    public Type getType() {
        if (this.getRule() == null) {
            return null;
        }
        return this.getRule().getType();
    }

    public String getValue() {
        if (this.getRule() == null) {
            return null;
        }
        return this.getRule().getValue();
    }

    public boolean isAllow() {
        return this.allow;
    }

    public boolean isFilterEverything() {
        return !this.isFilterIQ() && !this.isFilterMessage() && !this.isFilterPresence_in() && !this.isFilterPresence_out();
    }

    public boolean isFilterIQ() {
        return this.filterIQ;
    }

    public boolean isFilterMessage() {
        return this.filterMessage;
    }

    public boolean isFilterPresence_in() {
        return this.filterPresence_in;
    }

    public boolean isFilterPresence_out() {
        return this.filterPresence_out;
    }

    public void setFilterIQ(boolean bl) {
        this.filterIQ = bl;
    }

    public void setFilterMessage(boolean bl) {
        this.filterMessage = bl;
    }

    public void setFilterPresence_in(boolean bl) {
        this.filterPresence_in = bl;
    }

    public void setFilterPresence_out(boolean bl) {
        this.filterPresence_out = bl;
    }

    public void setValue(String string2) {
        if (this.getRule() != null || string2 != null) {
            this.getRule().setValue(string2);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toXML() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<item");
        if (this.isAllow()) {
            stringBuilder.append(" action=\"allow\"");
        } else {
            stringBuilder.append(" action=\"deny\"");
        }
        stringBuilder.append(" order=\"").append(this.getOrder()).append("\"");
        if (this.getType() != null) {
            stringBuilder.append(" type=\"").append((Object)this.getType()).append("\"");
        }
        if (this.getValue() != null) {
            stringBuilder.append(" value=\"").append(this.getValue()).append("\"");
        }
        if (this.isFilterEverything()) {
            stringBuilder.append("/>");
            return stringBuilder.toString();
        }
        stringBuilder.append(">");
        if (this.isFilterIQ()) {
            stringBuilder.append("<iq/>");
        }
        if (this.isFilterMessage()) {
            stringBuilder.append("<message/>");
        }
        if (this.isFilterPresence_in()) {
            stringBuilder.append("<presence-in/>");
        }
        if (this.isFilterPresence_out()) {
            stringBuilder.append("<presence-out/>");
        }
        stringBuilder.append("</item>");
        return stringBuilder.toString();
    }

    public static class PrivacyRule {
        public static final String SUBSCRIPTION_BOTH = "both";
        public static final String SUBSCRIPTION_FROM = "from";
        public static final String SUBSCRIPTION_NONE = "none";
        public static final String SUBSCRIPTION_TO = "to";
        private Type type;
        private String value;

        protected static PrivacyRule fromString(String string2) {
            if (string2 == null) {
                return null;
            }
            PrivacyRule privacyRule = new PrivacyRule();
            privacyRule.setType(Type.valueOf(string2.toLowerCase()));
            return privacyRule;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void setSuscriptionValue(String string2) {
            string2 = SUBSCRIPTION_BOTH.equalsIgnoreCase(string2) ? SUBSCRIPTION_BOTH : (SUBSCRIPTION_TO.equalsIgnoreCase(string2) ? SUBSCRIPTION_TO : (SUBSCRIPTION_FROM.equalsIgnoreCase(string2) ? SUBSCRIPTION_FROM : (SUBSCRIPTION_NONE.equalsIgnoreCase(string2) ? SUBSCRIPTION_NONE : null)));
            this.value = string2;
        }

        private void setType(Type type) {
            this.type = type;
        }

        public Type getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isSuscription() {
            return this.getType() == Type.subscription;
        }

        protected void setValue(String string2) {
            if (this.isSuscription()) {
                this.setSuscriptionValue(string2);
                return;
            }
            this.value = string2;
        }
    }

    public static enum Type {
        group,
        jid,
        subscription;

    }
}

