/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public abstract class Packet {
    protected static final String DEFAULT_LANGUAGE = Locale.getDefault().getLanguage().toLowerCase();
    private static String DEFAULT_XML_NS = null;
    public static final String ID_NOT_AVAILABLE = "ID_NOT_AVAILABLE";
    public static final DateFormat XEP_0082_UTC_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static long id;
    private static String prefix;
    private XMPPError error = null;
    private String from = null;
    private final List<PacketExtension> packetExtensions;
    private String packetID = null;
    private final Map<String, Object> properties;
    private String to = null;
    private String xmlns = DEFAULT_XML_NS;

    static {
        XEP_0082_UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("UTC"));
        prefix = String.valueOf(StringUtils.randomString(5)) + "-";
        id = 0L;
    }

    public Packet() {
        this.packetExtensions = new CopyOnWriteArrayList<PacketExtension>();
        this.properties = new HashMap<String, Object>();
    }

    public static String getDefaultLanguage() {
        return DEFAULT_LANGUAGE;
    }

    public static String nextID() {
        synchronized (Packet.class) {
            CharSequence charSequence = new StringBuilder(String.valueOf(prefix));
            long l2 = id;
            id = 1L + l2;
            charSequence = charSequence.append(Long.toString(l2)).toString();
            return charSequence;
        }
    }

    public static void setDefaultXmlns(String string2) {
        DEFAULT_XML_NS = string2;
    }

    public void addExtension(PacketExtension packetExtension) {
        this.packetExtensions.add(packetExtension);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteProperty(String string2) {
        synchronized (this) {
            block6: {
                Map<String, Object> map = this.properties;
                if (map != null) break block6;
                return;
            }
            this.properties.remove(string2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            return true;
        }
        boolean bl2 = bl;
        if (object == null) return bl2;
        bl2 = bl;
        if (this.getClass() != object.getClass()) return bl2;
        object = (Packet)object;
        if (this.error != null) {
            bl2 = bl;
            if (!this.error.equals(((Packet)object).error)) return bl2;
        } else if (((Packet)object).error != null) {
            return false;
        }
        if (this.from != null) {
            bl2 = bl;
            if (!this.from.equals(((Packet)object).from)) return bl2;
        } else if (((Packet)object).from != null) {
            return false;
        }
        bl2 = bl;
        if (!this.packetExtensions.equals(((Packet)object).packetExtensions)) return bl2;
        if (this.packetID != null) {
            bl2 = bl;
            if (!this.packetID.equals(((Packet)object).packetID)) return bl2;
        } else if (((Packet)object).packetID != null) {
            return false;
        }
        if (this.properties != null) {
            bl2 = bl;
            if (!this.properties.equals(((Packet)object).properties)) return bl2;
        } else if (((Packet)object).properties != null) {
            return false;
        }
        if (this.to != null) {
            bl2 = bl;
            if (!this.to.equals(((Packet)object).to)) return bl2;
        } else if (((Packet)object).to != null) {
            return false;
        }
        if (this.xmlns != null) {
            bl2 = bl;
            if (this.xmlns.equals(((Packet)object).xmlns)) return true;
            return bl2;
        }
        if (((Packet)object).xmlns != null) return false;
        return true;
    }

    public XMPPError getError() {
        return this.error;
    }

    public PacketExtension getExtension(String string2) {
        return this.getExtension(null, string2);
    }

    public PacketExtension getExtension(String string2, String string3) {
        PacketExtension packetExtension;
        if (string3 == null) {
            return null;
        }
        Iterator<PacketExtension> iterator = this.packetExtensions.iterator();
        do {
            if (!iterator.hasNext()) {
                return null;
            }
            packetExtension = iterator.next();
        } while (string2 != null && !string2.equals(packetExtension.getElementName()) || !string3.equals(packetExtension.getNamespace()));
        return packetExtension;
    }

    public Collection<PacketExtension> getExtensions() {
        synchronized (this) {
            List<PacketExtension> list;
            if (this.packetExtensions == null) {
                list = Collections.emptyList();
                return list;
            }
            list = Collections.unmodifiableList(new ArrayList<PacketExtension>(this.packetExtensions));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getExtensionsXML() {
        synchronized (this) {
            block49: {
                var7_1 = new StringBuilder();
                var1_2 = this.getExtensions().iterator();
                block27: while (true) {
                    if (!var1_2.hasNext()) {
                        if (this.properties == null) return var7_1.toString();
                        if (this.properties.isEmpty() != false) return var7_1.toString();
                        var7_1.append("<properties xmlns=\"http://www.jivesoftware.com/xmlns/xmpp/properties\">");
                        var8_6 = this.getPropertyNames().iterator();
lbl11:
                        // 2 sources

                        while (true) {
                            if (var8_6.hasNext()) break block27;
                            var7_1.append("</properties>");
                            return var7_1.toString();
                        }
                    }
                    var7_1.append(var1_2.next().toXML());
                }
                var1_2 = var8_6.next();
                var9_21 = this.getProperty((String)var1_2);
                var7_1.append("<property>");
                var7_1.append("<name>").append(StringUtils.escapeForXML((String)var1_2)).append("</name>");
                var7_1.append("<value type=\"");
                if (var9_21 instanceof Integer) {
                    var7_1.append("integer\">").append(var9_21).append("</value>");
                } else if (var9_21 instanceof Long) {
                    var7_1.append("long\">").append(var9_21).append("</value>");
                } else if (var9_21 instanceof Float) {
                    var7_1.append("float\">").append(var9_21).append("</value>");
                } else if (var9_21 instanceof Double) {
                    var7_1.append("double\">").append(var9_21).append("</value>");
                } else if (var9_21 instanceof Boolean) {
                    var7_1.append("boolean\">").append(var9_21).append("</value>");
                } else if (var9_21 instanceof String) {
                    var7_1.append("string\">");
                    var7_1.append(StringUtils.escapeForXML((String)var9_21));
                    var7_1.append("</value>");
                } else {
                    var2_7 = null;
                    var6_20 = null;
                    var3_11 = null;
                    var4_13 = null;
                    var5_18 = null;
                    var1_2 = new ByteArrayOutputStream();
                }
lbl63:
                // 12 sources

                while (true) {
                    var7_1.append("</property>");
                    ** continue;
                    break;
                }
                var2_7 = new ObjectOutputStream((OutputStream)var1_2);
                var2_7.writeObject(var9_21);
                var7_1.append("java-object\">");
                var7_1.append(StringUtils.encodeBase64(var1_2.toByteArray())).append("</value>");
                if (var2_7 == null) break block49;
                try {
                    var2_7.close();
                }
                catch (Exception var2_10) {
                    ** continue;
                }
            }
lbl79:
            // 2 sources

            while (true) {
                if (var1_2 == null) ** GOTO lbl63
                try {
                    var1_2.close();
                }
                catch (Exception var1_3) {}
                ** GOTO lbl63
                break;
            }
            catch (Exception var4_14) {
                var1_2 = var6_20;
lbl88:
                // 3 sources

                while (true) {
                    block50: {
                        var2_7 = var1_2;
                        var3_11 = var5_18;
                        var4_13.printStackTrace();
                        if (var5_18 == null) break block50;
                        var5_18.close();
                    }
lbl97:
                    // 2 sources

                    while (true) {
                        if (var1_2 == null) ** GOTO lbl63
                        try {
                            var1_2.close();
                        }
                        catch (Exception var1_4) {}
                        ** continue;
                        break;
                    }
                    catch (Throwable var1_5) lbl-1000:
                    // 3 sources

                    {
                        block51: {
                            while (true) {
                                if (var3_11 != null) {
                                    ** try [egrp 12[TRYBLOCK] [27 : 507->511)] { 
lbl108:
                                    // 1 sources

                                    break block51;
                                }
lbl109:
                                // 4 sources

                                while (true) {
                                    if (var2_7 == null) throw var1_2;
                                    var2_7.close();
                                    throw var1_2;
                                    break;
                                }
lbl114:
                                // 1 sources

                                catch (Exception var3_12) {
                                    ** GOTO lbl109
                                }
                                catch (Exception var2_9) {
                                    throw var1_2;
                                }
                                break;
                            }
                            catch (Exception var2_8) {
                                ** continue;
                            }
                        }
                        var3_11.close();
                        ** continue;
                    }
                    break;
                }
            }
            catch (Exception var4_17) {
                var5_18 = var2_7;
                ** GOTO lbl88
            }
            catch (Throwable var5_19) {
                var2_7 = var1_2;
                var3_11 = var4_13;
                var1_2 = var5_19;
                ** GOTO lbl-1000
            }
            catch (Exception var4_16) {
                ** continue;
            }
            catch (Throwable var4_15) {
                var3_11 = var2_7;
                var2_7 = var1_2;
                var1_2 = var4_15;
                ** continue;
            }
        }
    }

    public String getFrom() {
        return this.from;
    }

    public String getPacketID() {
        if (ID_NOT_AVAILABLE.equals(this.packetID)) {
            return null;
        }
        if (this.packetID == null) {
            this.packetID = Packet.nextID();
        }
        return this.packetID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getProperty(String object) {
        synchronized (this) {
            block6: {
                Map<String, Object> map = this.properties;
                if (map != null) break block6;
                return null;
            }
            object = this.properties.get(object);
            return object;
        }
    }

    public Collection<String> getPropertyNames() {
        synchronized (this) {
            Set<String> set;
            if (this.properties == null) {
                set = Collections.emptySet();
                return set;
            }
            set = Collections.unmodifiableSet(new HashSet<String>(this.properties.keySet()));
        }
    }

    public String getTo() {
        return this.to;
    }

    public String getXmlns() {
        return this.xmlns;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hashCode() {
        int n2 = 0;
        int n3 = this.xmlns != null ? this.xmlns.hashCode() : 0;
        int n4 = this.packetID != null ? this.packetID.hashCode() : 0;
        int n5 = this.to != null ? this.to.hashCode() : 0;
        int n6 = this.from != null ? this.from.hashCode() : 0;
        int n7 = this.packetExtensions.hashCode();
        int n8 = this.properties.hashCode();
        if (this.error != null) {
            n2 = this.error.hashCode();
        }
        return (((((n3 * 31 + n4) * 31 + n5) * 31 + n6) * 31 + n7) * 31 + n8) * 31 + n2;
    }

    public void removeExtension(PacketExtension packetExtension) {
        this.packetExtensions.remove(packetExtension);
    }

    public void setError(XMPPError xMPPError) {
        this.error = xMPPError;
    }

    public void setFrom(String string2) {
        this.from = string2;
    }

    public void setPacketID(String string2) {
        this.packetID = string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setProperty(String string2, Object object) {
        synchronized (this) {
            if (!(object instanceof Serializable)) {
                throw new IllegalArgumentException("Value must be serialiazble");
            }
            this.properties.put(string2, object);
            return;
        }
    }

    public void setTo(String string2) {
        this.to = string2;
    }

    public abstract String toXML();
}

