/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class Message
extends Packet {
    private final Set<Body> bodies;
    private String language;
    private final Set<Subject> subjects;
    private String thread = null;
    private Type type = Type.normal;

    public Message() {
        this.subjects = new HashSet<Subject>();
        this.bodies = new HashSet<Body>();
    }

    public Message(String string2) {
        this.subjects = new HashSet<Subject>();
        this.bodies = new HashSet<Body>();
        this.setTo(string2);
    }

    public Message(String string2, Type type) {
        this.subjects = new HashSet<Subject>();
        this.bodies = new HashSet<Body>();
        this.setTo(string2);
        this.type = type;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String determineLanguage(String string2) {
        String string3 = string2;
        if ("".equals(string2)) {
            string3 = null;
        }
        if (string3 == null && this.language != null) {
            return this.language;
        }
        string2 = string3;
        if (string3 != null) return string2;
        return Message.getDefaultLanguage();
    }

    private Body getMessageBody(String string2) {
        Body body;
        string2 = this.determineLanguage(string2);
        Iterator<Body> iterator = this.bodies.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!string2.equals((body = iterator.next()).language));
        return body;
    }

    private Subject getMessageSubject(String string2) {
        Subject subject;
        string2 = this.determineLanguage(string2);
        Iterator<Subject> iterator = this.subjects.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!string2.equals((subject = iterator.next()).language));
        return subject;
    }

    public Body addBody(String object, String string2) {
        object = new Body(this.determineLanguage((String)object), string2);
        this.bodies.add((Body)object);
        return object;
    }

    public Subject addSubject(String object, String string2) {
        object = new Subject(this.determineLanguage((String)object), string2);
        this.subjects.add((Subject)object);
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean equals(Object object) {
        block10: {
            block9: {
                if (this == object) break block9;
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                if (!super.equals(object = (Message)object)) {
                    return false;
                }
                if (this.bodies.size() != ((Message)object).bodies.size() || !this.bodies.containsAll(((Message)object).bodies)) {
                    return false;
                }
                if (this.language != null ? !this.language.equals(((Message)object).language) : ((Message)object).language != null) {
                    return false;
                }
                if (this.subjects.size() != ((Message)object).subjects.size() || !this.subjects.containsAll(((Message)object).subjects)) {
                    return false;
                }
                if (this.thread != null ? !this.thread.equals(((Message)object).thread) : ((Message)object).thread != null) {
                    return false;
                }
                if (this.type != ((Message)object).type) break block10;
            }
            return true;
        }
        return false;
    }

    public Collection<Body> getBodies() {
        return Collections.unmodifiableCollection(this.bodies);
    }

    public String getBody() {
        return this.getBody(null);
    }

    public String getBody(String object) {
        if ((object = this.getMessageBody((String)object)) == null) {
            return null;
        }
        return ((Body)object).message;
    }

    public Collection<String> getBodyLanguages() {
        Body body = this.getMessageBody(null);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Body> iterator = this.bodies.iterator();
        while (iterator.hasNext()) {
            Body body2 = iterator.next();
            if (body2.equals(body)) continue;
            arrayList.add(body2.language);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getSubject() {
        return this.getSubject(null);
    }

    public String getSubject(String object) {
        if ((object = this.getMessageSubject((String)object)) == null) {
            return null;
        }
        return ((Subject)object).subject;
    }

    public Collection<String> getSubjectLanguages() {
        Subject subject = this.getMessageSubject(null);
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<Subject> iterator = this.subjects.iterator();
        while (iterator.hasNext()) {
            Subject subject2 = iterator.next();
            if (subject2.equals(subject)) continue;
            arrayList.add(subject2.language);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection<Subject> getSubjects() {
        return Collections.unmodifiableCollection(this.subjects);
    }

    public String getThread() {
        return this.thread;
    }

    public Type getType() {
        return this.type;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.type != null ? this.type.hashCode() : 0;
        int n4 = this.subjects.hashCode();
        int n5 = this.thread != null ? this.thread.hashCode() : 0;
        if (this.language != null) {
            n2 = this.language.hashCode();
        }
        return (((n3 * 31 + n4) * 31 + n5) * 31 + n2) * 31 + this.bodies.hashCode();
    }

    public boolean removeBody(String string2) {
        Body body;
        string2 = this.determineLanguage(string2);
        Iterator<Body> iterator = this.bodies.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!string2.equals((body = iterator.next()).language));
        return this.bodies.remove(body);
    }

    public boolean removeBody(Body body) {
        return this.bodies.remove(body);
    }

    public boolean removeSubject(String string2) {
        Subject subject;
        string2 = this.determineLanguage(string2);
        Iterator<Subject> iterator = this.subjects.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!string2.equals((subject = iterator.next()).language));
        return this.subjects.remove(subject);
    }

    public boolean removeSubject(Subject subject) {
        return this.subjects.remove(subject);
    }

    public void setBody(String string2) {
        if (string2 == null) {
            this.removeBody("");
            return;
        }
        this.addBody(null, string2);
    }

    public void setLanguage(String string2) {
        this.language = string2;
    }

    public void setSubject(String string2) {
        if (string2 == null) {
            this.removeSubject("");
            return;
        }
        this.addSubject(null, string2);
    }

    public void setThread(String string2) {
        this.thread = string2;
    }

    public void setType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null.");
        }
        this.type = type;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String toXML() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<message");
        if (this.getXmlns() != null) {
            stringBuilder.append(" xmlns=\"").append(this.getXmlns()).append("\"");
        }
        if (this.language != null) {
            stringBuilder.append(" xml:lang=\"").append(this.getLanguage()).append("\"");
        }
        if (this.getPacketID() != null) {
            stringBuilder.append(" id=\"").append(this.getPacketID()).append("\"");
        }
        if (this.getTo() != null) {
            stringBuilder.append(" to=\"").append(StringUtils.escapeForXML(this.getTo())).append("\"");
        }
        if (this.getFrom() != null) {
            stringBuilder.append(" from=\"").append(StringUtils.escapeForXML(this.getFrom())).append("\"");
        }
        if (this.type != Type.normal) {
            stringBuilder.append(" type=\"").append((Object)this.type).append("\"");
        }
        stringBuilder.append(">");
        Object object2 = this.getMessageSubject(null);
        if (object2 != null) {
            stringBuilder.append("<subject>").append(StringUtils.escapeForXML(((Subject)object2).getSubject()));
            stringBuilder.append("</subject>");
        }
        object2 = this.getSubjects().iterator();
        while (true) {
            if (!object2.hasNext()) {
                object2 = this.getMessageBody(null);
                if (object2 != null) {
                    stringBuilder.append("<body>").append(StringUtils.escapeForXML(((Body)object2).message)).append("</body>");
                }
                break;
            }
            object = (Subject)object2.next();
            stringBuilder.append("<subject xml:lang=\"" + ((Subject)object).getLanguage() + "\">");
            stringBuilder.append(StringUtils.escapeForXML(((Subject)object).getSubject()));
            stringBuilder.append("</subject>");
        }
        object = this.getBodies().iterator();
        while (true) {
            if (!object.hasNext()) {
                if (this.thread != null) {
                    stringBuilder.append("<thread>").append(this.thread).append("</thread>");
                }
                if (this.type == Type.error && (object2 = this.getError()) != null) {
                    stringBuilder.append(((XMPPError)object2).toXML());
                }
                stringBuilder.append(this.getExtensionsXML());
                stringBuilder.append("</message>");
                return stringBuilder.toString();
            }
            Body body = (Body)object.next();
            if (body.equals(object2)) continue;
            stringBuilder.append("<body xml:lang=\"").append(body.getLanguage()).append("\">");
            stringBuilder.append(StringUtils.escapeForXML(body.getMessage()));
            stringBuilder.append("</body>");
        }
    }

    public static class Body {
        private String language;
        private String message;

        private Body(String string2, String string3) {
            if (string2 == null) {
                throw new NullPointerException("Language cannot be null.");
            }
            if (string3 == null) {
                throw new NullPointerException("Message cannot be null.");
            }
            this.language = string2;
            this.message = string3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                return true;
            }
            boolean bl2 = bl;
            if (object == null) return bl2;
            bl2 = bl;
            if (this.getClass() != object.getClass()) return bl2;
            object = (Body)object;
            if (this.language != null) {
                bl2 = bl;
                if (!this.language.equals(((Body)object).language)) return bl2;
                return this.message.equals(((Body)object).message);
            }
            if (((Body)object).language == null) return this.message.equals(((Body)object).message);
            return false;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getMessage() {
            return this.message;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int hashCode() {
            int n2;
            int n3 = this.message.hashCode();
            if (this.language != null) {
                n2 = this.language.hashCode();
                return n3 * 31 + n2;
            }
            n2 = 0;
            return n3 * 31 + n2;
        }
    }

    public static class Subject {
        private String language;
        private String subject;

        private Subject(String string2, String string3) {
            if (string2 == null) {
                throw new NullPointerException("Language cannot be null.");
            }
            if (string3 == null) {
                throw new NullPointerException("Subject cannot be null.");
            }
            this.language = string2;
            this.subject = string3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            boolean bl = false;
            if (this == object) {
                return true;
            }
            boolean bl2 = bl;
            if (object == null) return bl2;
            bl2 = bl;
            if (this.getClass() != object.getClass()) return bl2;
            object = (Subject)object;
            bl2 = bl;
            if (!this.language.equals(((Subject)object).language)) return bl2;
            return this.subject.equals(((Subject)object).subject);
        }

        public String getLanguage() {
            return this.language;
        }

        public String getSubject() {
            return this.subject;
        }

        public int hashCode() {
            return this.subject.hashCode() * 31 + this.language.hashCode();
        }
    }

    public static enum Type {
        normal,
        chat,
        groupchat,
        headline,
        error;


        public static Type fromString(String object) {
            try {
                object = Type.valueOf(object);
                return object;
            }
            catch (Exception exception) {
                return normal;
            }
        }
    }
}

