/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public abstract class IQ
extends Packet {
    private Type type = Type.GET;

    public static IQ createErrorResponse(IQ iQ, XMPPError xMPPError) {
        if (iQ.getType() != Type.GET && iQ.getType() != Type.SET) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + iQ.toXML());
        }
        IQ iQ2 = new IQ(){

            @Override
            public String getChildElementXML() {
                return IQ.this.getChildElementXML();
            }
        };
        iQ2.setType(Type.ERROR);
        iQ2.setPacketID(iQ.getPacketID());
        iQ2.setFrom(iQ.getTo());
        iQ2.setTo(iQ.getFrom());
        iQ2.setError(xMPPError);
        return iQ2;
    }

    public static IQ createResultIQ(IQ iQ) {
        if (iQ.getType() != Type.GET && iQ.getType() != Type.SET) {
            throw new IllegalArgumentException("IQ must be of type 'set' or 'get'. Original IQ: " + iQ.toXML());
        }
        IQ iQ2 = new IQ(){

            @Override
            public String getChildElementXML() {
                return null;
            }
        };
        iQ2.setType(Type.RESULT);
        iQ2.setPacketID(iQ.getPacketID());
        iQ2.setFrom(iQ.getTo());
        iQ2.setTo(iQ.getFrom());
        return iQ2;
    }

    public abstract String getChildElementXML();

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        if (type == null) {
            this.type = Type.GET;
            return;
        }
        this.type = type;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String toXML() {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<iq ");
        if (this.getPacketID() != null) {
            stringBuilder.append("id=\"" + this.getPacketID() + "\" ");
        }
        if (this.getTo() != null) {
            stringBuilder.append("to=\"").append(StringUtils.escapeForXML(this.getTo())).append("\" ");
        }
        if (this.getFrom() != null) {
            stringBuilder.append("from=\"").append(StringUtils.escapeForXML(this.getFrom())).append("\" ");
        }
        if (this.type == null) {
            stringBuilder.append("type=\"get\">");
        } else {
            stringBuilder.append("type=\"").append(this.getType()).append("\">");
        }
        if ((object = this.getChildElementXML()) != null) {
            stringBuilder.append((String)object);
        }
        if ((object = this.getError()) != null) {
            stringBuilder.append(((XMPPError)object).toXML());
        }
        stringBuilder.append("</iq>");
        return stringBuilder.toString();
    }

    public static class Type {
        public static final Type ERROR;
        public static final Type GET;
        public static final Type RESULT;
        public static final Type SET;
        private String value;

        static {
            GET = new Type("get");
            SET = new Type("set");
            RESULT = new Type("result");
            ERROR = new Type("error");
        }

        private Type(String string2) {
            this.value = string2;
        }

        /*
         * Enabled aggressive block sorting
         */
        public static Type fromString(String string2) {
            block7: {
                block6: {
                    if (string2 == null) break block6;
                    string2 = string2.toLowerCase();
                    if (GET.toString().equals(string2)) {
                        return GET;
                    }
                    if (SET.toString().equals(string2)) {
                        return SET;
                    }
                    if (ERROR.toString().equals(string2)) {
                        return ERROR;
                    }
                    if (RESULT.toString().equals(string2)) break block7;
                }
                return null;
            }
            return RESULT;
        }

        public String toString() {
            return this.value;
        }
    }
}

