/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class OrFilter
implements PacketFilter {
    private PacketFilter[] filters;
    private int size;

    public OrFilter() {
        this.size = 0;
        this.filters = new PacketFilter[3];
    }

    public OrFilter(PacketFilter packetFilter, PacketFilter packetFilter2) {
        if (packetFilter == null || packetFilter2 == null) {
            throw new IllegalArgumentException("Parameters cannot be null.");
        }
        this.size = 2;
        this.filters = new PacketFilter[2];
        this.filters[0] = packetFilter;
        this.filters[1] = packetFilter2;
    }

    @Override
    public boolean accept(Packet packet) {
        int n2 = 0;
        while (n2 < this.size) {
            if (this.filters[n2].accept(packet)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addFilter(PacketFilter packetFilter) {
        if (packetFilter == null) {
            throw new IllegalArgumentException("Parameter cannot be null.");
        }
        if (this.size == this.filters.length) {
            PacketFilter[] packetFilterArray = new PacketFilter[this.filters.length + 2];
            int n2 = 0;
            while (true) {
                if (n2 >= this.filters.length) {
                    this.filters = packetFilterArray;
                    break;
                }
                packetFilterArray[n2] = this.filters[n2];
                ++n2;
            }
        }
        this.filters[this.size] = packetFilter;
        ++this.size;
    }

    public String toString() {
        return this.filters.toString();
    }
}

