/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.filter;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class AndFilter
implements PacketFilter {
    private List<PacketFilter> filters = new ArrayList<PacketFilter>();

    public AndFilter() {
    }

    public AndFilter(PacketFilter ... packetFilterArray) {
        if (packetFilterArray == null) {
            throw new IllegalArgumentException("Parameter cannot be null.");
        }
        int n2 = packetFilterArray.length;
        int n3 = 0;
        while (n3 < n2) {
            PacketFilter packetFilter = packetFilterArray[n3];
            if (packetFilter == null) {
                throw new IllegalArgumentException("Parameter cannot be null.");
            }
            this.filters.add(packetFilter);
            ++n3;
        }
        return;
    }

    @Override
    public boolean accept(Packet packet) {
        Iterator<PacketFilter> iterator = this.filters.iterator();
        do {
            if (iterator.hasNext()) continue;
            return true;
        } while (iterator.next().accept(packet));
        return false;
    }

    public void addFilter(PacketFilter packetFilter) {
        if (packetFilter == null) {
            throw new IllegalArgumentException("Parameter cannot be null.");
        }
        this.filters.add(packetFilter);
    }

    public String toString() {
        return this.filters.toString();
    }
}

