/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PacketReader;
import org.jivesoftware.smack.PacketWriter;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterStorage;
import org.jivesoftware.smack.ServerTrustManager;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.util.StringUtils;

public class XMPPConnection
extends Connection {
    private boolean anonymous = false;
    private boolean authenticated = false;
    private Collection<String> compressionMethods;
    private boolean connected = false;
    String connectionID = null;
    PacketReader packetReader;
    PacketWriter packetWriter;
    Roster roster = null;
    protected Socket socket;
    private String user = null;
    private boolean usingCompression;
    private boolean usingTLS = false;
    private boolean wasAuthenticated = false;

    public XMPPConnection(ConnectionConfiguration connectionConfiguration) {
        super(connectionConfiguration);
    }

    public XMPPConnection(ConnectionConfiguration connectionConfiguration, CallbackHandler callbackHandler) {
        super(connectionConfiguration);
        connectionConfiguration.setCallbackHandler(callbackHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void connectUsingConfiguration(ConnectionConfiguration connectionConfiguration) throws XMPPException {
        String string2 = connectionConfiguration.getHost();
        int n2 = connectionConfiguration.getPort();
        try {
            this.socket = connectionConfiguration.getSocketFactory() == null ? new Socket(string2, n2) : connectionConfiguration.getSocketFactory().createSocket(string2, n2);
            this.initConnection();
            return;
        }
        catch (UnknownHostException unknownHostException) {
            string2 = "Could not connect to " + string2 + ":" + n2 + ".";
            throw new XMPPException(string2, new XMPPError(XMPPError.Condition.remote_server_timeout, string2), unknownHostException);
        }
        catch (IOException iOException) {
            string2 = "XMPPError connecting to " + string2 + ":" + n2 + ".";
            throw new XMPPException(string2, new XMPPError(XMPPError.Condition.remote_server_error, string2), iOException);
        }
    }

    private boolean hasAvailableCompressionMethod(String string2) {
        return this.compressionMethods != null && this.compressionMethods.contains(string2);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initConnection() throws XMPPException {
        var1_2 = var2_1 = true;
        if (this.packetReader != null) {
            var1_2 = var2_1;
            if (this.packetWriter != null) {
                var1_2 = false;
            }
        }
        if (!var1_2) {
            this.usingCompression = false;
        }
        this.initReaderAndWriter();
        if (!var1_2) ** GOTO lbl14
        try {
            block24: {
                this.packetWriter = new PacketWriter(this);
                this.packetReader = new PacketReader(this);
                break block24;
lbl14:
                // 1 sources

                this.packetWriter.init();
                this.packetReader.init();
            }
            this.packetWriter.startup();
            this.packetReader.startup();
            this.connected = true;
            this.packetWriter.startKeepAliveProcess();
            if (!var1_2) {
                if (this.wasAuthenticated != false) return;
                this.packetReader.notifyReconnection();
                return;
            }
            var3_3 = XMPPConnection.getConnectionCreationListeners().iterator();
            while (true) {
                if (!var3_3.hasNext()) {
                    return;
                }
                var3_3.next().connectionCreated(this);
            }
        }
        catch (XMPPException var3_4) {
            if (this.packetWriter != null) {
                try {
                    this.packetWriter.shutdown();
                }
                catch (Throwable var4_9) {}
                this.packetWriter = null;
            }
            if (this.packetReader != null) {
                try {
                    this.packetReader.shutdown();
                }
                catch (Throwable var4_8) {}
                this.packetReader = null;
            }
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (Throwable var4_7) {}
                this.reader = null;
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                }
                catch (Throwable var4_6) {}
                this.writer = null;
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception var4_5) {}
                this.socket = null;
            }
            this.setWasAuthenticated(this.authenticated);
            this.authenticated = false;
            this.connected = false;
            throw var3_4;
        }
    }

    private void initReaderAndWriter() throws XMPPException {
        if (!this.usingCompression) {
            this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
            this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
            return;
        }
        try {
            Class<?> clazz = Class.forName("com.jcraft.jzlib.ZOutputStream");
            Object obj = clazz.getConstructor(OutputStream.class, Integer.TYPE).newInstance(this.socket.getOutputStream(), 9);
            clazz.getMethod("setFlushMode", Integer.TYPE).invoke(obj, 2);
            this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)obj, "UTF-8"));
            clazz = Class.forName("com.jcraft.jzlib.ZInputStream");
            obj = clazz.getConstructor(InputStream.class).newInstance(this.socket.getInputStream());
            clazz.getMethod("setFlushMode", Integer.TYPE).invoke(obj, 2);
            this.reader = new BufferedReader(new InputStreamReader((InputStream)obj, "UTF-8"));
            return;
        }
        catch (Exception exception) {
            try {
                exception.printStackTrace();
                this.reader = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.writer = new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream(), "UTF-8"));
                return;
            }
            catch (IOException iOException) {
                throw new XMPPException("XMPPError establishing connection with server.", new XMPPError(XMPPError.Condition.remote_server_error, "XMPPError establishing connection with server."), iOException);
            }
        }
    }

    private void requestStreamCompression() {
        try {
            this.writer.write("<compress xmlns='http://jabber.org/protocol/compress'>");
            this.writer.write("<method>zlib</method></compress>");
            this.writer.flush();
            return;
        }
        catch (IOException iOException) {
            this.packetReader.notifyConnectionError(iOException);
            return;
        }
    }

    private void setWasAuthenticated(boolean bl) {
        if (!this.wasAuthenticated) {
            this.wasAuthenticated = bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private boolean useCompression() {
        if (this.authenticated) {
            throw new IllegalStateException("Compression should be negotiated before authentication.");
        }
        try {
            Class.forName("com.jcraft.jzlib.ZOutputStream");
            if (!this.hasAvailableCompressionMethod("zlib")) return false;
            this.requestStreamCompression();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Cannot use compression. Add smackx.jar to the classpath");
        }
        try {
            this.wait(SmackConfiguration.getPacketReplyTimeout() * 5);
            // MONITOREXIT : this
            return this.usingCompression;
        }
        catch (InterruptedException interruptedException) {
            return this.usingCompression;
        }
    }

    public void addPacketWriterInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        this.addPacketInterceptor(packetInterceptor, packetFilter);
    }

    public void addPacketWriterListener(PacketListener packetListener, PacketFilter packetFilter) {
        this.addPacketSendingListener(packetListener, packetFilter);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void connect() throws XMPPException {
        this.connectUsingConfiguration(this.config);
        if (this.connected && this.wasAuthenticated) {
            try {
                if (this.isAnonymous()) {
                    this.loginAnonymously();
                } else {
                    this.login(this.config.getUsername(), this.config.getPassword(), this.config.getResource());
                }
                this.packetReader.notifyReconnection();
                return;
            }
            catch (XMPPException xMPPException) {
                xMPPException.printStackTrace();
            }
        }
    }

    @Override
    public void disconnect(Presence presence) {
        if (this.packetReader == null || this.packetWriter == null) {
            return;
        }
        this.shutdown(presence);
        if (this.roster != null) {
            this.roster.cleanup();
            this.roster = null;
        }
        this.wasAuthenticated = false;
        this.packetWriter.cleanup();
        this.packetWriter = null;
        this.packetReader.cleanup();
        this.packetReader = null;
    }

    @Override
    public String getConnectionID() {
        if (!this.isConnected()) {
            return null;
        }
        return this.connectionID;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Roster getRoster() {
        if (this.roster == null) {
            return null;
        }
        if (this.roster.rosterInitialized) return this.roster;
        try {
            Roster roster = this.roster;
            synchronized (roster) {
            }
        }
        catch (InterruptedException interruptedException) {
            return this.roster;
        }
        {
            long l2 = SmackConfiguration.getPacketReplyTimeout();
            long l3 = System.currentTimeMillis();
            while (!this.roster.rosterInitialized) {
                if (l2 <= 0L) return this.roster;
                this.roster.wait(l2);
                long l4 = System.currentTimeMillis();
                l2 -= l4 - l3;
                l3 = l4;
            }
            return this.roster;
        }
    }

    @Override
    public String getUser() {
        if (!this.isAuthenticated()) {
            return null;
        }
        return this.user;
    }

    @Override
    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public boolean isAuthenticated() {
        return this.authenticated;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public boolean isSecureConnection() {
        return this.isUsingTLS();
    }

    @Override
    public boolean isUsingCompression() {
        return this.usingCompression;
    }

    public boolean isUsingTLS() {
        return this.usingTLS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void login(String string2, String string3, String string4) throws XMPPException {
        synchronized (this) {
            if (!this.isConnected()) {
                throw new IllegalStateException("Not connected to server.");
            }
            if (this.authenticated) {
                throw new IllegalStateException("Already logged in to server.");
            }
            String string5 = string2.toLowerCase().trim();
            string2 = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasNonAnonymousAuthentication() ? (string3 != null ? this.saslAuthentication.authenticate(string5, string3, string4) : this.saslAuthentication.authenticate(string5, string4, this.config.getCallbackHandler())) : new NonSASLAuthentication(this).authenticate(string5, string3, string4);
            if (string2 != null) {
                this.user = string2;
                this.config.setServiceName(StringUtils.parseServer(string2));
            } else {
                this.user = String.valueOf(string5) + "@" + this.getServiceName();
                if (string4 != null) {
                    this.user = String.valueOf(this.user) + "/" + string4;
                }
            }
            if (this.config.isCompressionEnabled()) {
                this.useCompression();
            }
            if (this.roster == null) {
                this.roster = this.rosterStorage == null ? new Roster(this) : new Roster(this, this.rosterStorage);
            }
            if (this.config.isRosterLoadedAtLogin()) {
                this.roster.reload();
            }
            if (this.config.isSendPresence()) {
                this.packetWriter.sendPacket(new Presence(Presence.Type.available));
            }
            this.authenticated = true;
            this.anonymous = false;
            this.config.setLoginInfo(string5, string3, string4);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void loginAnonymously() throws XMPPException {
        synchronized (this) {
            if (!this.isConnected()) {
                throw new IllegalStateException("Not connected to server.");
            }
            if (this.authenticated) {
                throw new IllegalStateException("Already logged in to server.");
            }
            String string2 = this.config.isSASLAuthenticationEnabled() && this.saslAuthentication.hasAnonymousAuthentication() ? this.saslAuthentication.authenticateAnonymously() : new NonSASLAuthentication(this).authenticateAnonymously();
            this.user = string2;
            this.config.setServiceName(StringUtils.parseServer(string2));
            if (this.config.isCompressionEnabled()) {
                this.useCompression();
            }
            this.roster = null;
            this.packetWriter.sendPacket(new Presence(Presence.Type.available));
            this.authenticated = true;
            this.anonymous = true;
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    void proceedTLSReceived() throws Exception {
        block18: {
            block20: {
                block19: {
                    var3_1 = SSLContext.getInstance("TLS");
                    var1_2 = null;
                    var2_8 = null;
                    if (this.config.getCallbackHandler() == null) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            var2_8 = new ServerTrustManager(this.getServiceName(), this.config);
                            var4_9 = new SecureRandom();
                            var3_1.init((KeyManager[])var1_2, new TrustManager[]{var2_8}, (SecureRandom)var4_9);
                            var1_2 = this.socket;
                            this.socket = var3_1.getSocketFactory().createSocket((Socket)var1_2, var1_2.getInetAddress().getHostName(), var1_2.getPort(), true);
                            this.socket.setSoTimeout(0);
                            this.socket.setKeepAlive(true);
                            this.initReaderAndWriter();
                            ((SSLSocket)this.socket).startHandshake();
                            this.usingTLS = true;
                            this.packetWriter.setWriter(this.writer);
                            this.packetWriter.openStream();
                            return;
                        }
                    }
                    if (this.config.getKeystoreType().equals("NONE")) {
                        var1_2 = null;
                        var2_8 = null;
lbl22:
                        // 6 sources

                        while (true) {
                            var4_9 = KeyManagerFactory.getInstance("SunX509");
                            if (var2_8 != null) break block18;
                            var4_9.init((KeyStore)var1_2, null);
lbl27:
                            // 2 sources

                            while (true) {
                                var1_2 = var4_9.getKeyManagers();
                                break;
                            }
                            break;
                        }
                    }
                    if (!this.config.getKeystoreType().equals("PKCS11")) break block19;
                    try {
                        var1_2 = (Provider)Class.forName("sun.security.pkcs11.SunPKCS11").getConstructor(new Class[]{InputStream.class}).newInstance(new Object[]{new ByteArrayInputStream(("name = SmartCard\nlibrary = " + this.config.getPKCS11Library()).getBytes())});
                        Security.addProvider((Provider)var1_2);
                        var1_2 = KeyStore.getInstance("PKCS11", (Provider)var1_2);
                        var2_8 = new PasswordCallback("PKCS11 Password: ", false);
                    }
                    catch (Exception var1_3) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            var1_2 = null;
                            var2_8 = null;
                            break;
                        }
                    }
                    this.config.getCallbackHandler().handle(new Callback[]{var2_8});
                    var1_2.load(null, var2_8.getPassword());
                    ** GOTO lbl22
                }
                if (!this.config.getKeystoreType().equals("Apple")) break block20;
                var1_2 = KeyStore.getInstance("KeychainStore", "Apple");
                var1_2.load(null, null);
                ** GOTO lbl22
            }
            var1_2 = KeyStore.getInstance(this.config.getKeystoreType());
            try {
                var2_8 = new PasswordCallback("Keystore Password: ", false);
            }
            catch (Exception var1_4) lbl-1000:
            // 2 sources

            {
                while (true) {
                    var1_2 = null;
                    var2_8 = null;
                    ** continue;
                    break;
                }
            }
            try {
                this.config.getCallbackHandler().handle(new Callback[]{var2_8});
                var1_2.load(new FileInputStream(this.config.getKeystorePath()), var2_8.getPassword());
            }
            catch (Exception var1_6) {
                ** continue;
            }
        }
        try {
            var4_9.init((KeyStore)var1_2, var2_8.getPassword());
            var2_8.clearPassword();
            ** continue;
        }
        catch (NullPointerException var1_5) {
            var1_2 = null;
        }
        ** while (true)
        catch (Exception var1_7) {
            ** continue;
        }
    }

    public void removePacketWriterInterceptor(PacketInterceptor packetInterceptor) {
        this.removePacketInterceptor(packetInterceptor);
    }

    public void removePacketWriterListener(PacketListener packetListener) {
        this.removePacketSendingListener(packetListener);
    }

    @Override
    public void sendPacket(Packet packet) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (packet == null) {
            throw new NullPointerException("Packet is null.");
        }
        this.packetWriter.sendPacket(packet);
    }

    void setAvailableCompressionMethods(Collection<String> collection) {
        this.compressionMethods = collection;
    }

    @Override
    public void setRosterStorage(RosterStorage rosterStorage) throws IllegalStateException {
        if (this.roster != null) {
            throw new IllegalStateException("Roster is already initialized");
        }
        this.rosterStorage = rosterStorage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void shutdown(Presence presence) {
        if (this.packetWriter != null) {
            this.packetWriter.sendPacket(presence);
        }
        this.setWasAuthenticated(this.authenticated);
        this.authenticated = false;
        this.connected = false;
        if (this.packetReader != null) {
            this.packetReader.shutdown();
        }
        if (this.packetWriter != null) {
            this.packetWriter.shutdown();
        }
        try {
            Thread.sleep(150L);
        }
        catch (Exception exception) {}
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (Throwable throwable) {}
            this.reader = null;
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (Throwable throwable) {}
            this.writer = null;
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {}
        this.saslAuthentication.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void startStreamCompression() throws Exception {
        this.usingCompression = true;
        this.initReaderAndWriter();
        this.packetWriter.setWriter(this.writer);
        this.packetWriter.openStream();
        synchronized (this) {
            this.notify();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void startTLSReceived(boolean bl) {
        if (bl && this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.packetReader.notifyConnectionError(new IllegalStateException("TLS required by server but not allowed by connection configuration"));
            return;
        } else {
            if (this.config.getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) return;
            try {
                this.writer.write("<starttls xmlns=\"urn:ietf:params:xml:ns:xmpp-tls\"/>");
                this.writer.flush();
                return;
            }
            catch (IOException iOException) {
                this.packetReader.notifyConnectionError(iOException);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void streamCompressionDenied() {
        synchronized (this) {
            this.notify();
            return;
        }
    }
}

