/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.NonSASLAuthentication;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.UserAuthentication;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Bind;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Session;
import org.jivesoftware.smack.sasl.SASLAnonymous;
import org.jivesoftware.smack.sasl.SASLCramMD5Mechanism;
import org.jivesoftware.smack.sasl.SASLDigestMD5Mechanism;
import org.jivesoftware.smack.sasl.SASLExternalMechanism;
import org.jivesoftware.smack.sasl.SASLGSSAPIMechanism;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.sasl.SASLPlainMechanism;

public class SASLAuthentication
implements UserAuthentication {
    private static Map<String, Class> implementedMechanisms = new HashMap<String, Class>();
    private static List<String> mechanismsPreferences = new ArrayList<String>();
    private Connection connection;
    private SASLMechanism currentMechanism = null;
    private String errorCondition;
    private boolean resourceBinded;
    private boolean saslFailed;
    private boolean saslNegotiated;
    private Collection<String> serverMechanisms = new ArrayList<String>();
    private boolean sessionSupported;

    static {
        SASLAuthentication.registerSASLMechanism("EXTERNAL", SASLExternalMechanism.class);
        SASLAuthentication.registerSASLMechanism("GSSAPI", SASLGSSAPIMechanism.class);
        SASLAuthentication.registerSASLMechanism("DIGEST-MD5", SASLDigestMD5Mechanism.class);
        SASLAuthentication.registerSASLMechanism("CRAM-MD5", SASLCramMD5Mechanism.class);
        SASLAuthentication.registerSASLMechanism("PLAIN", SASLPlainMechanism.class);
        SASLAuthentication.registerSASLMechanism("ANONYMOUS", SASLAnonymous.class);
        SASLAuthentication.supportSASLMechanism("DIGEST-MD5", 0);
        SASLAuthentication.supportSASLMechanism("PLAIN", 1);
        SASLAuthentication.supportSASLMechanism("ANONYMOUS", 2);
    }

    SASLAuthentication(Connection connection) {
        this.connection = connection;
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String bindResourceAndEstablishSession(String object) throws XMPPException {
        synchronized (this) {
            long l2 = System.currentTimeMillis() + 30000L;
            while (true) {
                if (this.resourceBinded || System.currentTimeMillis() >= l2) {
                    // MONITOREXIT @DISABLED, blocks:[3, 5, 11] lbl5 : MonitorExitStatement: MONITOREXIT : this
                    if (this.resourceBinded) break;
                    throw new XMPPException("Resource binding not offered by server");
                }
                try {
                    this.wait(Math.abs(System.currentTimeMillis() - l2));
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        Object object2 = new Bind();
        ((Bind)object2).setResource((String)object);
        object = this.connection.createPacketCollector(new PacketIDFilter(((Packet)object2).getPacketID()));
        this.connection.sendPacket((Packet)object2);
        object2 = (Bind)((PacketCollector)object).nextResult(SmackConfiguration.getPacketReplyTimeout());
        ((PacketCollector)object).cancel();
        if (object2 == null) {
            throw new XMPPException("No response from the server.");
        }
        if (((IQ)object2).getType() == IQ.Type.ERROR) {
            throw new XMPPException(((Packet)object2).getError());
        }
        object = ((Bind)object2).getJid();
        if (!this.sessionSupported) {
            throw new XMPPException("Session establishment not offered by server");
        }
        IQ iQ = new Session();
        object2 = this.connection.createPacketCollector(new PacketIDFilter(iQ.getPacketID()));
        this.connection.sendPacket(iQ);
        iQ = (IQ)((PacketCollector)object2).nextResult(SmackConfiguration.getPacketReplyTimeout());
        ((PacketCollector)object2).cancel();
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        return object;
    }

    public static List<Class> getRegisterSASLMechanisms() {
        ArrayList<Class> arrayList = new ArrayList<Class>();
        Iterator<String> iterator = mechanismsPreferences.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            arrayList.add(implementedMechanisms.get(string2));
        }
        return arrayList;
    }

    public static void registerSASLMechanism(String string2, Class clazz) {
        implementedMechanisms.put(string2, clazz);
    }

    public static void supportSASLMechanism(String string2) {
        mechanismsPreferences.add(0, string2);
    }

    public static void supportSASLMechanism(String string2, int n2) {
        mechanismsPreferences.add(n2, string2);
    }

    public static void unregisterSASLMechanism(String string2) {
        implementedMechanisms.remove(string2);
        mechanismsPreferences.remove(string2);
    }

    public static void unsupportSASLMechanism(String string2) {
        mechanismsPreferences.remove(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public String authenticate(String string2, String string3, String string4) throws XMPPException {
        block13: {
            String string5;
            block14: {
                block12: {
                    boolean bl;
                    string5 = null;
                    for (String string6 : mechanismsPreferences) {
                        if (!implementedMechanisms.containsKey(string6) || !this.serverMechanisms.contains(string6)) continue;
                        string5 = string6;
                        break;
                    }
                    if (string5 == null) return new NonSASLAuthentication(this.connection).authenticate(string2, string3, string4);
                    this.currentMechanism = (SASLMechanism)implementedMechanisms.get(string5).getConstructor(SASLAuthentication.class).newInstance(this);
                    this.currentMechanism.authenticate(string2, this.connection.getServiceName(), string3);
                    // MONITORENTER : this
                    if (this.saslNegotiated || (bl = this.saslFailed)) break block12;
                    try {
                        this.wait(30000L);
                        // MONITOREXIT : this
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!this.saslFailed) break block13;
                if (this.errorCondition == null) break block14;
                throw new XMPPException("SASL authentication " + string5 + " failed: " + this.errorCondition);
            }
            try {
                throw new XMPPException("SASL authentication failed using mechanism " + string5);
            }
            catch (XMPPException xMPPException) {
                throw xMPPException;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return new NonSASLAuthentication(this.connection).authenticate(string2, string3, string4);
            }
        }
        if (!this.saslNegotiated) return new NonSASLAuthentication(this.connection).authenticate(string2, string3, string4);
        return this.bindResourceAndEstablishSession(string4);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public String authenticate(String string2, String string3, CallbackHandler callbackHandler) throws XMPPException {
        String string4 = null;
        for (String string5 : mechanismsPreferences) {
            if (!implementedMechanisms.containsKey(string5) || !this.serverMechanisms.contains(string5)) continue;
            string4 = string5;
            break;
        }
        if (string4 == null) throw new XMPPException("SASL Authentication failed. No known authentication mechanisims.");
        this.currentMechanism = (SASLMechanism)implementedMechanisms.get(string4).getConstructor(SASLAuthentication.class).newInstance(this);
        this.currentMechanism.authenticate(string2, this.connection.getHost(), callbackHandler);
        // MONITORENTER : this
        long l2 = System.currentTimeMillis();
        while (true) {
            if (this.saslNegotiated || this.saslFailed || System.currentTimeMillis() >= l2) {
                // MONITOREXIT : this
                if (this.saslFailed) {
                    if (this.errorCondition == null) break;
                    throw new XMPPException("SASL authentication " + string4 + " failed: " + this.errorCondition);
                }
            }
            try {
                this.wait(Math.abs(System.currentTimeMillis() - l2));
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            throw new XMPPException("SASL authentication failed using mechanism " + string4);
        }
        catch (XMPPException xMPPException) {
            throw xMPPException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new XMPPException("SASL authentication failed");
        }
        if (!this.saslNegotiated) throw new XMPPException("SASL authentication failed");
        return this.bindResourceAndEstablishSession(string3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String authenticateAnonymously() throws XMPPException {
        block10: {
            try {
                this.currentMechanism = new SASLAnonymous(this);
                this.currentMechanism.authenticate(null, null, "");
                synchronized (this) {
                    boolean bl;
                    if (this.saslNegotiated || (bl = this.saslFailed)) break block10;
                }
            }
            catch (IOException iOException) {
                return new NonSASLAuthentication(this.connection).authenticateAnonymously();
            }
            {
                try {
                    this.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.saslFailed) {
            if (this.errorCondition == null) throw new XMPPException("SASL authentication failed");
            throw new XMPPException("SASL authentication failed: " + this.errorCondition);
        }
        if (!this.saslNegotiated) return new NonSASLAuthentication(this.connection).authenticateAnonymously();
        return this.bindResourceAndEstablishSession(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void authenticated() {
        synchronized (this) {
            this.saslNegotiated = true;
            this.notify();
            return;
        }
    }

    void authenticationFailed() {
        this.authenticationFailed(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void authenticationFailed(String string2) {
        synchronized (this) {
            this.saslFailed = true;
            this.errorCondition = string2;
            this.notify();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void bindingRequired() {
        synchronized (this) {
            this.resourceBinded = true;
            this.notify();
            return;
        }
    }

    void challengeReceived(String string2) throws IOException {
        this.currentMechanism.challengeReceived(string2);
    }

    public boolean hasAnonymousAuthentication() {
        return this.serverMechanisms.contains("ANONYMOUS");
    }

    public boolean hasNonAnonymousAuthentication() {
        return !this.serverMechanisms.isEmpty() && (this.serverMechanisms.size() != 1 || !this.hasAnonymousAuthentication());
    }

    protected void init() {
        this.saslNegotiated = false;
        this.saslFailed = false;
        this.resourceBinded = false;
        this.sessionSupported = false;
    }

    public boolean isAuthenticated() {
        return this.saslNegotiated;
    }

    public void send(Packet packet) {
        this.connection.sendPacket(packet);
    }

    void sessionsSupported() {
        this.sessionSupported = true;
    }

    void setAvailableSASLMethods(Collection<String> collection) {
        this.serverMechanisms = collection;
    }
}

