/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.util.StringUtils;

public class RosterGroup {
    private Connection connection;
    private final List<RosterEntry> entries;
    private String name;

    RosterGroup(String string2, Connection connection) {
        this.name = string2;
        this.connection = connection;
        this.entries = new ArrayList<RosterEntry>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void addEntry(RosterEntry object) throws XMPPException {
        PacketCollector packetCollector = null;
        List<RosterEntry> list = this.entries;
        // MONITORENTER : list
        if (!this.entries.contains(object)) {
            RosterPacket rosterPacket = new RosterPacket();
            rosterPacket.setType(IQ.Type.SET);
            object = RosterEntry.toRosterItem((RosterEntry)object);
            ((RosterPacket.Item)object).addGroupName(this.getName());
            rosterPacket.addRosterItem((RosterPacket.Item)object);
            packetCollector = this.connection.createPacketCollector(new PacketIDFilter(rosterPacket.getPacketID()));
            this.connection.sendPacket(rosterPacket);
        }
        // MONITOREXIT : list
        if (packetCollector == null) return;
        object = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (object == null) {
            throw new XMPPException("No response from the server.");
        }
        if (((IQ)object).getType() != IQ.Type.ERROR) return;
        throw new XMPPException(((Packet)object).getError());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addEntryLocal(RosterEntry rosterEntry) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            this.entries.remove(rosterEntry);
            this.entries.add(rosterEntry);
            return;
        }
    }

    public boolean contains(String string2) {
        return this.getEntry(string2) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(RosterEntry rosterEntry) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            return this.entries.contains(rosterEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<RosterEntry> getEntries() {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            return Collections.unmodifiableList(new ArrayList<RosterEntry>(this.entries));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RosterEntry getEntry(String object) {
        if (object == null) {
            return null;
        }
        String string2 = StringUtils.parseBareAddress((String)object).toLowerCase();
        object = this.entries;
        synchronized (object) {
            RosterEntry rosterEntry;
            Iterator<RosterEntry> iterator = this.entries.iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!(rosterEntry = iterator.next()).getUser().equals(string2));
            return rosterEntry;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getEntryCount() {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            return this.entries.size();
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeEntry(RosterEntry object) throws XMPPException {
        PacketCollector packetCollector = null;
        List<RosterEntry> list = this.entries;
        // MONITORENTER : list
        if (this.entries.contains(object)) {
            RosterPacket rosterPacket = new RosterPacket();
            rosterPacket.setType(IQ.Type.SET);
            object = RosterEntry.toRosterItem((RosterEntry)object);
            ((RosterPacket.Item)object).removeGroupName(this.getName());
            rosterPacket.addRosterItem((RosterPacket.Item)object);
            packetCollector = this.connection.createPacketCollector(new PacketIDFilter(rosterPacket.getPacketID()));
            this.connection.sendPacket(rosterPacket);
        }
        // MONITOREXIT : list
        if (packetCollector == null) return;
        object = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        packetCollector.cancel();
        if (object == null) {
            throw new XMPPException("No response from the server.");
        }
        if (((IQ)object).getType() != IQ.Type.ERROR) return;
        throw new XMPPException(((Packet)object).getError());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void removeEntryLocal(RosterEntry rosterEntry) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            if (this.entries.contains(rosterEntry)) {
                this.entries.remove(rosterEntry);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setName(String string2) {
        List<RosterEntry> list = this.entries;
        synchronized (list) {
            Iterator<RosterEntry> iterator = this.entries.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                RosterPacket rosterPacket = new RosterPacket();
                rosterPacket.setType(IQ.Type.SET);
                object = RosterEntry.toRosterItem((RosterEntry)object);
                ((RosterPacket.Item)object).removeGroupName(this.name);
                ((RosterPacket.Item)object).addGroupName(string2);
                rosterPacket.addRosterItem((RosterPacket.Item)object);
                this.connection.sendPacket(rosterPacket);
            }
            return;
        }
    }
}

