/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.RosterPacket;

public class RosterEntry {
    private final Connection connection;
    private String name;
    private final Roster roster;
    private RosterPacket.ItemStatus status;
    private RosterPacket.ItemType type;
    private String user;

    RosterEntry(String string2, String string3, RosterPacket.ItemType itemType, RosterPacket.ItemStatus itemStatus, Roster roster, Connection connection) {
        this.user = string2;
        this.name = string3;
        this.type = itemType;
        this.status = itemStatus;
        this.roster = roster;
        this.connection = connection;
    }

    static RosterPacket.Item toRosterItem(RosterEntry object) {
        RosterPacket.Item item = new RosterPacket.Item(((RosterEntry)object).getUser(), ((RosterEntry)object).getName());
        item.setItemType(((RosterEntry)object).getType());
        item.setItemStatus(((RosterEntry)object).getStatus());
        object = ((RosterEntry)object).getGroups().iterator();
        while (object.hasNext()) {
            item.addGroupName(((RosterGroup)object.next()).getName());
        }
        return item;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof RosterEntry) {
            return this.user.equals(((RosterEntry)object).getUser());
        }
        return false;
    }

    public Collection<RosterGroup> getGroups() {
        ArrayList<RosterGroup> arrayList = new ArrayList<RosterGroup>();
        Iterator<RosterGroup> iterator = this.roster.getGroups().iterator();
        while (iterator.hasNext()) {
            RosterGroup rosterGroup = iterator.next();
            if (!rosterGroup.contains(this)) continue;
            arrayList.add(rosterGroup);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public String getName() {
        return this.name;
    }

    public RosterPacket.ItemStatus getStatus() {
        return this.status;
    }

    public RosterPacket.ItemType getType() {
        return this.type;
    }

    public String getUser() {
        return this.user;
    }

    public void setName(String object) {
        if (object != null && ((String)object).equals(this.name)) {
            return;
        }
        this.name = object;
        object = new RosterPacket();
        ((IQ)object).setType(IQ.Type.SET);
        ((RosterPacket)object).addRosterItem(RosterEntry.toRosterItem(this));
        this.connection.sendPacket((Packet)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null) {
            stringBuilder.append(this.name).append(": ");
        }
        stringBuilder.append(this.user);
        Object object = this.getGroups();
        if (object.isEmpty()) return stringBuilder.toString();
        stringBuilder.append(" [");
        object = object.iterator();
        stringBuilder.append(((RosterGroup)object.next()).getName());
        while (true) {
            if (!object.hasNext()) {
                stringBuilder.append("]");
                return stringBuilder.toString();
            }
            stringBuilder.append(", ");
            stringBuilder.append(((RosterGroup)object.next()).getName());
        }
    }

    void updateState(String string2, RosterPacket.ItemType itemType, RosterPacket.ItemStatus itemStatus) {
        this.name = string2;
        this.type = itemType;
        this.status = itemStatus;
    }
}

