/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.RosterStorage;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.RosterPacket;
import org.jivesoftware.smack.util.StringUtils;

public class Roster {
    private static SubscriptionMode defaultSubscriptionMode = SubscriptionMode.accept_all;
    private Connection connection;
    private final Map<String, RosterEntry> entries;
    private final Map<String, RosterGroup> groups;
    private RosterStorage persistentStorage;
    private Map<String, Map<String, Presence>> presenceMap;
    private PresencePacketListener presencePacketListener;
    private String requestPacketId;
    boolean rosterInitialized = false;
    private final List<RosterListener> rosterListeners;
    private SubscriptionMode subscriptionMode = Roster.getDefaultSubscriptionMode();
    private final List<RosterEntry> unfiledEntries;

    Roster(Connection connection) {
        this.connection = connection;
        if (!connection.getConfiguration().isRosterVersioningAvailable()) {
            this.persistentStorage = null;
        }
        this.groups = new ConcurrentHashMap<String, RosterGroup>();
        this.unfiledEntries = new CopyOnWriteArrayList<RosterEntry>();
        this.entries = new ConcurrentHashMap<String, RosterEntry>();
        this.rosterListeners = new CopyOnWriteArrayList<RosterListener>();
        this.presenceMap = new ConcurrentHashMap<String, Map<String, Presence>>();
        PacketTypeFilter packetTypeFilter = new PacketTypeFilter(RosterPacket.class);
        connection.addPacketListener(new RosterPacketListener(), packetTypeFilter);
        packetTypeFilter = new PacketTypeFilter(Presence.class);
        this.presencePacketListener = new PresencePacketListener();
        connection.addPacketListener(this.presencePacketListener, packetTypeFilter);
        connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionClosed() {
                Roster.this.setOfflinePresences();
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
                Roster.this.setOfflinePresences();
            }

            @Override
            public void reconnectingIn(int n2) {
            }

            @Override
            public void reconnectionFailed(Exception exception) {
            }

            @Override
            public void reconnectionSuccessful() {
            }
        });
    }

    Roster(Connection connection, RosterStorage rosterStorage) {
        this(connection);
        this.persistentStorage = rosterStorage;
    }

    private void fireRosterChangedEvent(Collection<String> collection, Collection<String> collection2, Collection<String> collection3) {
        Iterator<RosterListener> iterator = this.rosterListeners.iterator();
        while (iterator.hasNext()) {
            RosterListener rosterListener = iterator.next();
            if (!collection.isEmpty()) {
                rosterListener.entriesAdded(collection);
            }
            if (!collection2.isEmpty()) {
                rosterListener.entriesUpdated(collection2);
            }
            if (collection3.isEmpty()) continue;
            rosterListener.entriesDeleted(collection3);
        }
        return;
    }

    private void fireRosterPresenceEvent(Presence presence) {
        Iterator<RosterListener> iterator = this.rosterListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().presenceChanged(presence);
        }
        return;
    }

    public static SubscriptionMode getDefaultSubscriptionMode() {
        return defaultSubscriptionMode;
    }

    private String getPresenceMapKey(String string2) {
        if (string2 == null) {
            return null;
        }
        String string3 = string2;
        if (!this.contains(string2)) {
            string3 = StringUtils.parseBareAddress(string2);
        }
        return string3.toLowerCase();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void insertRosterItem(RosterPacket.Item object, Collection<String> object2, Collection<String> object3, Collection<String> object4) {
        RosterEntry rosterEntry;
        block22: {
            rosterEntry = new RosterEntry(((RosterPacket.Item)object).getUser(), ((RosterPacket.Item)object).getName(), ((RosterPacket.Item)object).getItemType(), ((RosterPacket.Item)object).getItemStatus(), this, this.connection);
            if (RosterPacket.ItemType.remove.equals((Object)((RosterPacket.Item)object).getItemType())) {
                if (this.entries.containsKey(((RosterPacket.Item)object).getUser())) {
                    this.entries.remove(((RosterPacket.Item)object).getUser());
                }
                if (this.unfiledEntries.contains(rosterEntry)) {
                    this.unfiledEntries.remove(rosterEntry);
                }
                object2 = String.valueOf(StringUtils.parseName(((RosterPacket.Item)object).getUser())) + "@" + StringUtils.parseServer(((RosterPacket.Item)object).getUser());
                this.presenceMap.remove(object2);
                if (object4 != null) {
                    object4.add(((RosterPacket.Item)object).getUser());
                }
            } else {
                if (!this.entries.containsKey(((RosterPacket.Item)object).getUser())) {
                    this.entries.put(((RosterPacket.Item)object).getUser(), rosterEntry);
                    if (object2 != null) {
                        object2.add(((RosterPacket.Item)object).getUser());
                    }
                } else {
                    this.entries.put(((RosterPacket.Item)object).getUser(), rosterEntry);
                    if (object3 != null) {
                        object3.add(((RosterPacket.Item)object).getUser());
                    }
                }
                if (!((RosterPacket.Item)object).getGroupNames().isEmpty()) {
                    this.unfiledEntries.remove(rosterEntry);
                } else if (!this.unfiledEntries.contains(rosterEntry)) {
                    this.unfiledEntries.add(rosterEntry);
                }
            }
            object3 = new ArrayList<String>();
            object2 = this.getGroups().iterator();
            while (true) {
                if (!object2.hasNext()) {
                    if (!RosterPacket.ItemType.remove.equals((Object)((RosterPacket.Item)object).getItemType())) {
                        break;
                    }
                    break block22;
                }
                object4 = object2.next();
                if (!((RosterGroup)object4).contains(rosterEntry)) continue;
                object3.add(((RosterGroup)object4).getName());
            }
            object4 = new ArrayList<String>();
            Iterator<String> iterator = ((RosterPacket.Item)object).getGroupNames().iterator();
            while (true) {
                if (!iterator.hasNext()) break;
                String string2 = iterator.next();
                object4.add(string2);
                object = object2 = this.getGroup(string2);
                if (object2 == null) {
                    object = this.createGroup(string2);
                    this.groups.put(string2, (RosterGroup)object);
                }
                ((RosterGroup)object).addEntryLocal(rosterEntry);
            }
            object = object4.iterator();
            while (object.hasNext()) {
                object3.remove((String)object.next());
            }
        }
        object = object3.iterator();
        while (true) {
            if (!object.hasNext()) break;
            object2 = (String)object.next();
            object3 = this.getGroup((String)object2);
            ((RosterGroup)object3).removeEntryLocal(rosterEntry);
            if (((RosterGroup)object3).getEntryCount() != 0) continue;
            this.groups.remove(object2);
        }
        object = this.getGroups().iterator();
        while (object.hasNext()) {
            object2 = (RosterGroup)object.next();
            if (((RosterGroup)object2).getEntryCount() != 0) continue;
            this.groups.remove(((RosterGroup)object2).getName());
        }
        return;
    }

    private void insertRosterItems(List<RosterPacket.Item> object) {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        object = object.iterator();
        while (true) {
            if (!object.hasNext()) {
                this.fireRosterChangedEvent(arrayList, arrayList2, arrayList3);
                return;
            }
            this.insertRosterItem((RosterPacket.Item)object.next(), arrayList, arrayList2, arrayList3);
        }
    }

    public static void setDefaultSubscriptionMode(SubscriptionMode subscriptionMode) {
        defaultSubscriptionMode = subscriptionMode;
    }

    /*
     * Unable to fully structure code
     */
    private void setOfflinePresences() {
        var1_1 = this.presenceMap.keySet().iterator();
        block0: while (true) {
            if (!var1_1.hasNext()) {
                return;
            }
            var2_2 = var1_1.next();
            var3_3 = this.presenceMap.get(var2_2);
            if (var3_3 == null) continue;
            var3_3 = var3_3.keySet().iterator();
            while (true) {
                if (var3_3.hasNext()) ** break;
                continue block0;
                var4_4 = (String)var3_3.next();
                var5_5 = new Presence(Presence.Type.unavailable);
                var5_5.setFrom(String.valueOf(var2_2) + "/" + var4_4);
                this.presencePacketListener.processPacket(var5_5);
            }
            break;
        }
    }

    public void addRosterListener(RosterListener rosterListener) {
        if (!this.rosterListeners.contains(rosterListener)) {
            this.rosterListeners.add(rosterListener);
        }
    }

    void cleanup() {
        this.rosterListeners.clear();
    }

    public boolean contains(String string2) {
        return this.getEntry(string2) != null;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public void createEntry(String string2, String object, String[] object2) throws XMPPException {
        RosterPacket rosterPacket = new RosterPacket();
        rosterPacket.setType(IQ.Type.SET);
        object = new RosterPacket.Item(string2, (String)object);
        boolean bl = true;
        while (true) {
            int n2;
            block8: {
                block7: {
                    int n3;
                    block6: {
                        if (!bl || (bl = false)) break block6;
                        if (object2 == null) break block7;
                        n3 = ((Object)object2).length;
                        n2 = 0;
                    }
                    if (n2 < n3) break block8;
                }
                rosterPacket.addRosterItem((RosterPacket.Item)object);
                object = this.connection.createPacketCollector(new PacketIDFilter(rosterPacket.getPacketID()));
                this.connection.sendPacket(rosterPacket);
                object2 = (IQ)((PacketCollector)object).nextResult(SmackConfiguration.getPacketReplyTimeout());
                ((PacketCollector)object).cancel();
                if (object2 != null) break;
                throw new XMPPException("No response from the server.");
            }
            Object object3 = object2[n2];
            if (object3 != null && ((String)object3).trim().length() > 0) {
                ((RosterPacket.Item)object).addGroupName((String)object3);
            }
            ++n2;
        }
        if (((IQ)object2).getType() == IQ.Type.ERROR) {
            throw new XMPPException(((Packet)object2).getError());
        }
        object = new Presence(Presence.Type.subscribe);
        ((Packet)object).setTo(string2);
        this.connection.sendPacket((Packet)object);
    }

    public RosterGroup createGroup(String string2) {
        if (this.groups.containsKey(string2)) {
            throw new IllegalArgumentException("Group with name " + string2 + " alread exists.");
        }
        RosterGroup rosterGroup = new RosterGroup(string2, this.connection);
        this.groups.put(string2, rosterGroup);
        return rosterGroup;
    }

    public Collection<RosterEntry> getEntries() {
        HashSet<RosterEntry> hashSet = new HashSet<RosterEntry>();
        Iterator<RosterGroup> iterator = this.getGroups().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                hashSet.addAll(this.unfiledEntries);
                return Collections.unmodifiableCollection(hashSet);
            }
            hashSet.addAll(iterator.next().getEntries());
        }
    }

    public RosterEntry getEntry(String string2) {
        if (string2 == null) {
            return null;
        }
        return this.entries.get(string2.toLowerCase());
    }

    public int getEntryCount() {
        return this.getEntries().size();
    }

    public RosterGroup getGroup(String string2) {
        return this.groups.get(string2);
    }

    public int getGroupCount() {
        return this.groups.size();
    }

    public Collection<RosterGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Presence getPresence(String string2) {
        Object object = this.getPresenceMapKey(StringUtils.parseBareAddress(string2));
        Map<String, Presence> map = this.presenceMap.get(object);
        if (map == null) {
            object = new Presence(Presence.Type.unavailable);
            ((Packet)object).setFrom(string2);
            return object;
        }
        object = null;
        Iterator<String> iterator = map.keySet().iterator();
        while (true) {
            Presence.Mode mode;
            Presence.Mode mode2;
            if (!iterator.hasNext()) {
                if (object != null) break;
                object = new Presence(Presence.Type.unavailable);
                ((Packet)object).setFrom(string2);
                return object;
            }
            Presence presence = map.get(iterator.next());
            if (!presence.isAvailable()) continue;
            if (object == null || presence.getPriority() > ((Presence)object).getPriority()) {
                object = presence;
                continue;
            }
            if (presence.getPriority() != ((Presence)object).getPriority()) continue;
            Presence.Mode mode3 = mode2 = presence.getMode();
            if (mode2 == null) {
                mode3 = Presence.Mode.available;
            }
            mode2 = mode = ((Presence)object).getMode();
            if (mode == null) {
                mode2 = Presence.Mode.available;
            }
            if (mode3.compareTo(mode2) >= 0) continue;
            object = presence;
        }
        return object;
    }

    public Presence getPresenceResource(String string2) {
        Object object = this.getPresenceMapKey(string2);
        Object object2 = StringUtils.parseResource(string2);
        if ((object = this.presenceMap.get(object)) == null) {
            object2 = new Presence(Presence.Type.unavailable);
            ((Packet)object2).setFrom(string2);
            return object2;
        }
        if ((object2 = (Presence)object.get(object2)) == null) {
            object2 = new Presence(Presence.Type.unavailable);
            ((Packet)object2).setFrom(string2);
            return object2;
        }
        return object2;
    }

    public Iterator<Presence> getPresences(String string2) {
        Object object = this.getPresenceMapKey(string2);
        Map<String, Presence> map = this.presenceMap.get(object);
        if (map == null) {
            object = new Presence(Presence.Type.unavailable);
            ((Packet)object).setFrom(string2);
            return Arrays.asList(object).iterator();
        }
        object = new ArrayList();
        map = map.values().iterator();
        while (true) {
            if (!map.hasNext()) {
                if (object.isEmpty()) break;
                return object.iterator();
            }
            Presence presence = (Presence)map.next();
            if (!presence.isAvailable()) continue;
            object.add(presence);
        }
        object = new Presence(Presence.Type.unavailable);
        ((Packet)object).setFrom(string2);
        return Arrays.asList(object).iterator();
    }

    public SubscriptionMode getSubscriptionMode() {
        return this.subscriptionMode;
    }

    public Collection<RosterEntry> getUnfiledEntries() {
        return Collections.unmodifiableList(this.unfiledEntries);
    }

    public int getUnfiledEntryCount() {
        return this.unfiledEntries.size();
    }

    public void reload() {
        RosterPacket rosterPacket = new RosterPacket();
        if (this.persistentStorage != null) {
            rosterPacket.setVersion(this.persistentStorage.getRosterVersion());
        }
        this.requestPacketId = rosterPacket.getPacketID();
        PacketIDFilter packetIDFilter = new PacketIDFilter(this.requestPacketId);
        this.connection.addPacketListener(new RosterResultListener(), packetIDFilter);
        this.connection.sendPacket(rosterPacket);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeEntry(RosterEntry object) throws XMPPException {
        IQ iQ;
        block5: {
            block4: {
                if (!this.entries.containsKey(((RosterEntry)object).getUser())) break block4;
                iQ = new RosterPacket();
                iQ.setType(IQ.Type.SET);
                object = RosterEntry.toRosterItem((RosterEntry)object);
                ((RosterPacket.Item)object).setItemType(RosterPacket.ItemType.remove);
                ((RosterPacket)iQ).addRosterItem((RosterPacket.Item)object);
                object = this.connection.createPacketCollector(new PacketIDFilter(iQ.getPacketID()));
                this.connection.sendPacket(iQ);
                iQ = (IQ)((PacketCollector)object).nextResult(SmackConfiguration.getPacketReplyTimeout());
                ((PacketCollector)object).cancel();
                if (iQ == null) {
                    throw new XMPPException("No response from the server.");
                }
                if (iQ.getType() == IQ.Type.ERROR) break block5;
            }
            return;
        }
        throw new XMPPException(iQ.getError());
    }

    public void removeRosterListener(RosterListener rosterListener) {
        this.rosterListeners.remove(rosterListener);
    }

    public void setSubscriptionMode(SubscriptionMode subscriptionMode) {
        this.subscriptionMode = subscriptionMode;
    }

    private class PresencePacketListener
    implements PacketListener {
        private PresencePacketListener() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void processPacket(Packet map) {
            Presence presence = (Presence)((Object)map);
            String string2 = presence.getFrom();
            String string3 = Roster.this.getPresenceMapKey(string2);
            if (presence.getType() == Presence.Type.available) {
                if (Roster.this.presenceMap.get(string3) == null) {
                    map = new ConcurrentHashMap();
                    Roster.this.presenceMap.put(string3, map);
                } else {
                    map = (Map)Roster.this.presenceMap.get(string3);
                }
                map.remove("");
                map.put(StringUtils.parseResource(string2), presence);
                if ((RosterEntry)Roster.this.entries.get(string3) == null) return;
                Roster.this.fireRosterPresenceEvent(presence);
                return;
            }
            if (presence.getType() == Presence.Type.unavailable) {
                if ("".equals(StringUtils.parseResource(string2))) {
                    if (Roster.this.presenceMap.get(string3) == null) {
                        map = new ConcurrentHashMap<String, Presence>();
                        Roster.this.presenceMap.put(string3, map);
                    } else {
                        map = (Map)Roster.this.presenceMap.get(string3);
                    }
                    map.put("", presence);
                } else if (Roster.this.presenceMap.get(string3) != null) {
                    ((Map)Roster.this.presenceMap.get(string3)).put(StringUtils.parseResource(string2), presence);
                }
                if ((RosterEntry)Roster.this.entries.get(string3) == null) return;
                Roster.this.fireRosterPresenceEvent(presence);
                return;
            } else if (presence.getType() == Presence.Type.subscribe) {
                if (Roster.this.subscriptionMode == SubscriptionMode.accept_all) {
                    map = new Presence(Presence.Type.subscribed);
                    ((Packet)((Object)map)).setTo(presence.getFrom());
                    Roster.this.connection.sendPacket((Packet)((Object)map));
                    return;
                }
                if (Roster.this.subscriptionMode != SubscriptionMode.reject_all) return;
                map = new Presence(Presence.Type.unsubscribed);
                ((Packet)((Object)map)).setTo(presence.getFrom());
                Roster.this.connection.sendPacket((Packet)((Object)map));
                return;
            } else if (presence.getType() == Presence.Type.unsubscribe) {
                if (Roster.this.subscriptionMode == SubscriptionMode.manual) return;
                map = new Presence(Presence.Type.unsubscribed);
                ((Packet)((Object)map)).setTo(presence.getFrom());
                Roster.this.connection.sendPacket((Packet)((Object)map));
                return;
            } else {
                if (presence.getType() != Presence.Type.error || !"".equals(StringUtils.parseResource(string2))) return;
                if (!Roster.this.presenceMap.containsKey(string3)) {
                    map = new ConcurrentHashMap<String, Presence>();
                    Roster.this.presenceMap.put(string3, map);
                } else {
                    map = (Map)Roster.this.presenceMap.get(string3);
                    map.clear();
                }
                map.put("", presence);
                if ((RosterEntry)Roster.this.entries.get(string3) == null) return;
                Roster.this.fireRosterPresenceEvent(presence);
                return;
            }
        }
    }

    private class RosterPacketListener
    implements PacketListener {
        private RosterPacketListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void processPacket(Packet object) {
            ArrayList arrayList;
            ArrayList arrayList2;
            ArrayList arrayList3;
            block16: {
                Object object2;
                Object object3;
                Iterator<Object> iterator;
                block15: {
                    arrayList3 = new ArrayList();
                    arrayList2 = new ArrayList();
                    arrayList = new ArrayList();
                    iterator = null;
                    object3 = (RosterPacket)object;
                    object2 = new ArrayList<RosterPacket.Item>();
                    object = ((RosterPacket)object3).getRosterItems().iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            if (((RosterPacket)object3).getVersion() == null) {
                                Roster.this.persistentStorage = null;
                                object = iterator;
                            } else {
                                object = ((RosterPacket)object3).getVersion();
                            }
                            if (Roster.this.persistentStorage != null && !Roster.this.rosterInitialized) {
                                break;
                            }
                            break block15;
                        }
                        object2.add(object.next());
                    }
                    iterator = Roster.this.persistentStorage.getEntries().iterator();
                    while (iterator.hasNext()) {
                        object2.add((RosterPacket.Item)iterator.next());
                    }
                }
                iterator = object2.iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        if (Roster.this.persistentStorage != null) {
                            iterator = ((RosterPacket)object3).getRosterItems().iterator();
                            break;
                        }
                        break block16;
                    }
                    object2 = (RosterPacket.Item)iterator.next();
                    Roster.this.insertRosterItem((RosterPacket.Item)object2, arrayList3, arrayList2, arrayList);
                }
                while (iterator.hasNext()) {
                    object3 = (RosterPacket.Item)iterator.next();
                    if (((RosterPacket.Item)object3).getItemType().equals((Object)RosterPacket.ItemType.remove)) {
                        Roster.this.persistentStorage.removeEntry(((RosterPacket.Item)object3).getUser());
                        continue;
                    }
                    Roster.this.persistentStorage.addEntry((RosterPacket.Item)object3, (String)object);
                }
            }
            object = Roster.this;
            synchronized (object) {
                Roster.this.rosterInitialized = true;
                Roster.this.notifyAll();
            }
            Roster.this.fireRosterChangedEvent(arrayList3, arrayList2, arrayList);
        }
    }

    private class RosterResultListener
    implements PacketListener {
        private RosterResultListener() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void processPacket(Packet arrayList) {
            if (arrayList instanceof IQ && ((IQ)((Object)(arrayList = (IQ)((Object)arrayList)))).getType().equals(IQ.Type.RESULT) && ((Packet)((Object)arrayList)).getExtensions().isEmpty()) {
                arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                ArrayList arrayList3 = new ArrayList();
                if (Roster.this.persistentStorage != null) {
                    Object object = Roster.this.persistentStorage.getEntries().iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            object = Roster.this;
                            synchronized (object) {
                                Roster.this.rosterInitialized = true;
                                Roster.this.notifyAll();
                            }
                            Roster.this.fireRosterChangedEvent(arrayList, arrayList2, arrayList3);
                            break;
                        }
                        RosterPacket.Item item = object.next();
                        Roster.this.insertRosterItem(item, arrayList, arrayList2, arrayList3);
                    }
                }
            }
            Roster.this.connection.removePacketListener(this);
        }
    }

    public static enum SubscriptionMode {
        accept_all,
        reject_all,
        manual;

    }
}

