/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Iterator;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.StreamError;

public class ReconnectionManager
implements ConnectionListener {
    private Connection connection;
    boolean done = false;

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                connection.addConnectionListener(new ReconnectionManager(connection, null));
            }
        });
    }

    private ReconnectionManager(Connection connection) {
        this.connection = connection;
    }

    /* synthetic */ ReconnectionManager(Connection connection, ReconnectionManager reconnectionManager) {
        this(connection);
    }

    private boolean isReconnectionAllowed() {
        return !this.done && !this.connection.isConnected() && this.connection.isReconnectionAllowed();
    }

    @Override
    public void connectionClosed() {
        this.done = true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void connectionClosedOnError(Exception object) {
        this.done = false;
        if (object instanceof XMPPException && (object = ((XMPPException)object).getStreamError()) != null && "conflict".equals(((StreamError)object).getCode()) || !this.isReconnectionAllowed()) {
            return;
        }
        this.reconnect();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void notifyAttemptToReconnectIn(int n2) {
        if (!this.isReconnectionAllowed()) return;
        Iterator<ConnectionListener> iterator = this.connection.connectionListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().reconnectingIn(n2);
        }
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void notifyReconnectionFailed(Exception exception) {
        if (!this.isReconnectionAllowed()) return;
        Iterator<ConnectionListener> iterator = this.connection.connectionListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().reconnectionFailed(exception);
        }
        return;
    }

    protected void reconnect() {
        if (this.isReconnectionAllowed()) {
            Thread thread = new Thread(){
                private int attempts = 0;

                private int timeDelay() {
                    if (this.attempts > 13) {
                        return 300;
                    }
                    if (this.attempts > 7) {
                        return 60;
                    }
                    return 10;
                }

                @Override
                public void run() {
                    block5: while (ReconnectionManager.this.isReconnectionAllowed()) {
                        int n2 = this.timeDelay();
                        while (true) {
                            if (!ReconnectionManager.this.isReconnectionAllowed() || n2 <= 0) {
                                try {
                                    if (!ReconnectionManager.this.isReconnectionAllowed()) continue block5;
                                    ReconnectionManager.this.connection.connect();
                                }
                                catch (XMPPException xMPPException) {
                                    ReconnectionManager.this.notifyReconnectionFailed(xMPPException);
                                }
                                continue block5;
                            }
                            int n3 = n2--;
                            try {
                                Thread.sleep(1000L);
                                n3 = n2;
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                                ReconnectionManager.this.notifyReconnectionFailed(interruptedException);
                                n2 = n3;
                                continue;
                            }
                            ReconnectionManager.this.notifyAttemptToReconnectIn(n2);
                            continue;
                            break;
                        }
                        break;
                    }
                    return;
                }
            };
            thread.setName("Smack Reconnection Manager");
            thread.setDaemon(true);
            thread.start();
        }
    }

    @Override
    public void reconnectingIn(int n2) {
    }

    @Override
    public void reconnectionFailed(Exception exception) {
    }

    @Override
    public void reconnectionSuccessful() {
    }
}

