/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.PrivacyList;
import org.jivesoftware.smack.PrivacyListListener;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.IQTypeFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Privacy;
import org.jivesoftware.smack.packet.PrivacyItem;

public class PrivacyListManager {
    private static Map<Connection, PrivacyListManager> instances = new Hashtable<Connection, PrivacyListManager>();
    private Connection connection;
    private final List<PrivacyListListener> listeners = new ArrayList<PrivacyListListener>();
    PacketFilter packetFilter = new AndFilter(new IQTypeFilter(IQ.Type.SET), new PacketExtensionFilter("query", "jabber:iq:privacy"));

    static {
        Connection.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(Connection connection) {
                new PrivacyListManager(connection, null);
            }
        });
    }

    private PrivacyListManager(Connection connection) {
        this.connection = connection;
        this.init();
    }

    /* synthetic */ PrivacyListManager(Connection connection, PrivacyListManager privacyListManager) {
        this(connection);
    }

    public static PrivacyListManager getInstanceFor(Connection connection) {
        return instances.get(connection);
    }

    private List<PrivacyItem> getPrivacyListItems(String string2) throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string2, new ArrayList<PrivacyItem>());
        return this.getRequest(privacy).getPrivacyList(string2);
    }

    private Privacy getPrivacyWithListNames() throws XMPPException {
        return this.getRequest(new Privacy());
    }

    private Privacy getRequest(Privacy privacy) throws XMPPException {
        privacy.setType(IQ.Type.GET);
        privacy.setFrom(this.getUser());
        Object object = new PacketIDFilter(privacy.getPacketID());
        object = this.connection.createPacketCollector((PacketFilter)object);
        this.connection.sendPacket(privacy);
        privacy = (Privacy)((PacketCollector)object).nextResult(SmackConfiguration.getPacketReplyTimeout());
        ((PacketCollector)object).cancel();
        if (privacy == null) {
            throw new XMPPException("No response from server.");
        }
        if (privacy.getError() != null) {
            throw new XMPPException(privacy.getError());
        }
        return privacy;
    }

    private String getUser() {
        return this.connection.getUser();
    }

    private void init() {
        instances.put(this.connection, this);
        this.connection.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionClosed() {
                instances.remove(PrivacyListManager.this.connection);
            }

            @Override
            public void connectionClosedOnError(Exception exception) {
            }

            @Override
            public void reconnectingIn(int n2) {
            }

            @Override
            public void reconnectionFailed(Exception exception) {
            }

            @Override
            public void reconnectionSuccessful() {
            }
        });
        this.connection.addPacketListener(new PacketListener(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void processPacket(Packet packet) {
                if (packet == null || packet.getError() != null) {
                    return;
                }
                Privacy privacy = (Privacy)packet;
                Object object = PrivacyListManager.this.listeners;
                synchronized (object) {
                    Iterator iterator = PrivacyListManager.this.listeners.iterator();
                    block4: while (true) {
                        if (!iterator.hasNext()) {
                            // MONITOREXIT @DISABLED, blocks:[3, 4, 7] lbl9 : MonitorExitStatement: MONITOREXIT : var2_3
                            object = new IQ(){

                                @Override
                                public String getChildElementXML() {
                                    return "";
                                }
                            };
                            ((IQ)object).setType(IQ.Type.RESULT);
                            ((Packet)object).setFrom(packet.getFrom());
                            ((Packet)object).setPacketID(packet.getPacketID());
                            PrivacyListManager.this.connection.sendPacket((Packet)object);
                            return;
                        }
                        PrivacyListListener privacyListListener = (PrivacyListListener)iterator.next();
                        Iterator<Map.Entry<String, List<PrivacyItem>>> iterator2 = privacy.getItemLists().entrySet().iterator();
                        while (true) {
                            if (!iterator2.hasNext()) continue block4;
                            Object object2 = iterator2.next();
                            String string2 = object2.getKey();
                            if ((object2 = object2.getValue()).isEmpty()) {
                                privacyListListener.updatedPrivacyList(string2);
                                continue;
                            }
                            privacyListListener.setPrivacyList(string2, (List<PrivacyItem>)object2);
                        }
                        break;
                    }
                }
            }
        }, this.packetFilter);
    }

    private Packet setRequest(Privacy packet) throws XMPPException {
        ((IQ)packet).setType(IQ.Type.SET);
        packet.setFrom(this.getUser());
        Object object = new PacketIDFilter(packet.getPacketID());
        object = this.connection.createPacketCollector((PacketFilter)object);
        this.connection.sendPacket(packet);
        packet = ((PacketCollector)object).nextResult(SmackConfiguration.getPacketReplyTimeout());
        ((PacketCollector)object).cancel();
        if (packet == null) {
            throw new XMPPException("No response from server.");
        }
        if (packet.getError() != null) {
            throw new XMPPException(packet.getError());
        }
        return packet;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addListener(PrivacyListListener privacyListListener) {
        List<PrivacyListListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(privacyListListener);
            return;
        }
    }

    public void createPrivacyList(String string2, List<PrivacyItem> list) throws XMPPException {
        this.updatePrivacyList(string2, list);
    }

    public void declineActiveList() throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setDeclineActiveList(true);
        this.setRequest(privacy);
    }

    public void declineDefaultList() throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setDeclineDefaultList(true);
        this.setRequest(privacy);
    }

    public void deletePrivacyList(String string2) throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string2, new ArrayList<PrivacyItem>());
        this.setRequest(privacy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PrivacyList getActiveList() throws XMPPException {
        boolean bl;
        Privacy privacy = this.getPrivacyWithListNames();
        String string2 = privacy.getActiveName();
        if (privacy.getActiveName() != null && privacy.getDefaultName() != null && privacy.getActiveName().equals(privacy.getDefaultName())) {
            bl = true;
            return new PrivacyList(true, bl, string2, this.getPrivacyListItems(string2));
        }
        bl = false;
        return new PrivacyList(true, bl, string2, this.getPrivacyListItems(string2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PrivacyList getDefaultList() throws XMPPException {
        boolean bl;
        Privacy privacy = this.getPrivacyWithListNames();
        String string2 = privacy.getDefaultName();
        if (privacy.getActiveName() != null && privacy.getDefaultName() != null && privacy.getActiveName().equals(privacy.getDefaultName())) {
            bl = true;
            return new PrivacyList(bl, true, string2, this.getPrivacyListItems(string2));
        }
        bl = false;
        return new PrivacyList(bl, true, string2, this.getPrivacyListItems(string2));
    }

    public PrivacyList getPrivacyList(String string2) throws XMPPException {
        return new PrivacyList(false, false, string2, this.getPrivacyListItems(string2));
    }

    public PrivacyList[] getPrivacyLists() throws XMPPException {
        Privacy privacy = this.getPrivacyWithListNames();
        Object object = privacy.getPrivacyListNames();
        PrivacyList[] privacyListArray = new PrivacyList[object.size()];
        int n2 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            privacyListArray[n2] = new PrivacyList(string2.equals(privacy.getActiveName()), string2.equals(privacy.getDefaultName()), string2, this.getPrivacyListItems(string2));
            ++n2;
        }
        return privacyListArray;
    }

    public void setActiveListName(String string2) throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setActiveName(string2);
        this.setRequest(privacy);
    }

    public void setDefaultListName(String string2) throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setDefaultName(string2);
        this.setRequest(privacy);
    }

    public void updatePrivacyList(String string2, List<PrivacyItem> list) throws XMPPException {
        Privacy privacy = new Privacy();
        privacy.setPrivacyList(string2, list);
        this.setRequest(privacy);
    }
}

