/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.IOException;
import java.io.Writer;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Packet;

class PacketWriter {
    private XMPPConnection connection;
    private boolean done;
    private Thread keepAliveThread;
    private long lastActive = System.currentTimeMillis();
    private final BlockingQueue<Packet> queue = new ArrayBlockingQueue<Packet>(500, true);
    private Writer writer;
    private Thread writerThread;

    protected PacketWriter(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        this.init();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Packet nextPacket() {
        Packet packet = null;
        while (!this.done && (packet = (Packet)this.queue.poll()) == null) {
            try {
                BlockingQueue<Packet> blockingQueue = this.queue;
                synchronized (blockingQueue) {
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            {
                this.queue.wait();
            }
        }
        return packet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writePackets(Thread object) {
        try {
            Object object2;
            this.openStream();
            while (true) {
                if (this.done || (object2 = this.writerThread) != object) {
                    object = this.writer;
                    synchronized (object) {
                        break;
                    }
                }
                Packet packet = this.nextPacket();
                if (packet == null) continue;
                object2 = this.writer;
                synchronized (object2) {
                    this.writer.write(packet.toXML());
                    this.writer.flush();
                    this.lastActive = System.currentTimeMillis();
                }
            }
            {
                while (true) {
                    if (this.queue.isEmpty()) {
                        this.writer.flush();
                        break;
                    }
                    object2 = (Packet)this.queue.remove();
                    this.writer.write(((Packet)object2).toXML());
                }
            }
            this.queue.clear();
        }
        catch (IOException iOException) {
            if (this.done) return;
            this.done = true;
            this.connection.packetReader.notifyConnectionError(iOException);
            return;
        }
        {
            this.writer.write("</stream:stream>");
            this.writer.flush();
            this.writer.close();
            return;
        }
        catch (Exception exception) {
            try {
                this.writer.close();
                return;
            }
            catch (Exception exception2) {
                return;
            }
        }
        catch (Throwable throwable) {
            try {
                this.writer.close();
            }
            catch (Exception exception) {
                throw throwable;
            }
            throw throwable;
            catch (Exception exception) {
                return;
            }
        }
    }

    void cleanup() {
        this.connection.interceptors.clear();
        this.connection.sendListeners.clear();
    }

    protected void init() {
        this.writer = this.connection.writer;
        this.done = false;
        this.writerThread = new Thread(){

            @Override
            public void run() {
                PacketWriter.this.writePackets(this);
            }
        };
        this.writerThread.setName("Smack Packet Writer (" + this.connection.connectionCounterValue + ")");
        this.writerThread.setDaemon(true);
    }

    void openStream() throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<stream:stream");
        stringBuilder.append(" to=\"").append(this.connection.getServiceName()).append("\"");
        stringBuilder.append(" xmlns=\"jabber:client\"");
        stringBuilder.append(" xmlns:stream=\"http://etherx.jabber.org/streams\"");
        stringBuilder.append(" version=\"1.0\">");
        this.writer.write(stringBuilder.toString());
        this.writer.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendPacket(Packet packet) {
        if (!this.done) {
            BlockingQueue<Packet> blockingQueue;
            this.connection.firePacketInterceptors(packet);
            try {
                this.queue.put(packet);
                blockingQueue = this.queue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                return;
            }
            synchronized (blockingQueue) {
                this.queue.notifyAll();
            }
            this.connection.firePacketSendingListeners(packet);
        }
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        this.done = true;
        BlockingQueue<Packet> blockingQueue = this.queue;
        synchronized (blockingQueue) {
            this.queue.notifyAll();
            return;
        }
    }

    void startKeepAliveProcess() {
        int n2 = SmackConfiguration.getKeepAliveInterval();
        if (n2 > 0) {
            KeepAliveTask keepAliveTask = new KeepAliveTask(n2);
            this.keepAliveThread = new Thread(keepAliveTask);
            keepAliveTask.setThread(this.keepAliveThread);
            this.keepAliveThread.setDaemon(true);
            this.keepAliveThread.setName("Smack Keep Alive (" + this.connection.connectionCounterValue + ")");
            this.keepAliveThread.start();
        }
    }

    public void startup() {
        this.writerThread.start();
    }

    private class KeepAliveTask
    implements Runnable {
        private int delay;
        private Thread thread;

        public KeepAliveTask(int n2) {
            this.delay = n2;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                Thread.sleep(15000L);
            }
            catch (InterruptedException interruptedException) {}
            while (!PacketWriter.this.done && PacketWriter.this.keepAliveThread == this.thread) {
                Writer writer = PacketWriter.this.writer;
                synchronized (writer) {
                    long l2 = System.currentTimeMillis();
                    long l3 = PacketWriter.this.lastActive;
                    int n2 = this.delay;
                    if (l2 - l3 >= (long)n2) {
                        try {
                            PacketWriter.this.writer.write(" ");
                            PacketWriter.this.writer.flush();
                        }
                        catch (Exception exception) {}
                    }
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }

        protected void setThread(Thread thread) {
            this.thread = thread;
        }
    }
}

