/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smack.sasl.SASLMechanism;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

class PacketReader {
    private XMPPConnection connection;
    private String connectionID = null;
    private Semaphore connectionSemaphore;
    private boolean done;
    private ExecutorService listenerExecutor;
    private XmlPullParser parser;
    private Thread readerThread;

    protected PacketReader(XMPPConnection xMPPConnection) {
        this.connection = xMPPConnection;
        this.init();
    }

    private void parseFeatures(XmlPullParser xmlPullParser) throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        while (true) {
            if (bl3) {
                if (this.connection.isSecureConnection() || bl || this.connection.getConfiguration().getSecurityMode() != ConnectionConfiguration.SecurityMode.required) break;
                throw new XMPPException("Server does not support security (TLS), but security required by connection configuration.", new XMPPError(XMPPError.Condition.forbidden));
            }
            int n2 = xmlPullParser.next();
            if (n2 == 2) {
                if (xmlPullParser.getName().equals("starttls")) {
                    bl = true;
                    continue;
                }
                if (xmlPullParser.getName().equals("mechanisms")) {
                    this.connection.getSASLAuthentication().setAvailableSASLMethods(PacketParserUtils.parseMechanisms(xmlPullParser));
                    continue;
                }
                if (xmlPullParser.getName().equals("bind")) {
                    this.connection.getSASLAuthentication().bindingRequired();
                    continue;
                }
                if (xmlPullParser.getName().equals("ver")) {
                    this.connection.getConfiguration().setRosterVersioningAvailable(true);
                    continue;
                }
                if (xmlPullParser.getName().equals("c")) {
                    String string2 = xmlPullParser.getAttributeValue(null, "node");
                    String string3 = xmlPullParser.getAttributeValue(null, "ver");
                    string2 = String.valueOf(string2) + "#" + string3;
                    this.connection.getConfiguration().setCapsNode(string2);
                    continue;
                }
                if (xmlPullParser.getName().equals("session")) {
                    this.connection.getSASLAuthentication().sessionsSupported();
                    continue;
                }
                if (xmlPullParser.getName().equals("compression")) {
                    this.connection.setAvailableCompressionMethods(PacketParserUtils.parseCompressionMethods(xmlPullParser));
                    continue;
                }
                if (!xmlPullParser.getName().equals("register")) continue;
                this.connection.getAccountManager().setSupportsAccountCreation(true);
                continue;
            }
            if (n2 != 3) continue;
            if (xmlPullParser.getName().equals("starttls")) {
                this.connection.startTLSReceived(bl2);
                continue;
            }
            if (xmlPullParser.getName().equals("required") && bl) {
                bl2 = true;
                continue;
            }
            if (!xmlPullParser.getName().equals("features")) continue;
            bl3 = true;
        }
        if (!bl || this.connection.getConfiguration().getSecurityMode() == ConnectionConfiguration.SecurityMode.disabled) {
            this.releaseConnectionIDLock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parsePackets(Thread var1_1) {
        try {
            var2_3 = this.parser.getEventType();
            block3: while (var2_3 == 2) {
                if (this.parser.getName().equals("message")) {
                    this.processPacket(PacketParserUtils.parseMessage(this.parser));
lbl6:
                    // 15 sources

                    while (true) {
                        var2_3 = this.parser.next();
                        if (this.done || var2_3 == 1) return;
                        if (var1_1 == this.readerThread) continue block3;
                        return;
                    }
                }
                if (!this.parser.getName().equals("iq")) ** GOTO lbl-1000
                this.processPacket(PacketParserUtils.parseIQ(this.parser, this.connection));
                ** GOTO lbl6
            }
            ** GOTO lbl77
        }
        catch (Exception var1_2) {
            if (this.done) return;
            this.notifyConnectionError(var1_2);
            return;
        }
lbl-1000:
        // 1 sources

        {
            block14: {
                block22: {
                    block21: {
                        block19: {
                            block20: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block15: {
                                                if (!this.parser.getName().equals("presence")) break block15;
                                                this.processPacket(PacketParserUtils.parsePresence(this.parser));
                                                ** GOTO lbl6
                                            }
                                            if (!this.parser.getName().equals("stream")) break block16;
                                            if (!"jabber:client".equals(this.parser.getNamespace(null))) ** GOTO lbl6
                                            var2_3 = 0;
lbl26:
                                            // 2 sources

                                            while (true) {
                                                if (var2_3 >= this.parser.getAttributeCount()) ** GOTO lbl6
                                                if (this.parser.getAttributeName(var2_3).equals("id")) {
                                                    this.connectionID = this.parser.getAttributeValue(var2_3);
                                                    if (!"1.0".equals(this.parser.getAttributeValue("", "version"))) {
                                                        this.releaseConnectionIDLock();
                                                    }
                                                    break block14;
                                                }
                                                if (this.parser.getAttributeName(var2_3).equals("from")) {
                                                    this.connection.config.setServiceName(this.parser.getAttributeValue(var2_3));
                                                }
                                                break block14;
                                                break;
                                            }
                                        }
                                        if (this.parser.getName().equals("error")) {
                                            throw new XMPPException(PacketParserUtils.parseStreamError(this.parser));
                                        }
                                        if (!this.parser.getName().equals("features")) break block17;
                                        this.parseFeatures(this.parser);
                                        ** GOTO lbl6
                                    }
                                    if (!this.parser.getName().equals("proceed")) break block18;
                                    this.connection.proceedTLSReceived();
                                    this.resetParser();
                                    ** GOTO lbl6
                                }
                                if (!this.parser.getName().equals("failure")) break block19;
                                var3_4 = this.parser.getNamespace(null);
                                if ("urn:ietf:params:xml:ns:xmpp-tls".equals(var3_4)) {
                                    throw new Exception("TLS negotiation has failed");
                                }
                                if (!"http://jabber.org/protocol/compress".equals(var3_4)) break block20;
                                this.connection.streamCompressionDenied();
                                ** GOTO lbl6
                            }
                            this.processPacket(PacketParserUtils.parseSASLFailure(this.parser));
                            this.connection.getSASLAuthentication().authenticationFailed();
                            ** GOTO lbl6
                        }
                        if (!this.parser.getName().equals("challenge")) break block21;
                        var3_4 = this.parser.nextText();
                        this.processPacket(new SASLMechanism.Challenge(var3_4));
                        this.connection.getSASLAuthentication().challengeReceived(var3_4);
                        ** GOTO lbl6
                    }
                    if (!this.parser.getName().equals("success")) break block22;
                    this.processPacket(new SASLMechanism.Success(this.parser.nextText()));
                    this.connection.packetWriter.openStream();
                    this.resetParser();
                    this.connection.getSASLAuthentication().authenticated();
                    ** GOTO lbl6
                }
                if (!this.parser.getName().equals("compressed")) ** GOTO lbl6
                this.connection.startStreamCompression();
                this.resetParser();
                ** GOTO lbl6
lbl77:
                // 1 sources

                if (var2_3 != 3 || !this.parser.getName().equals("stream")) ** GOTO lbl6
                this.connection.disconnect();
                ** continue;
            }
            ++var2_3;
            ** continue;
        }
    }

    private void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        Iterator<PacketCollector> iterator = this.connection.getPacketCollectors().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                this.listenerExecutor.submit(new ListenerNotification(packet));
                return;
            }
            iterator.next().processPacket(packet);
        }
    }

    private void releaseConnectionIDLock() {
        this.connectionSemaphore.release();
    }

    private void resetParser() {
        try {
            this.parser = XmlPullParserFactory.newInstance().newPullParser();
            this.parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            this.parser.setInput(this.connection.reader);
            return;
        }
        catch (XmlPullParserException xmlPullParserException) {
            xmlPullParserException.printStackTrace();
            return;
        }
    }

    void cleanup() {
        this.connection.recvListeners.clear();
        this.connection.collectors.clear();
    }

    protected void init() {
        this.done = false;
        this.connectionID = null;
        this.readerThread = new Thread(){

            @Override
            public void run() {
                PacketReader.this.parsePackets(this);
            }
        };
        this.readerThread.setName("Smack Packet Reader (" + this.connection.connectionCounterValue + ")");
        this.readerThread.setDaemon(true);
        this.listenerExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                runnable = new Thread(runnable, "Smack Listener Processor (" + ((PacketReader)PacketReader.this).connection.connectionCounterValue + ")");
                ((Thread)runnable).setDaemon(true);
                return runnable;
            }
        });
        this.resetParser();
    }

    void notifyConnectionError(Exception exception) {
        this.done = true;
        this.connection.shutdown(new Presence(Presence.Type.unavailable));
        exception.printStackTrace();
        Iterator<ConnectionListener> iterator = this.connection.getConnectionListeners().iterator();
        while (iterator.hasNext()) {
            ConnectionListener connectionListener = iterator.next();
            try {
                connectionListener.connectionClosedOnError(exception);
                continue;
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    protected void notifyReconnection() {
        Iterator<ConnectionListener> iterator = this.connection.getConnectionListeners().iterator();
        while (iterator.hasNext()) {
            ConnectionListener connectionListener = iterator.next();
            try {
                connectionListener.reconnectionSuccessful();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        if (!this.done) {
            for (ConnectionListener connectionListener : this.connection.getConnectionListeners()) {
                try {
                    connectionListener.connectionClosed();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.done = true;
        this.listenerExecutor.shutdown();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startup() throws XMPPException {
        this.connectionSemaphore = new Semaphore(1);
        this.readerThread.start();
        try {
            this.connectionSemaphore.acquire();
            int n2 = SmackConfiguration.getPacketReplyTimeout();
            this.connectionSemaphore.tryAcquire(n2 * 3, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {}
        if (this.connectionID == null) {
            throw new XMPPException("Connection failed. No response from server.");
        }
        this.connection.connectionID = this.connectionID;
    }

    private class ListenerNotification
    implements Runnable {
        private Packet packet;

        public ListenerNotification(Packet packet) {
            this.packet = packet;
        }

        @Override
        public void run() {
            Iterator iterator = ((PacketReader)PacketReader.this).connection.recvListeners.values().iterator();
            while (iterator.hasNext()) {
                ((Connection.ListenerWrapper)iterator.next()).notifyListener(this.packet);
            }
            return;
        }
    }
}

