/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class PacketCollector {
    private static final int MAX_PACKETS = 65536;
    private boolean cancelled = false;
    private Connection conection;
    private PacketFilter packetFilter;
    private LinkedBlockingQueue<Packet> resultQueue;

    protected PacketCollector(Connection connection, PacketFilter packetFilter) {
        this.conection = connection;
        this.packetFilter = packetFilter;
        this.resultQueue = new LinkedBlockingQueue(65536);
    }

    public void cancel() {
        if (!this.cancelled) {
            this.conection.removePacketCollector(this);
            this.cancelled = true;
        }
    }

    public PacketFilter getPacketFilter() {
        return this.packetFilter;
    }

    public Packet nextResult() {
        while (true) {
            try {
                Packet packet = this.resultQueue.take();
                return packet;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public Packet nextResult(long l2) {
        long l3 = System.currentTimeMillis();
        while (true) {
            try {
                Packet packet = this.resultQueue.poll(l2, TimeUnit.MILLISECONDS);
                return packet;
            }
            catch (InterruptedException interruptedException) {
                if (System.currentTimeMillis() < l3 + l2) continue;
                return null;
            }
            break;
        }
    }

    public Packet pollResult() {
        return this.resultQueue.poll();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void processPacket(Packet packet) {
        synchronized (this) {
            if (packet != null && (this.packetFilter == null || this.packetFilter.accept(packet))) {
                while (!this.resultQueue.offer(packet)) {
                    this.resultQueue.poll();
                }
            }
            return;
        }
    }
}

