/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import org.apache.harmony.javax.security.auth.callback.Callback;
import org.apache.harmony.javax.security.auth.callback.CallbackHandler;
import org.apache.harmony.javax.security.auth.callback.PasswordCallback;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.UserAuthentication;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketIDFilter;
import org.jivesoftware.smack.packet.Authentication;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;

class NonSASLAuthentication
implements UserAuthentication {
    private Connection connection;

    public NonSASLAuthentication(Connection connection) {
        this.connection = connection;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String authenticate(String object, String object2, String string2) throws XMPPException {
        IQ iQ = new Authentication();
        iQ.setType(IQ.Type.GET);
        ((Authentication)iQ).setUsername((String)object);
        Object object3 = this.connection.createPacketCollector(new PacketIDFilter(iQ.getPacketID()));
        this.connection.sendPacket(iQ);
        iQ = (IQ)((PacketCollector)object3).nextResult(SmackConfiguration.getPacketReplyTimeout());
        if (iQ == null) {
            throw new XMPPException("No response from the server.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        iQ = (Authentication)iQ;
        ((PacketCollector)object3).cancel();
        object3 = new Authentication();
        ((Authentication)object3).setUsername((String)object);
        if (((Authentication)iQ).getDigest() != null) {
            ((Authentication)object3).setDigest(this.connection.getConnectionID(), (String)object2);
        } else {
            if (((Authentication)iQ).getPassword() == null) {
                throw new XMPPException("Server does not support compatible authentication mechanism.");
            }
            ((Authentication)object3).setPassword((String)object2);
        }
        ((Authentication)object3).setResource(string2);
        object = this.connection.createPacketCollector(new PacketIDFilter(((Packet)object3).getPacketID()));
        this.connection.sendPacket((Packet)object3);
        object2 = (IQ)((PacketCollector)object).nextResult(SmackConfiguration.getPacketReplyTimeout());
        if (object2 == null) {
            throw new XMPPException("Authentication failed.");
        }
        if (((IQ)object2).getType() == IQ.Type.ERROR) {
            throw new XMPPException(((Packet)object2).getError());
        }
        ((PacketCollector)object).cancel();
        return ((Packet)object2).getTo();
    }

    @Override
    public String authenticate(String string2, String string3, CallbackHandler callbackHandler) throws XMPPException {
        PasswordCallback passwordCallback = new PasswordCallback("Password: ", false);
        try {
            callbackHandler.handle(new Callback[]{passwordCallback});
            string2 = this.authenticate(string2, String.valueOf(passwordCallback.getPassword()), string3);
            return string2;
        }
        catch (Exception exception) {
            throw new XMPPException("Unable to determine password.", exception);
        }
    }

    @Override
    public String authenticateAnonymously() throws XMPPException {
        IQ iQ = new Authentication();
        PacketCollector packetCollector = this.connection.createPacketCollector(new PacketIDFilter(iQ.getPacketID()));
        this.connection.sendPacket(iQ);
        iQ = (IQ)packetCollector.nextResult(SmackConfiguration.getPacketReplyTimeout());
        if (iQ == null) {
            throw new XMPPException("Anonymous login failed.");
        }
        if (iQ.getType() == IQ.Type.ERROR) {
            throw new XMPPException(iQ.getError());
        }
        packetCollector.cancel();
        if (iQ.getTo() != null) {
            return iQ.getTo();
        }
        return String.valueOf(this.connection.getServiceName()) + "/" + ((Authentication)iQ).getResource();
    }
}

