/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterStorage;
import org.jivesoftware.smack.SASLAuthentication;
import org.jivesoftware.smack.SmackConfiguration;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;

public abstract class Connection {
    public static boolean DEBUG_ENABLED;
    private static final AtomicInteger connectionCounter;
    private static final Set<ConnectionCreationListener> connectionEstablishedListeners;
    private AccountManager accountManager = null;
    private ChatManager chatManager = null;
    protected final Collection<PacketCollector> collectors;
    protected final ConnectionConfiguration config;
    protected final int connectionCounterValue;
    protected final Collection<ConnectionListener> connectionListeners = new CopyOnWriteArrayList<ConnectionListener>();
    protected final Map<PacketInterceptor, InterceptorWrapper> interceptors;
    protected Reader reader;
    protected final Map<PacketListener, ListenerWrapper> recvListeners;
    protected RosterStorage rosterStorage;
    protected SASLAuthentication saslAuthentication;
    protected final Map<PacketListener, ListenerWrapper> sendListeners;
    protected Writer writer;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        connectionCounter = new AtomicInteger(0);
        connectionEstablishedListeners = new CopyOnWriteArraySet<ConnectionCreationListener>();
        DEBUG_ENABLED = false;
        try {
            DEBUG_ENABLED = Boolean.getBoolean("smack.debugEnabled");
        }
        catch (Exception exception) {}
        SmackConfiguration.getVersion();
    }

    protected Connection(ConnectionConfiguration connectionConfiguration) {
        this.collectors = new ConcurrentLinkedQueue<PacketCollector>();
        this.recvListeners = new ConcurrentHashMap<PacketListener, ListenerWrapper>();
        this.sendListeners = new ConcurrentHashMap<PacketListener, ListenerWrapper>();
        this.interceptors = new ConcurrentHashMap<PacketInterceptor, InterceptorWrapper>();
        this.saslAuthentication = new SASLAuthentication(this);
        this.connectionCounterValue = connectionCounter.getAndIncrement();
        this.config = connectionConfiguration;
    }

    public static void addConnectionCreationListener(ConnectionCreationListener connectionCreationListener) {
        connectionEstablishedListeners.add(connectionCreationListener);
    }

    protected static Collection<ConnectionCreationListener> getConnectionCreationListeners() {
        return Collections.unmodifiableCollection(connectionEstablishedListeners);
    }

    public static void removeConnectionCreationListener(ConnectionCreationListener connectionCreationListener) {
        connectionEstablishedListeners.remove(connectionCreationListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addConnectionListener(ConnectionListener connectionListener) {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected to server.");
        }
        if (connectionListener == null || this.connectionListeners.contains(connectionListener)) {
            return;
        }
        this.connectionListeners.add(connectionListener);
    }

    public void addPacketInterceptor(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
        if (packetInterceptor == null) {
            throw new NullPointerException("Packet interceptor is null.");
        }
        this.interceptors.put(packetInterceptor, new InterceptorWrapper(packetInterceptor, packetFilter));
    }

    public void addPacketListener(PacketListener packetListener, PacketFilter object) {
        if (packetListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        object = new ListenerWrapper(packetListener, (PacketFilter)object);
        this.recvListeners.put(packetListener, (ListenerWrapper)object);
    }

    public void addPacketSendingListener(PacketListener packetListener, PacketFilter object) {
        if (packetListener == null) {
            throw new NullPointerException("Packet listener is null.");
        }
        object = new ListenerWrapper(packetListener, (PacketFilter)object);
        this.sendListeners.put(packetListener, (ListenerWrapper)object);
    }

    public abstract void connect() throws XMPPException;

    public PacketCollector createPacketCollector(PacketFilter object) {
        object = new PacketCollector(this, (PacketFilter)object);
        this.collectors.add((PacketCollector)object);
        return object;
    }

    public void disconnect() {
        this.disconnect(new Presence(Presence.Type.unavailable));
    }

    public abstract void disconnect(Presence var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void firePacketInterceptors(Packet packet) {
        if (packet == null) return;
        Iterator<InterceptorWrapper> iterator = this.interceptors.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().notifyListener(packet);
        }
        return;
    }

    protected void firePacketSendingListeners(Packet packet) {
        Iterator<ListenerWrapper> iterator = this.sendListeners.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().notifyListener(packet);
        }
        return;
    }

    public AccountManager getAccountManager() {
        if (this.accountManager == null) {
            this.accountManager = new AccountManager(this);
        }
        return this.accountManager;
    }

    public String getCapsNode() {
        return this.config.getCapsNode();
    }

    public ChatManager getChatManager() {
        synchronized (this) {
            if (this.chatManager == null) {
                this.chatManager = new ChatManager(this);
            }
            ChatManager chatManager = this.chatManager;
            return chatManager;
        }
    }

    protected ConnectionConfiguration getConfiguration() {
        return this.config;
    }

    public abstract String getConnectionID();

    protected Collection<ConnectionListener> getConnectionListeners() {
        return this.connectionListeners;
    }

    public String getHost() {
        return this.config.getHost();
    }

    protected Collection<PacketCollector> getPacketCollectors() {
        return this.collectors;
    }

    protected Map<PacketInterceptor, InterceptorWrapper> getPacketInterceptors() {
        return this.interceptors;
    }

    protected Map<PacketListener, ListenerWrapper> getPacketListeners() {
        return this.recvListeners;
    }

    protected Map<PacketListener, ListenerWrapper> getPacketSendingListeners() {
        return this.sendListeners;
    }

    public int getPort() {
        return this.config.getPort();
    }

    public abstract Roster getRoster();

    public SASLAuthentication getSASLAuthentication() {
        return this.saslAuthentication;
    }

    public String getServiceName() {
        return this.config.getServiceName();
    }

    public abstract String getUser();

    public abstract boolean isAnonymous();

    public abstract boolean isAuthenticated();

    public abstract boolean isConnected();

    protected boolean isReconnectionAllowed() {
        return this.config.isReconnectionAllowed();
    }

    public abstract boolean isSecureConnection();

    public boolean isSendPresence() {
        return this.config.isSendPresence();
    }

    public abstract boolean isUsingCompression();

    public void login(String string2, String string3) throws XMPPException {
        this.login(string2, string3, "Smack");
    }

    public abstract void login(String var1, String var2, String var3) throws XMPPException;

    public abstract void loginAnonymously() throws XMPPException;

    public void removeConnectionListener(ConnectionListener connectionListener) {
        this.connectionListeners.remove(connectionListener);
    }

    protected void removePacketCollector(PacketCollector packetCollector) {
        this.collectors.remove(packetCollector);
    }

    public void removePacketInterceptor(PacketInterceptor packetInterceptor) {
        this.interceptors.remove(packetInterceptor);
    }

    public void removePacketListener(PacketListener packetListener) {
        this.recvListeners.remove(packetListener);
    }

    public void removePacketSendingListener(PacketListener packetListener) {
        this.sendListeners.remove(packetListener);
    }

    public abstract void sendPacket(Packet var1);

    public abstract void setRosterStorage(RosterStorage var1) throws IllegalStateException;

    protected static class InterceptorWrapper {
        private PacketFilter packetFilter;
        private PacketInterceptor packetInterceptor;

        public InterceptorWrapper(PacketInterceptor packetInterceptor, PacketFilter packetFilter) {
            this.packetInterceptor = packetInterceptor;
            this.packetFilter = packetFilter;
        }

        /*
         * Enabled aggressive block sorting
         */
        public boolean equals(Object object) {
            block5: {
                block4: {
                    if (object == null) break block4;
                    if (object instanceof InterceptorWrapper) {
                        return ((InterceptorWrapper)object).packetInterceptor.equals(this.packetInterceptor);
                    }
                    if (object instanceof PacketInterceptor) break block5;
                }
                return false;
            }
            return object.equals(this.packetInterceptor);
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetInterceptor.interceptPacket(packet);
            }
        }
    }

    protected static class ListenerWrapper {
        private PacketFilter packetFilter;
        private PacketListener packetListener;

        public ListenerWrapper(PacketListener packetListener, PacketFilter packetFilter) {
            this.packetListener = packetListener;
            this.packetFilter = packetFilter;
        }

        public void notifyListener(Packet packet) {
            if (this.packetFilter == null || this.packetFilter.accept(packet)) {
                this.packetListener.processPacket(packet);
            }
        }
    }
}

